/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemorySpaceRendering;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPMemoryByte;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.osgi.util.NLS;

public class S32DSFPRendering
extends MemorySpaceRendering {
    private FPutilities.FPDataType type;
    private static final String SCI_NOTATION_FORMAT = "%.{0}e";
    private int numberOfDecimals = 4;

    public S32DSFPRendering(String id) {
        super(id);
    }

    @Override
    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        this.type = this.getAddressableSize() > FPutilities.FPDataType.FLOAT.getByteLength() ? FPutilities.FPDataType.DOUBLE : FPutilities.FPDataType.FLOAT;
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        FPMemoryByte[] fpdata = (FPMemoryByte[])Arrays.stream(data).map(byt -> new FPMemoryByte(byt.getValue(), byt.getFlags())).toArray(FPMemoryByte[]::new);
        return this.sciNotationString(fpdata, this.type, this.getEndianess(data) == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public String sciNotationString(FPMemoryByte[] data, FPutilities.FPDataType dataType, ByteOrder byteOrder) {
        String textString = null;
        boolean isNotReadable = Arrays.stream(data).anyMatch(dataByte -> !dataByte.isReadable());
        if (isNotReadable) {
            return FPutilities.fillString((int)this.numberOfDecimals, (char)'?');
        }
        if (dataType == FPutilities.FPDataType.FLOAT) {
            float floatValue = ByteBuffer.wrap(FPutilities.memoryBytesToByteArray((FPMemoryByte[])data)).order(byteOrder).getFloat();
            floatValue = FPutilities.floatLimitCheck((float)floatValue);
            textString = String.format(NLS.bind((String)SCI_NOTATION_FORMAT, (Object)this.numberOfDecimals), Float.valueOf(floatValue));
        }
        if (dataType == FPutilities.FPDataType.DOUBLE) {
            double doubleValue = ByteBuffer.wrap(FPutilities.memoryBytesToByteArray((FPMemoryByte[])data)).order(byteOrder).getDouble();
            doubleValue = FPutilities.doubleLimitCheck((double)doubleValue);
            textString = String.format(NLS.bind((String)SCI_NOTATION_FORMAT, (Object)this.numberOfDecimals), doubleValue);
        }
        return textString;
    }

    public int getBytesPerColumn() {
        return this.type.getByteLength();
    }

    @Override
    public String toString() {
        return Messages.MemoryRendering_Floating_Point;
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bigEndianessBytes = null;
        if (this.type == FPutilities.FPDataType.FLOAT) {
            bigEndianessBytes = ByteBuffer.allocate(4).putFloat(Float.parseFloat(data)).array();
        } else if (this.type == FPutilities.FPDataType.DOUBLE) {
            bigEndianessBytes = ByteBuffer.allocate(8).putDouble(Double.parseDouble(data)).array();
        } else {
            return new byte[0];
        }
        if (this.getEndianess(currentValues) != 1) {
            byte[] littleEndianessBytes = new byte[this.type.getByteLength()];
            int i = this.type.getByteLength() - 1;
            byte[] byArray = bigEndianessBytes;
            int n = bigEndianessBytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                littleEndianessBytes[i--] = b;
                ++n2;
            }
            bigEndianessBytes = littleEndianessBytes;
        }
        return bigEndianessBytes;
    }

    private int getEndianess(MemoryByte[] bytes) {
        int endianess = this.getDisplayEndianess();
        return endianess == 2 ? this.getBytesEndianess(bytes) : endianess;
    }

    public int getNumCharsPerByte() {
        return -1;
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager submenu = new MenuManager(Messages.MemoryRenderingFloatingPoint_Floating_Point_Type);
        SetTypeAction floatType = new SetTypeAction(FPutilities.FPDataType.FLOAT, Messages.MemoryRenderingFloatingPoint_32_bit_Single_Precision);
        floatType.setChecked(this.type.equals((Object)FPutilities.FPDataType.FLOAT));
        floatType.setEnabled(this.getAddressableSize() <= FPutilities.FPDataType.FLOAT.getByteLength());
        submenu.add((IAction)floatType);
        SetTypeAction doubleType = new SetTypeAction(FPutilities.FPDataType.DOUBLE, Messages.MemoryRenderingFloatingPoint_64_bit_Double_Precision);
        doubleType.setChecked(this.type.equals((Object)FPutilities.FPDataType.DOUBLE));
        doubleType.setEnabled(this.getAddressableSize() <= FPutilities.FPDataType.DOUBLE.getByteLength());
        submenu.add((IAction)doubleType);
        MenuManager submenu2 = new MenuManager(Messages.MemoryRenderingFloatingPoint_Display_Precision);
        SetPrecisionAction fourDecimal = new SetPrecisionAction(4, Messages.MemoryRenderingFloatingPoint_Four_significant_digits);
        fourDecimal.setChecked(this.numberOfDecimals == 4);
        submenu2.add((IAction)fourDecimal);
        SetPrecisionAction eightDecimal = new SetPrecisionAction(8, Messages.MemoryRenderingFloatingPoint_Eight_significant_digits);
        eightDecimal.setChecked(this.numberOfDecimals == 8);
        submenu2.add((IAction)eightDecimal);
        menu.add((IContributionItem)submenu);
        menu.add((IContributionItem)submenu2);
        submenu.updateAll(true);
        submenu2.updateAll(true);
    }

    private class SetPrecisionAction
    extends Action {
        private int showPrecision;

        public SetPrecisionAction(int precision, String name) {
            super(name);
            this.showPrecision = precision;
        }

        public void run() {
            S32DSFPRendering.this.numberOfDecimals = this.showPrecision;
            S32DSFPRendering.this.refresh();
        }
    }

    private class SetTypeAction
    extends Action {
        private FPutilities.FPDataType setType;

        public SetTypeAction(FPutilities.FPDataType toSetType, String name) {
            super(name);
            this.setType = toSetType;
        }

        public void run() {
            S32DSFPRendering.this.type = this.setType;
            S32DSFPRendering.this.format(S32DSFPRendering.this.getBytesPerLine(), S32DSFPRendering.this.type.getByteLength());
            S32DSFPRendering.this.refresh();
        }
    }
}

