/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.contentassist.DynamicTypeContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class EditLogicalStructureDialog
extends StatusDialog
implements Listener,
ISelectionChangedListener,
IDocumentListener,
DynamicTypeContext.ITypeProvider {
    private final JavaLogicalStructure fLogicalStructure;
    private Text fQualifiedTypeNameText;
    private Text fDescriptionText;
    private TableViewer fAttributeListViewer;
    private Button fSubTypeButton;
    private Button fValueButton;
    private Button fVariablesButton;
    private Button fAttributeUpButton;
    private Button fAttributeDownButton;
    private JDISourceViewer fSnippetViewer;
    private Document fSnippetDocument;
    private Button fBrowseTypeButton;
    private Button fAttributeAddButton;
    private Button fAttributeRemoveButton;
    private Text fAttributeNameText;
    private Composite fAttributesContainer;
    private Group fCodeGroup;
    private Composite fParentComposite;
    private AttributesContentProvider fAttributesContentProvider;
    private String fValueTmp;
    private IStructuredSelection fCurrentAttributeSelection;
    private IType fType;
    private boolean fTypeSearched = false;
    private DisplayViewerConfiguration fViewerConfiguration;
    private IHandlerActivation fHandlerActivation;

    public EditLogicalStructureDialog(Shell parentShell, JavaLogicalStructure logicalStructure) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        if (logicalStructure.getQualifiedTypeName().length() == 0) {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_32);
        } else {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_31);
        }
        this.fLogicalStructure = logicalStructure;
    }

    protected Control createDialogArea(Composite parent) {
        boolean isValue;
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.EDIT_LOGICAL_STRUCTURE_DIALOG);
        this.fParentComposite = parent;
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (EditLogicalStructureDialog.this.fSnippetViewer.canDoOperation(13) && EditLogicalStructureDialog.this.fSnippetViewer.getControl().isFocusControl()) {
                    EditLogicalStructureDialog.this.findCorrespondingType();
                    EditLogicalStructureDialog.this.fSnippetViewer.doOperation(13);
                }
                return null;
            }
        };
        IHandlerService handlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
        this.fHandlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        Composite typeNameDescriptionContainer = SWTFactory.createComposite((Composite)container, (Font)container.getFont(), (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)typeNameDescriptionContainer, (String)DebugUIMessages.EditLogicalStructureDialog_0, (int)2);
        this.fQualifiedTypeNameText = SWTFactory.createSingleText((Composite)typeNameDescriptionContainer, (int)1);
        this.fQualifiedTypeNameText.addListener(24, (Listener)this);
        this.fBrowseTypeButton = SWTFactory.createPushButton((Composite)typeNameDescriptionContainer, (String)DebugUIMessages.EditLogicalStructureDialog_1, (String)DebugUIMessages.EditLogicalStructureDialog_25, null);
        this.fBrowseTypeButton.addListener(13, (Listener)this);
        SWTFactory.createLabel((Composite)typeNameDescriptionContainer, (String)DebugUIMessages.EditLogicalStructureDialog_2, (int)2);
        this.fDescriptionText = SWTFactory.createSingleText((Composite)typeNameDescriptionContainer, (int)2);
        this.fDescriptionText.addListener(24, (Listener)this);
        this.fSubTypeButton = SWTFactory.createCheckButton((Composite)typeNameDescriptionContainer, (String)DebugUIMessages.EditLogicalStructureDialog_3, null, (boolean)false, (int)1);
        this.fSubTypeButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_26);
        Group radioContainer = SWTFactory.createGroup((Composite)container, (String)DebugUIMessages.EditLogicalStructureDialog_33, (int)1, (int)1, (int)768);
        this.fValueButton = SWTFactory.createRadioButton((Composite)radioContainer, (String)DebugUIMessages.EditLogicalStructureDialog_4);
        this.fValueButton.addListener(13, (Listener)this);
        this.fVariablesButton = SWTFactory.createRadioButton((Composite)radioContainer, (String)DebugUIMessages.EditLogicalStructureDialog_5);
        this.fAttributesContainer = SWTFactory.createComposite((Composite)container, (Font)container.getFont(), (int)2, (int)1, (int)768);
        boolean bl = isValue = this.fLogicalStructure.getValue() != null;
        if (!isValue) {
            this.createAttributeListWidgets();
        }
        this.fCodeGroup = SWTFactory.createGroup((Composite)container, (String)"", (int)1, (int)1, (int)1808);
        this.createCodeGroupWidgets(isValue);
        EditLogicalStructureDialog.applyDialogFont((Control)container);
        this.initializeData();
        return container;
    }

    private void createCodeGroupWidgets(boolean isValue) {
        if (isValue) {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_9);
        } else {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_7);
            Composite attributeNameContainer = SWTFactory.createComposite((Composite)this.fCodeGroup, (Font)this.fCodeGroup.getFont(), (int)2, (int)1, (int)768);
            ((GridLayout)attributeNameContainer.getLayout()).marginWidth = 0;
            SWTFactory.createLabel((Composite)attributeNameContainer, (String)DebugUIMessages.EditLogicalStructureDialog_8, (int)1);
            this.fAttributeNameText = SWTFactory.createSingleText((Composite)attributeNameContainer, (int)1);
            this.fAttributeNameText.addListener(24, (Listener)this);
            SWTFactory.createLabel((Composite)this.fCodeGroup, (String)DebugUIMessages.EditLogicalStructureDialog_9, (int)1);
        }
        this.fSnippetViewer = new JDISourceViewer((Composite)this.fCodeGroup, null, 0x2000B00);
        this.fSnippetViewer.setInput(this);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        if (this.fSnippetDocument == null) {
            this.fSnippetDocument = new Document();
            this.fSnippetDocument.addDocumentListener((IDocumentListener)this);
        }
        tools.setupJavaDocumentPartitioner((IDocument)this.fSnippetDocument, "___java_partitioning");
        if (this.fViewerConfiguration == null) {
            this.fViewerConfiguration = new DisplayViewerConfiguration(){

                @Override
                public IContentAssistProcessor getContentAssistantProcessor() {
                    return new JavaDebugContentAssistProcessor(new DynamicTypeContext(EditLogicalStructureDialog.this));
                }
            };
        }
        this.fSnippetViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)this.fSnippetDocument);
        Control control = this.fSnippetViewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(isValue ? 20 : 10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
    }

    private void createAttributeListWidgets() {
        this.fAttributeListViewer = new TableViewer(this.fAttributesContainer, 67586);
        Table table = (Table)this.fAttributeListViewer.getControl();
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(this.fAttributesContainer.getFont());
        if (this.fAttributesContentProvider == null) {
            this.fAttributesContentProvider = new AttributesContentProvider(this.fLogicalStructure.getVariables());
        }
        this.fAttributeListViewer.setContentProvider((IContentProvider)this.fAttributesContentProvider);
        this.fAttributeListViewer.setLabelProvider((IBaseLabelProvider)new AttributesLabelProvider());
        this.fAttributeListViewer.setInput((Object)this);
        this.fAttributeListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite attributeListButtonsCotnainer = SWTFactory.createComposite((Composite)this.fAttributesContainer, (Font)this.fAttributesContainer.getFont(), (int)1, (int)1, (int)0);
        this.fAttributeAddButton = SWTFactory.createPushButton((Composite)attributeListButtonsCotnainer, (String)DebugUIMessages.EditLogicalStructureDialog_10, (String)DebugUIMessages.EditLogicalStructureDialog_27, null);
        this.fAttributeAddButton.addListener(13, (Listener)this);
        this.fAttributeRemoveButton = SWTFactory.createPushButton((Composite)attributeListButtonsCotnainer, (String)DebugUIMessages.EditLogicalStructureDialog_11, (String)DebugUIMessages.EditLogicalStructureDialog_28, null);
        this.fAttributeRemoveButton.addListener(13, (Listener)this);
        this.fAttributeUpButton = SWTFactory.createPushButton((Composite)attributeListButtonsCotnainer, (String)DebugUIMessages.EditLogicalStructureDialog_12, (String)DebugUIMessages.EditLogicalStructureDialog_29, null);
        this.fAttributeUpButton.addListener(13, (Listener)this);
        this.fAttributeDownButton = SWTFactory.createPushButton((Composite)attributeListButtonsCotnainer, (String)DebugUIMessages.EditLogicalStructureDialog_13, (String)DebugUIMessages.EditLogicalStructureDialog_30, null);
        this.fAttributeDownButton.addListener(13, (Listener)this);
    }

    private void initializeData() {
        this.fQualifiedTypeNameText.setText(this.fLogicalStructure.getQualifiedTypeName());
        this.fDescriptionText.setText(this.fLogicalStructure.getDescription());
        this.fSubTypeButton.setSelection(this.fLogicalStructure.isSubtypes());
        this.fValueTmp = this.fLogicalStructure.getValue();
        if (this.fValueTmp == null) {
            this.fValueTmp = "";
            this.fVariablesButton.setSelection(true);
            this.setAttributesData(false);
        } else {
            this.fValueButton.setSelection(true);
            this.setAttributesData(true);
        }
        this.checkValues();
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        switch (event.type) {
            case 13: {
                if (source == this.fValueButton) {
                    this.toggleAttributesWidgets(this.fValueButton.getSelection());
                    this.checkValues();
                    break;
                }
                if (source == this.fBrowseTypeButton) {
                    this.selectType();
                    break;
                }
                if (source == this.fAttributeAddButton) {
                    this.addAttribute();
                    break;
                }
                if (source == this.fAttributeRemoveButton) {
                    this.removeAttribute();
                    break;
                }
                if (source == this.fAttributeUpButton) {
                    this.attributeUp();
                    break;
                }
                if (source != this.fAttributeDownButton) break;
                this.attributeDown();
                break;
            }
            case 24: {
                if (source == this.fAttributeNameText) {
                    this.saveNewAttributeName();
                    this.checkValues();
                    break;
                }
                if (source == this.fQualifiedTypeNameText) {
                    this.checkValues();
                    this.fTypeSearched = false;
                    break;
                }
                if (source != this.fDescriptionText) break;
                this.checkValues();
            }
        }
    }

    private void addAttribute() {
        String[] newAttribute = new String[]{DebugUIMessages.EditLogicalStructureDialog_14, DebugUIMessages.EditLogicalStructureDialog_15};
        this.fAttributesContentProvider.add(newAttribute);
        this.fAttributeListViewer.refresh();
        this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute));
    }

    private void removeAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            List selectedElements = selection.toList();
            String[] newSelectedElement = null;
            String[][] stringArray = this.fAttributesContentProvider.getElements();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] element = stringArray[n2];
                if (selectedElements.contains(element)) break;
                newSelectedElement = element;
                ++n2;
            }
            this.fAttributesContentProvider.remove(selectedElements);
            this.fAttributeListViewer.refresh();
            if (newSelectedElement == null) {
                String[][] newElements = this.fAttributesContentProvider.getElements();
                if (newElements.length > 0) {
                    this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newElements[0]));
                }
            } else {
                this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedElement));
            }
        }
    }

    private void attributeUp() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.up(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void attributeDown() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.down(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void saveNewAttributeName() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            variable[0] = this.fAttributeNameText.getText();
            this.fAttributeListViewer.refresh((Object)variable);
        }
    }

    private void toggleAttributesWidgets(boolean isValue) {
        Control child;
        int n;
        int n2;
        Control[] controlArray;
        if (!isValue) {
            this.fValueTmp = this.fSnippetDocument.get();
            this.createAttributeListWidgets();
        } else {
            this.saveAttributeValue();
            controlArray = this.fAttributesContainer.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                child = controlArray[n];
                child.dispose();
                ++n;
            }
        }
        controlArray = this.fCodeGroup.getChildren();
        n2 = controlArray.length;
        n = 0;
        while (n < n2) {
            child = controlArray[n];
            child.dispose();
            ++n;
        }
        this.fSnippetViewer.dispose();
        this.createCodeGroupWidgets(isValue);
        this.setAttributesData(isValue);
        this.fParentComposite.layout(true, true);
    }

    private void setAttributesData(boolean isValue) {
        if (isValue) {
            this.fSnippetDocument.set(this.fValueTmp);
        } else {
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            this.fCurrentAttributeSelection = new StructuredSelection();
            if (elements.length > 0) {
                StructuredSelection newSelection = new StructuredSelection(elements[0]);
                this.fAttributeListViewer.setSelection((ISelection)newSelection);
            } else {
                this.fAttributeListViewer.setSelection((ISelection)this.fCurrentAttributeSelection);
            }
        }
    }

    private void saveAttributeValue() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            ((String[])this.fCurrentAttributeSelection.getFirstElement())[1] = this.fSnippetDocument.get();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.saveAttributeValue();
        this.fCurrentAttributeSelection = (IStructuredSelection)event.getSelection();
        boolean sizeone = this.fCurrentAttributeSelection.size() == 1;
        this.fAttributeNameText.setEnabled(sizeone);
        this.fSnippetViewer.setEditable(sizeone);
        if (sizeone) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            this.fAttributeNameText.setText(variable[0]);
            this.fSnippetDocument.set(variable[1]);
            this.fAttributeNameText.setSelection(0, variable[0].length());
            this.fAttributeNameText.setFocus();
        } else {
            this.fAttributeNameText.setText("");
            this.fSnippetDocument.set("");
        }
        this.fAttributeRemoveButton.setEnabled(this.fCurrentAttributeSelection.size() > 0);
        int index = this.fAttributeListViewer.getTable().getSelectionIndex();
        this.fAttributeUpButton.setEnabled(sizeone && index != 0);
        this.fAttributeDownButton.setEnabled(sizeone && index != this.fAttributeListViewer.getTable().getItemCount() - 1);
    }

    public void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.fQualifiedTypeNameText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_16);
        } else if (this.fDescriptionText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_17);
        } else if (this.fValueButton.getSelection() && this.fSnippetDocument.get().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_18);
        } else if (this.fVariablesButton.getSelection()) {
            boolean oneElementSelected;
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            boolean bl = oneElementSelected = this.fCurrentAttributeSelection.size() == 1;
            if (elements.length == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_19);
            } else if (oneElementSelected && this.fAttributeNameText.getText().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_20);
            } else if (oneElementSelected && this.fSnippetDocument.get().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_21);
            } else {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String[] variable = (String[])element;
                    if (variable[0].trim().length() == 0) {
                        status.setError(DebugUIMessages.EditLogicalStructureDialog_22);
                        break;
                    }
                    if (!(variable[1].trim().length() != 0 || oneElementSelected && this.fCurrentAttributeSelection.getFirstElement() == variable)) {
                        status.setError(NLS.bind((String)DebugUIMessages.EditLogicalStructureDialog_23, (Object[])new String[]{variable[0]}));
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (!status.isError() && this.fType == null && this.fTypeSearched) {
            status.setWarning(DebugUIMessages.EditLogicalStructureDialog_24);
        }
        this.updateStatus(status);
    }

    private void selectType() {
        Shell shell = this.getShell();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)DebugUIMessages.DetailFormatterDialog_Select_type_9, (String)DebugUIMessages.DetailFormatterDialog_Select_type_10);
            return;
        }
        boolean allClosed = true;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isOpen()) {
                allClosed = false;
                break;
            }
            ++n2;
        }
        if (allClosed) {
            MessageDialog.openInformation((Shell)shell, (String)DebugUIMessages.DetailFormatterDialog_Select_type_9, (String)DebugUIMessages.DetailFormatterDialog_Select_type_10);
            return;
        }
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)this.fQualifiedTypeNameText.getText());
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.DetailFormatterDialog_Select_type_6;
            String message = DebugUIMessages.DetailFormatterDialog_Could_not_open_type_selection_dialog_for_detail_formatters_7;
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.DetailFormatterDialog_Select_type_8);
        dialog.setMessage(DebugUIMessages.DetailFormatterDialog_Select_a_type_to_format_when_displaying_its_detail_9);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fType = (IType)types[0];
            this.fQualifiedTypeNameText.setText(this.fType.getFullyQualifiedName());
            this.fTypeSearched = true;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.checkValues();
    }

    protected void okPressed() {
        this.fLogicalStructure.setType(this.fQualifiedTypeNameText.getText().trim());
        this.fLogicalStructure.setDescription(this.fDescriptionText.getText().trim());
        this.fLogicalStructure.setSubtypes(this.fSubTypeButton.getSelection());
        if (this.fValueButton.getSelection()) {
            this.fLogicalStructure.setValue(this.fSnippetDocument.get());
        } else {
            this.saveAttributeValue();
            this.fLogicalStructure.setValue(null);
        }
        if (this.fAttributesContentProvider != null) {
            this.fLogicalStructure.setVariables(this.fAttributesContentProvider.getElements());
        }
        super.okPressed();
    }

    private void findCorrespondingType() {
        if (this.fTypeSearched) {
            return;
        }
        this.fType = null;
        this.fTypeSearched = true;
        String pattern = this.fQualifiedTypeNameText.getText().trim().replace('$', '.');
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        SearchRequestor collector = new SearchRequestor((IProgressMonitor)monitor){
            private boolean fFirst = true;
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public void endReporting() {
                EditLogicalStructureDialog.this.checkValues();
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object enclosingElement = match.getElement();
                if (!this.fFirst) {
                    return;
                }
                this.fFirst = false;
                if (enclosingElement instanceof IType) {
                    EditLogicalStructureDialog.this.fType = (IType)enclosingElement;
                }
                this.val$monitor.setCanceled(true);
            }
        };
        SearchEngine engine = new SearchEngine(JavaCore.getWorkingCopies(null));
        SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            engine.search(searchPattern, participants, scope, collector, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    @Override
    public IType getType() {
        if (!this.fTypeSearched) {
            this.findCorrespondingType();
        }
        return this.fType;
    }

    public boolean close() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IHandlerService handlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
        handlerService.deactivateHandler(this.fHandlerActivation);
        this.fSnippetViewer.dispose();
        return super.close();
    }

    public class AttributesContentProvider
    implements IStructuredContentProvider {
        private final List<String[]> fVariables = new ArrayList<String[]>();

        public AttributesContentProvider(String[][] variables) {
            String[][] stringArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                String[] v = stringArray[n2];
                String[] variable = new String[]{v[0], v[1]};
                this.fVariables.add(variable);
                ++n2;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        public String[][] getElements() {
            return (String[][])this.fVariables.toArray((T[])new String[this.fVariables.size()][]);
        }

        public void add(String[] newAttribute) {
            this.fVariables.add(newAttribute);
        }

        public void remove(List<String[]> list) {
            this.fVariables.removeAll(list);
        }

        public void up(List<String[]> list) {
            for (String[] variable : list) {
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index - 1, variable);
            }
        }

        public void down(List<String[]> list) {
            for (String[] variable : list) {
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index + 1, variable);
            }
        }
    }

    public static class AttributesLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((String[])element)[0];
        }
    }
}

