/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd.internal.ui;

import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.core.SvdDescriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SvdViewerFilterByExistence
extends ViewerFilter {
    private final Collection<String> supportedFamilies = new ArrayList<String>();
    private final Collection<String> supportedDevices = new ArrayList<String>();

    public SvdViewerFilterByExistence(String launchId) {
        List<SvdDescriptor> svdDescriptors = SvdViewerFilterByExistence.getSvdDescriptors(launchId);
        svdDescriptors.forEach(descriptor -> {
            String deviceId = descriptor.getDeviceId();
            List families = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
            if (!families.isEmpty()) {
                String familyId = ((FamilyDescriptor)families.get(0)).getId();
                if (!this.supportedDevices.contains(deviceId)) {
                    this.supportedDevices.add(deviceId);
                }
                if (!this.supportedFamilies.contains(familyId)) {
                    this.supportedFamilies.add(familyId);
                }
            }
        });
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        ArrayList<Object> listResult = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof FamilyDescriptor && this.supportedFamilies.contains(((FamilyDescriptor)element).getId())) {
                listResult.add(element);
            }
            if (element instanceof DeviceDescriptor && this.supportedDevices.contains(((DeviceDescriptor)element).getId())) {
                listResult.add(element);
            }
            if (element instanceof CoreDescriptor) {
                listResult.add(element);
            }
            ++n2;
        }
        return listResult.toArray(new Object[listResult.size()]);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }

    private static List<SvdDescriptor> getSvdDescriptors(String launchId) {
        Set<String> debuggersIds = SvdViewerFilterByExistence.getDebuggersIds(launchId);
        if (debuggersIds.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet deviceIds = new HashSet();
        debuggersIds.forEach(debuggerId -> DeviceDescriptors.getDeviceDescriptors().forEach(devDesc -> {
            String deviceId = devDesc.getId();
            if (DeviceCoreDebuggerDescriptors.getDebuggerByDeviceConditions((String)deviceId).contains(debuggerId) && !deviceIds.contains(deviceId)) {
                deviceIds.add(deviceId);
            }
        }));
        return SvdDescriptors.getSvdDescriptors().stream().filter(svdDescriptor -> deviceIds.contains(svdDescriptor.getDeviceId())).filter(svdDescriptor -> svdDescriptor.getHasPeripheralRegistersSvdSupport().isBlank()).collect(Collectors.toList());
    }

    private static Set<String> getDebuggersIds(String launchId) {
        return DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByLaunchId(launchId).stream().map(d -> d.getDebuggerId()).collect(Collectors.toSet());
    }
}

