/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.internal;

import com.nxp.swtools.common.ui.utils.command.CommandUtils;
import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.ui.utils.swt.widgets.ExpandableSection;
import com.nxp.swtools.common.ui.utils.swt.widgets.ToggleButton;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.logging.PerformanceLogger;
import com.nxp.swtools.dashboard.Messages;
import com.nxp.swtools.dashboard.internal.DashboardUiUtils;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import com.nxp.swtools.utils.command.handlers.KitBoardInformationHandler;
import com.nxp.swtools.utils.command.handlers.ProcessorInformationHandler;
import com.nxp.swtools.utils.command.handlers.UpdateCodeBlocker;
import com.nxp.swtools.utils.controller.shared.SharedController;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.sources.SourcesView;
import com.nxp.swtools.utils.toolbar.FunctionsToolBarManager;
import com.nxp.swtools.utils.toolbar.IFunctionManager;
import com.nxp.swtools.utils.toolbar.IToolbarContentProvider;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.IToolFunction;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.importWizard.ImportConfigurationWizard;
import com.nxp.swtools.validation.engine.FilteredProblems;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemListenerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class DashboardControlsProvider {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(DashboardControlsProvider.class);
    @NonNull
    static final Logger PERFORMANCE_LOGGER = PerformanceLogger.getSharedPerformanceLogger();
    private static final int DASHBOARD_TOOL_CONTENT_MIN_WIDTH = 426;
    private static final int DASHBOARD_FULL_CONTENT_MIN_WIDTH = 1278;
    private static final int DASHBOARD_FULL_CONTENT_DEFAULT_HEIGHT = 600;
    private static final int SPACING_5_PIXELS = 5;
    private static final int WIDTH_TWO_THIRDS_MULTIPLIER = 2;
    private static final int WIDTH_TWO_THIRDS_DIVIDER = 3;
    private static final int TWO_COLUMNS_GRID = 2;
    private static final int THREE_COLUMNS_GRID = 3;
    @NonNull
    private static final String UI_REFRESH_JOB_NAME = "Dashboard UI refresh";
    @NonNull
    private static final URL IMPORT_IMG_URL;
    @Nullable
    final Runnable endModalAction;
    final boolean isToolView;
    @Nullable
    ScrolledComposite dashboardScrollable;
    @Nullable
    Composite dashboardContent = null;
    @NonNull
    @NonNull Map<@NonNull String, @NonNull Boolean> expndbleSectionsExpanded = new HashMap<String, Boolean>();
    @Nullable
    final String headerMessage;
    final boolean shouldSelectPerspective;
    @NonNull
    final ISharedConfiguration sharedConfig;
    @NonNull
    final DelayedExecution delayedDashboardUiRefresh = new DelayedExecution("Dashboard UI refresh", 50, (IDelayedActionExecutor)new DelayedActionExecutorAdapter(){

        public void runAction() {
            Tools.getTools().forEach(t -> {
                if (!t.isUpdated(DashboardControlsProvider.this.sharedConfig) && DashboardControlsProvider.this.sharedConfig.getPreferences().isCodePreviewEnabled()) {
                    DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("cancel dashboard update, because tool not updated: " + t.getToolId());
                }
            });
            if (DashboardControlsProvider.this.delayedDashboardUiRefresh.isCanceled()) {
                DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("additional delay after cancelation");
                return;
            }
            UIJobHelper.runNowOrInJob(() -> DashboardControlsProvider.this.updateDashboardControls(DashboardControlsProvider.this.dashboardContent), (String)DashboardControlsProvider.UI_REFRESH_JOB_NAME, null);
        }
    }, 500);
    @Nullable
    public Color backgroundColor;

    static {
        URL url = null;
        try {
            url = new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/import_wiz.png");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Failed to load import image", e);
        }
        assert (url != null);
        IMPORT_IMG_URL = url;
    }

    public DashboardControlsProvider(@Nullable Runnable endModalAction, @Nullable String header, boolean shouldSelectPerspective) {
        assert (!shouldSelectPerspective || endModalAction != null) : "endModalAction must be assigned if shouldSelectPerspective is selected";
        this.isToolView = endModalAction == null;
        this.endModalAction = endModalAction;
        this.shouldSelectPerspective = shouldSelectPerspective;
        this.headerMessage = header;
        this.sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
    }

    boolean isModal() {
        return this.endModalAction != null;
    }

    public @NonNull DelayedExecution getDelayedUiRefresher() {
        return this.delayedDashboardUiRefresh;
    }

    private @NonNull Composite createCollapsibleGroup(@NonNull Composite parent, @Nullable String title, @Nullable Boolean defaultExpanded, boolean row) {
        ExpandableSection expSect = new ExpandableSection(parent, UtilsText.safeString((String)title), defaultExpanded == null ? ExpandableSection.Status.ALWAYS_EXPANDED : ExpandableSection.Status.EXPANDED);
        expSect.setLayoutData((Object)new GridData(4, row ? 4 : 128, true, row, 1, 1));
        if (defaultExpanded != null) {
            String key = DashboardUiUtils.getExpandItemId(expSect);
            @Nullable Boolean val = this.expndbleSectionsExpanded.get(key);
            if (Objects.isNull(val)) {
                val = defaultExpanded;
                this.expndbleSectionsExpanded.put(key, val);
            }
            assert (val != null);
            expSect.setExpanded(val.booleanValue());
        }
        expSect.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                ExpandableSection item = (ExpandableSection)e.widget;
                if (!$assertionsDisabled && item == null) {
                    throw new AssertionError();
                }
                DashboardControlsProvider.this.expndbleSectionsExpanded.put(DashboardUiUtils.getExpandItemId(item), Boolean.TRUE);
                DashboardControlsProvider.this.calculateScrollableContentMinHeight(DashboardControlsProvider.this.dashboardContent);
            }

            public void itemCollapsed(ExpandEvent e) {
                ExpandableSection item = (ExpandableSection)e.widget;
                if (!$assertionsDisabled && item == null) {
                    throw new AssertionError();
                }
                DashboardControlsProvider.this.expndbleSectionsExpanded.put(DashboardUiUtils.getExpandItemId(item), Boolean.FALSE);
                DashboardControlsProvider.this.calculateScrollableContentMinHeight(DashboardControlsProvider.this.dashboardContent);
            }
        });
        Composite composite = expSect.getContent();
        composite.setLayout((Layout)DashboardUiUtils.twoColumnGridLayout());
        return composite;
    }

    private void createGeneralInfoConfiguration(@NonNull Composite parent) {
        ICommonConfig commonConfig = this.sharedConfig.getCommonConfig();
        Composite collapsibleGrp = this.createCollapsibleGroup(parent, Messages.get().Dashboard_GroupConfigGeneralInfo, !this.isToolView, !this.isToolView);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)collapsibleGrp, "com.nxp.swtools.dashboard.GeneralInfo.Configuration");
        IPath path = this.sharedConfig.getLocationPath();
        if (path == null) {
            DashboardUiUtils.addSingleRowLabelToGrid(collapsibleGrp, Messages.get().Dashboard_StatusConfigNotSaved).setEnabled(false);
        } else {
            String osPath = path.toOSString();
            assert (osPath != null);
            Control ctrl = DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelName, UtilsFile.getFileNameWithExtension((String)osPath));
            FontFactory.changeStyle((Control)ctrl, (int)1);
            DashboardUiUtils.createNameLabel(collapsibleGrp, Messages.get().Dashboard_LabelPath);
            Control link = DashboardUiUtils.addLinkToCell(collapsibleGrp, UtilsFile.getFilePath((String)osPath), null);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(link, String.valueOf(Messages.get().Dashboard_LabelPath) + ": " + UtilsFile.getFilePath((String)osPath));
        }
        DashboardUiUtils.addNameValueToGridIfNonEmpty(collapsibleGrp, Messages.get().Dashboard_LabelDescription, commonConfig.getDescription());
        Composite buttonBar = new Composite(collapsibleGrp, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        buttonBar.setLayout((Layout)new RowLayout(256));
        FilteredProblems problems = FilteredProblems.countNumberOfProblemsForFunction((String)"McuConfiguration", (String)"");
        DashboardUiUtils.createProblemsButtonIfNeeded(problems, buttonBar, null, this.endModalAction, null);
        if (!this.shouldSelectPerspective) {
            ToolBar toolBar = new ToolBar(buttonBar, 0x800100);
            ToolItem item = new ToolItem(toolBar, 8);
            item.setImage(UtilsImage.getImage((URL)IMPORT_IMG_URL));
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toolBar, Messages.get().Dashboard_TooltipImport);
            DashboardUiUtils.assignActionToWidget((Widget)item, this.endModalAndRun(() -> ImportConfigurationWizard.launchImportConfigWizard((Shell)ShellProvider.getAnyShellParent(), null)));
        }
    }

    private void createGeneralInfoProcessor(@NonNull Composite parent) {
        String kitName;
        ICommonConfig commonConfig = this.sharedConfig.getCommonConfig();
        Composite collapsibleGrp = this.createCollapsibleGroup(parent, Messages.get().Dashboard_GroupConfigHwInfo, true, !this.isToolView);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)collapsibleGrp, "com.nxp.swtools.dashboard.GeneralInfo.HwInfo");
        IMcuIdentification mcuIdent = commonConfig.getMcuIdentification();
        DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelProcessor, mcuIdent.getMcu());
        String partNumber = mcuIdent.getPackage();
        if (SwToolsProduct.isUctProduct()) {
            DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelPartNumber, partNumber);
        } else {
            DashboardUiUtils.addNameUrlToGrid(collapsibleGrp, Messages.get().Dashboard_LabelPartNumber, partNumber, ProcessorInformationHandler.getLinkToProcessorInformation((String)partNumber));
        }
        ProcessorCore core = commonConfig.getSelectedCore();
        if (core != null) {
            DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelCore, core.getName());
        } else {
            DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelCore, Messages.get().Dashboard_LabelCoreNotSelected);
        }
        String boardName = mcuIdent.getBoard();
        if (boardName != null) {
            if (SwToolsProduct.isUctProduct()) {
                DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelBoard, boardName);
            } else {
                DashboardUiUtils.addNameUrlToGrid(collapsibleGrp, Messages.get().Dashboard_LabelBoard, boardName, KitBoardInformationHandler.getLinkToKitBoardInformation((String)boardName));
            }
        }
        if ((kitName = mcuIdent.getKit()) != null) {
            if (SwToolsProduct.isUctProduct()) {
                DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelKit, kitName);
            } else {
                DashboardUiUtils.addNameUrlToGrid(collapsibleGrp, Messages.get().Dashboard_LabelKit, kitName, KitBoardInformationHandler.getLinkToKitBoardInformation((String)kitName));
            }
        }
        DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelSdkVersion, commonConfig.getSdkVersion());
    }

    private void createGeneralInfoProject(@NonNull Composite parent) {
        ICommonConfig commonConfig = this.sharedConfig.getCommonConfig();
        ProcessorCore selCore = commonConfig.getSelectedCore();
        Composite collapsibleGrp = this.createCollapsibleGroup(parent, Messages.get().Dashboard_GroupProject, !this.isToolView, !this.isToolView);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)collapsibleGrp, "com.nxp.swtools.dashboard.GeneralInfo.Project");
        IToolchainProjectWithSdk prj = this.sharedConfig.getToolchainProject();
        if (prj != null && prj.wasProjectDetected()) {
            FilteredProblems problems;
            Control prblmCtrl;
            ProcessorCore toolCore;
            FontFactory.changeStyle((Control)DashboardUiUtils.addNameValueToGrid(collapsibleGrp, Messages.get().Dashboard_LabelProjectName, prj.getProjectName()), (int)1);
            DashboardUiUtils.addNameValueToGridIfNonEmpty(collapsibleGrp, Messages.get().Dashboard_LabelToolchain, prj.getToolchain());
            DashboardUiUtils.addNameValueToGridIfNonEmpty(collapsibleGrp, Messages.get().Dashboard_LabelProcessor, prj.getProcessor());
            DashboardUiUtils.addNameValueToGridIfNonEmpty(collapsibleGrp, Messages.get().Dashboard_LabelPartNumber, prj.getPartNumber());
            String toolCoreId = prj.getCoreId();
            if (toolCoreId != null && (toolCore = commonConfig.findCore(toolCoreId)) != null) {
                DashboardUiUtils.addNameValueToGridIfNonEmpty(collapsibleGrp, Messages.get().Dashboard_LabelCore, toolCore.getName());
            }
            if (selCore != null && (prblmCtrl = DashboardUiUtils.createProblemsButtonIfNeeded(problems = FilteredProblems.countNumberOfProblemsForFunction((String)"Toolchain/IDE project", (String)selCore.getID()), collapsibleGrp, null, this.endModalAction, null)) != null) {
                prblmCtrl.setLayoutData((Object)new GridData(131072, 128, false, false, 2, 1));
            }
            if (SWToolsPlatform.isRunningAsRcp()) {
                String pathStr = prj.getProjectRoot().toString();
                DashboardUiUtils.createNameLabel(collapsibleGrp, Messages.get().Dashboard_LabelPath);
                Control link = DashboardUiUtils.addLinkToCell(collapsibleGrp, pathStr, null);
                SWTFactoryProxy.INSTANCE.setHtmlTooltip(link, String.valueOf(Messages.get().Dashboard_LabelPath) + ": " + pathStr);
            }
        } else {
            String msg = com.nxp.swtools.sdkproject.Messages.get().SdkProject_ErrNoToolchainProject;
            DashboardUiUtils.addSingleRowLabelToGrid(collapsibleGrp, msg).setEnabled(false);
        }
    }

    private void createGeneralInfo(@NonNull Composite parent) {
        if (this.isToolView) {
            parent = DashboardUiUtils.createGroupOfExpandableSections(parent, false);
        }
        this.createGeneralInfoConfiguration(parent);
        this.createGeneralInfoProcessor(parent);
        this.createGeneralInfoProject(parent);
    }

    public @NonNull Runnable endModalAndRun(@NonNull Runnable run) {
        return DashboardUiUtils.endModalAndRun(this.endModalAction, run);
    }

    private void addToolBigButton(@NonNull ITool tool, @NonNull Composite parent) {
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        assert (storageTool != null);
        Button bigToolBtn = DashboardUiUtils.addButtonToCell(parent, tool.getIconName(80), "", this.endModalAndRun(() -> DashboardUiUtils.switchPerspective(tool)));
        bigToolBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)bigToolBtn, "com.nxp.swtools.dashboard.SelectToolBtn_" + tool.getToolId());
        String disabledReason = null;
        if (!tool.isProcessorSupported(this.sharedConfig)) {
            disabledReason = String.format(Messages.get().Dashboard_TooltipProcessorNotSupported, product.getProductName());
        } else if (!storageTool.isEnabled()) {
            disabledReason = String.format(Messages.get().Dashboard_TooltipToolDisabled, product.getProductName());
        }
        if (disabledReason != null) {
            bigToolBtn.setEnabled(false);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)parent, disabledReason);
        } else {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)bigToolBtn, String.format(Messages.get().Dashboard_TooltipOpenTool, product.getProductName()));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean addToolButtonsBar(@NonNull ITool tool, @NonNull Composite parent, boolean showAllProblems) {
        final StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        assert (storageTool != null);
        Composite buttonsGrp = new Composite(parent, 0);
        buttonsGrp.setLayoutData((Object)new GridData(4, 1024, true, false));
        buttonsGrp.setLayout((Layout)RowLayoutFactory.swtDefaults().extendedMargins(0, 0, 0, 0).create());
        ToggleButton toolbar = new ToggleButton(buttonsGrp, storageTool.isEnabled(), "com.nxp.swtools.dashboard.EnableDisableToolBtn_" + tool.getToolId(), () -> ProgressUtils.run((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                StorageTool.setToolEnabled((StorageTool)storageTool, (!storageTool.isEnabled() ? 1 : 0) != 0);
            }
        }));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toolbar, Messages.get().Dashboard_TooltipEnableDisableTool);
        if (!tool.isProcessorSupported(this.sharedConfig) && !storageTool.isEnabled()) {
            toolbar.setEnabled(false);
            SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
            assert (product != null);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)buttonsGrp, String.format(Messages.get().Dashboard_TooltipProcessorNotSupported, product.getProductName()));
            return false;
        }
        if (!storageTool.isEnabled() || !tool.isProcessorSupported(this.sharedConfig)) {
            return false;
        }
        FilteredProblems filteredPrblms = FilteredProblems.countNumberOfProblemsForTool((ITool)tool);
        if (showAllProblems) {
            SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
            assert (product != null);
            IToolbarContentProvider contentProvider = FunctionsToolBarManager.getInstance().getContentProvider(product.getPerspectiveID());
            assert (contentProvider != null);
            @NonNull List strgFunctions = storageTool.getFunctionalGroups();
            if (strgFunctions != null) {
                for (StorageToolBaseConfiguration func : strgFunctions) {
                    FilteredProblems funcProblems = FilteredProblems.countNumberOfProblemsForFunction((String)tool.getToolId(), (String)func.getConfigurationName());
                    filteredPrblms.mergeWith(funcProblems);
                }
            }
        }
        DashboardUiUtils.createProblemsButtonIfNeeded(filteredPrblms, buttonsGrp, null, this.endModalAction, tool);
        return true;
    }

    private boolean addToolRefToOtherTools(@NonNull ITool tool, @NonNull Composite parent) {
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        if (storageTool == null) {
            return false;
        }
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        Composite parentToolGrp = new Composite(parent, 0);
        parentToolGrp.setLayoutData((Object)new RowData());
        GridLayout gridLayoput = new GridLayout(1, false);
        gridLayoput.marginHeight = 1;
        gridLayoput.verticalSpacing = 2;
        parentToolGrp.setLayout((Layout)gridLayoput);
        this.addToolBigButton(tool, parentToolGrp);
        this.addToolButtonsBar(tool, parentToolGrp, true);
        return true;
    }

    private boolean createToolMainSection(@NonNull ITool tool, @NonNull Composite parent) {
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        Composite toolGroup = this.createCollapsibleGroup(parent, product.getProductName(), Boolean.TRUE, false);
        boolean processorSupported = tool.isProcessorSupported(this.sharedConfig);
        if (!(processorSupported || storageTool != null && storageTool.isEnabled())) {
            DashboardUiUtils.addWrappedLabelToGrid(toolGroup, Messages.get().Dashboard_ErrorToolNotSupportProcessor).setEnabled(false);
            return false;
        }
        if (storageTool == null) {
            DashboardUiUtils.addWrappedLabelToGrid(toolGroup, Messages.get().Dashboard_ErrorToolNotInitialized).setEnabled(false);
            return false;
        }
        this.addToolBigButton(tool, toolGroup);
        Composite toolStsGrp = new Composite(toolGroup, 0);
        toolStsGrp.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        GridLayout gridLayoutNoMargin = new GridLayout(1, false);
        gridLayoutNoMargin.verticalSpacing = 0;
        gridLayoutNoMargin.marginHeight = 0;
        gridLayoutNoMargin.marginWidth = 0;
        toolStsGrp.setLayout((Layout)gridLayoutNoMargin);
        Label descrLbl = DashboardUiUtils.addLabel(toolStsGrp);
        if (processorSupported) {
            descrLbl.setText(UtilsText.safeString((String)product.getProductDescription()));
            FontFactory.changeFontSize((Control)descrLbl, (int)(descrLbl.getFont().getFontData()[0].getHeight() - 1));
        } else {
            descrLbl.setText(Messages.get().Dashboard_ErrorToolNotSupportProcessor);
        }
        descrLbl.setLayoutData((Object)new GridData(16384, 128, true, true));
        return this.addToolButtonsBar(tool, toolStsGrp, false);
    }

    private void addGeneratedFileRow(@NonNull Path relFilePath, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IGeneratedFilesStatusProvider.GeneratedFileStatus fileStatus, @NonNull Composite parent, @NonNull ITool tool, @NonNull ProcessorCore selCore) {
        Path filePth;
        ToolItem fileStsBtn;
        String whyDisabled;
        assert (parent.getLayout() instanceof GridLayout);
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        assert (storageTool != null);
        IToolchainProjectProvider toolchainProvider = this.sharedConfig.getToolchainProjectProvider();
        if (toolchainProvider == null) {
            return;
        }
        IToolchainProjectWithSdk project = toolchainProvider.getToolchainProject();
        Composite fileNameGrp = DashboardUiUtils.addGroupAsRowToGrid(parent, 3);
        UpdateCodeBlocker blocker = UpdateCodeBlocker.getReasonBlockingUpdateProjectCode((ISharedConfiguration)this.sharedConfig);
        String string = whyDisabled = blocker != null ? blocker.getDescription() : null;
        if (whyDisabled == null && (whyDisabled = Tools.whyToolNotRunning((ISharedConfiguration)this.sharedConfig, (String)tool.getToolId())) == null && !storageTool.getUpdateCode()) {
            whyDisabled = Messages.get().Dashboard_TooltipUpdPrjCode_Disabled;
        }
        if ((fileStsBtn = DashboardUiUtils.createFileStatusButton(fileNameGrp, fileStatus, whyDisabled)).getEnabled()) {
            DashboardUiUtils.assignActionToWidget((Widget)fileStsBtn, this.endModalAndRun(() -> {
                DashboardUiUtils.switchPerspective(tool);
                CommandUtils.executeCommand((String)"com.nxp.swtools.framework.openProjectUpdateDialogCmd");
            }));
        }
        if (project != null && (filePth = project.findSourceFileRelPath(relFilePath)) != null) {
            relFilePath = filePth;
        }
        String fileName = UtilsFile.getFileNameWithExtension((Path)relFilePath);
        Control link = DashboardUiUtils.addLinkToCell(fileNameGrp, relFilePath.toString(), this.endModalAndRun(() -> {
            SourcesView sourcesView;
            DashboardUiUtils.switchPerspective(tool);
            PerspectivesHelper.showView((String)"com.nxp.swtools.framework.SourcesView");
            IViewReference sourcesRef = PerspectivesHelper.findActiveView((String)"com.nxp.swtools.framework.SourcesView");
            if (sourcesRef != null && (sourcesView = (SourcesView)sourcesRef.getView(true)) != null) {
                sourcesView.showFile(fileName, selCore);
            }
        }));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)link, "com.nxp.swtools.dashboard.GeneratedFileLink_" + tool.getToolId() + '_' + relFilePath);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createToolGeneratedFilesSection(@NonNull ITool tool, @NonNull Composite parent) {
        IGeneratedFilesStatusProvider genFilesProvider;
        boolean projectDetected;
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        assert (storageTool != null);
        IToolchainProjectProvider toolchainProvider = this.sharedConfig.getToolchainProjectProvider();
        if (toolchainProvider == null) {
            return;
        }
        Composite genCodeGroup = this.createCollapsibleGroup(parent, Messages.get().Dashboard_GroupGeneratedCode, Boolean.TRUE, false);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)genCodeGroup, "com.nxp.swtools.dashboard.GeneratedCodeSection_" + tool.getToolId());
        ISourceFileProvider srcProvider = (ISourceFileProvider)CollectionsUtils.first((Collection)SourceFileProviderFactory.getSourceFileProviders((String)tool.getToolId()));
        assert (srcProvider != null);
        ProcessorCore selCore = this.sharedConfig.getCommonConfig().getSelectedCore();
        if (selCore == null) {
            DashboardUiUtils.addWrappedLabelToGrid(genCodeGroup, Messages.get().Dashboard_ErrorCoreNotSelected).setEnabled(false);
            return;
        }
        ArrayList<@NonNull E> generatedFiles = new ArrayList();
        ISourceFileGenerationStatus genFailure = srcProvider.getGeneratedFiles(selCore.getID(), generatedFiles);
        if (genFailure.getStatus() == ISourceFileGenerationStatus.GenerationStatus.FATAL) {
            String msg = String.valueOf(Messages.get().Dashboard_LabelError) + ": " + genFailure.getMessage();
            DashboardUiUtils.addWrappedLabelToGrid(genCodeGroup, msg).setEnabled(false);
            return;
        }
        IToolchainProjectWithSdk project = toolchainProvider.getToolchainProject();
        boolean bl = projectDetected = project != null && project.wasProjectDetected();
        if (projectDetected) {
            String tooltip;
            String label;
            Composite updPrjCodeGrp = DashboardUiUtils.addGroupAsRowToGrid(genCodeGroup, 1);
            Button updPrjCodeBtn = new Button(updPrjCodeGrp, 32);
            updPrjCodeBtn.setSelection(storageTool.getUpdateCode());
            if (storageTool.getUpdateCode()) {
                label = Messages.get().Dashboard_LabelUpdatePrjCodeEnabled;
                tooltip = Messages.get().Dashboard_TooltipUpdPrjCode_Enabled;
            } else {
                label = Messages.get().Dashboard_LabelUpdatePrjCodeDisabled;
                tooltip = Messages.get().Dashboard_TooltipUpdPrjCode_Disabled;
            }
            updPrjCodeBtn.setText(label);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)updPrjCodeBtn, tooltip);
            DashboardUiUtils.assignActionToWidget((Widget)updPrjCodeBtn, () -> {
                StorageTool.setToolUpdateCode((StorageTool)storageTool, (!storageTool.getUpdateCode() ? 1 : 0) != 0);
                this.updateDashboardControls(this.dashboardContent);
            });
        }
        @NonNull Stream getFileNames = (genFilesProvider = toolchainProvider.getGeneratedFilesStatusProvider()) != null ? genFilesProvider.getGeneratedRelPaths(false, tool.getToolId()) : SourceFileProviderFactory.getGeneratedRelFilePaths(generatedFiles);
        getFileNames.sorted().forEach(filePath -> {
            IGeneratedFilesStatusProvider.GeneratedFileStatus fileStatus = genFilesProvider != null ? genFilesProvider.getGeneratedFileProjectStatus(UtilsFile.getFileNameWithExtension((Path)filePath), false) : null;
            this.addGeneratedFileRow((Path)filePath, fileStatus, genCodeGroup, tool, selCore);
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createToolFunctionalGroupsSection(@NonNull ITool tool, @NonNull Composite parent) {
        List strgFunctions;
        if (!tool.isProcessorSupported(this.sharedConfig) || !tool.isFunctionalGroupSupported()) {
            return;
        }
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        IToolbarContentProvider contentProvider = FunctionsToolBarManager.getInstance().getContentProvider(product.getPerspectiveID());
        assert (contentProvider != null);
        Composite funcGroup = this.createCollapsibleGroup(parent, Messages.get().Dashboard_GroupFunctionalGroups, Boolean.TRUE, false);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)funcGroup, "com.nxp.swtools.dashboard.FunctionalGroupsSection_" + tool.getToolId());
        List list = strgFunctions = storageTool != null ? storageTool.getFunctionalGroups() : null;
        if (storageTool == null || strgFunctions == null || strgFunctions.isEmpty()) {
            DashboardUiUtils.addSingleRowLabelToGrid(funcGroup, Messages.get().Dashboard_StatusNoFuncGroups).setEnabled(false);
            return;
        }
        if (!storageTool.isEnabled()) {
            for (StorageToolBaseConfiguration function : strgFunctions) {
                Control lbl = DashboardUiUtils.addSingleRowLabelToGrid(funcGroup, function.getName());
                lbl.setEnabled(false);
                SWTFactoryProxy.INSTANCE.setTestId((Widget)lbl, "com.nxp.swtools.dashboard.FunctionalGroupLink_" + tool.getToolId() + '_' + function.getName());
            }
            return;
        }
        IFunctionManager functionsManager = contentProvider.getFunctionManager();
        @NonNull List functions = functionsManager.getFunctions();
        for (IToolFunction function : functions) {
            Composite funcGrp = DashboardUiUtils.addGroupAsRowToGrid(funcGroup, 3);
            assert (strgFunctions != null);
            StorageToolBaseConfiguration storageFunction = (StorageToolBaseConfiguration)CollectionsUtils.findAny((Collection)strgFunctions, f -> f.getConfigurationName().equals(function.getName()));
            if (storageFunction == null) continue;
            ToolBar stsToolbar = new ToolBar(funcGrp, 0x800100);
            ToolItem initBtn = new ToolItem(stsToolbar, 32);
            Image initImg = ToolsImages.getImage((String)"icons/init_filled.png");
            if (!function.isCalledFromDefaultInit()) {
                initImg = ToolsImages.getImage((String)"icons/init_unfilled.png");
            }
            initBtn.setImage(initImg);
            String stsTooltip = function.isCalledFromDefaultInit() ? Messages.get().Dashboard_TooltipCalledFromInit : Messages.get().Dashboard_TooltipNotCalledFromInit;
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)stsToolbar, stsTooltip);
            DashboardUiUtils.assignActionToWidget((Widget)initBtn, () -> {
                functionsManager.setCalledFromDefaultInit(function, !function.isCalledFromDefaultInit());
                this.delayedDashboardUiRefresh.waitUntilExecuted(0);
            });
            Control link = DashboardUiUtils.addLinkToCell(funcGrp, function.getName(), this.endModalAndRun(() -> {
                DashboardUiUtils.switchPerspective(tool);
                functionsManager.setWorkingFunction(function);
                ToolEvent event = new ToolEvent.Builder(1).setOriginator((Object)"com.nxp.swtools.dashboard.DashboardView").build();
                SharedController.getInstance().fireListeners(event);
            }));
            SWTFactoryProxy.INSTANCE.createHtmlTooltip(link, (Object)DashboardUiUtils.getHtmlTooltipableForFunction(function));
            SWTFactoryProxy.INSTANCE.setTestId((Widget)link, "com.nxp.swtools.dashboard.FunctionalGroupLink_" + tool.getToolId() + '_' + function.getName());
            FilteredProblems prblms = FilteredProblems.countNumberOfProblemsForFunction((String)tool.getToolId(), (String)storageFunction.getName());
            DashboardUiUtils.createProblemsButtonIfNeeded(prblms, funcGrp, () -> functionsManager.setWorkingFunction(function), this.endModalAction, tool);
        }
    }

    private void createToolGrpControls(@NonNull ITool tool, @NonNull Composite parent, boolean mainSectionOnly) {
        PERFORMANCE_LOGGER.entering(DashboardControlsProvider.class.getName(), "createToolGrpControls:" + tool.getToolId());
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        Composite toolGroup = DashboardUiUtils.createGroupOfExpandableSections(parent, false);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)toolGroup, "com.nxp.swtools.dashboard.ToolGroup");
        toolGroup.setData((Object)tool);
        boolean toolMainSectionCreated = this.createToolMainSection(tool, toolGroup);
        if (!(tool.getToolId().equals("DCD") || tool.getToolId().equals("IVT") || tool.getToolId().equals("DDR") || tool.getToolId().equals("QuadSPI") || tool.getToolId().equals("eFUSE") || tool.getToolId().equals("GTM") || tool.getToolId().equals("PBL") || tool.getToolId().equals("SERDES"))) {
            if (toolMainSectionCreated && !mainSectionOnly) {
                this.createToolGeneratedFilesSection(tool, toolGroup);
            }
            if (!mainSectionOnly) {
                this.createToolFunctionalGroupsSection(tool, toolGroup);
            }
        }
        Point size = parent.computeSize(-1, -1);
        GridData data = new GridData(4, 128, true, false, 1, 1);
        data.minimumHeight = size.y;
        parent.setLayoutData((Object)data);
        PERFORMANCE_LOGGER.exiting(DashboardControlsProvider.class.getName(), "createToolGrpControls");
    }

    public boolean isToolDisplayed(ITool tool, @Nullable String toolId4perspective) {
        if (this.sharedConfig.isEmpty()) {
            return true;
        }
        StorageTool storageTool = this.sharedConfig.getTools().getTool(tool.getToolId());
        if (storageTool == null) {
            return false;
        }
        if (tool.getToolId().equals(toolId4perspective)) {
            return true;
        }
        return tool.isProcessorSupported(this.sharedConfig) || storageTool.isEnabled();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void updateDashboardControls(@Nullable Composite parent) {
        Control[] prevChildren;
        if (parent == null || parent.isDisposed()) {
            return;
        }
        assert (this.dashboardContent == null || this.dashboardContent == parent);
        PERFORMANCE_LOGGER.entering(DashboardControlsProvider.class.getName(), "updateDashboardControls");
        parent.setRedraw(false);
        Control[] controlArray = prevChildren = parent.getChildren();
        int n = prevChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        String frstPerspId = PerspectivesHelper.getActivePerspectiveId();
        SwToolsProduct firstProduct = frstPerspId != null ? SwToolsProductConfiguration.getRegisteredProductForPerspective((String)frstPerspId) : null;
        String toolId4perspective = firstProduct != null ? firstProduct.getProductId() : null;
        @NonNull List tools = Tools.getToolsSorted();
        tools.removeIf(t -> !this.isToolDisplayed((ITool)t, toolId4perspective));
        int colForTools = this.isToolView ? 1 : tools.size();
        GridLayout gridLayout = DashboardUiUtils.createTopLevelGridLayout(colForTools);
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        parent.setLayout((Layout)gridLayout);
        if (this.sharedConfig.isEmpty()) {
            Control label = DashboardUiUtils.addSingleRowLabelToGrid(parent, Messages.get().Dashboard_StatusEmptyConfiguration);
            label.setBackground(this.backgroundColor);
            label.setEnabled(false);
        } else {
            this.updateDashboardGeneralInfo(parent);
            this.updateDashboardTools(parent, tools, toolId4perspective);
        }
        this.calculateScrollableContentMinHeight(parent);
        parent.setRedraw(true);
        PERFORMANCE_LOGGER.exiting(DashboardControlsProvider.class.getName(), "updateDashboardControls");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void updateDashboardGeneralInfo(@NonNull Composite parent) {
        Composite commonSettingsGrp;
        @NonNull List tools = Tools.getToolsSorted();
        int colForTools = this.isToolView ? 1 : tools.size();
        PERFORMANCE_LOGGER.entering(DashboardControlsProvider.class.getName(), "updateDashboardControls - general info");
        if (!this.isToolView) {
            String disabledToolError = DashboardUiUtils.getDisabledProductErrorMessage();
            String headerMessageLoc = this.headerMessage;
            if (headerMessageLoc != null || disabledToolError != null) {
                Label labelText;
                Image image;
                Label labelImg;
                Group grp = new Group(parent, 4);
                grp.setLayoutData((Object)new GridData(4, 128, true, false, colForTools, 1));
                grp.setLayout((Layout)new GridLayout(2, false));
                grp.setBackground(this.backgroundColor);
                if (headerMessageLoc != null) {
                    labelImg = new Label((Composite)grp, 16672);
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                    labelImg.setImage(image);
                    labelImg.setBackground(this.backgroundColor);
                    labelText = new Label((Composite)grp, 16672);
                    labelText.setText(headerMessageLoc);
                    labelText.setBackground(this.backgroundColor);
                }
                if (disabledToolError != null) {
                    labelImg = new Label((Composite)grp, 16672);
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    labelImg.setImage(image);
                    labelImg.setBackground(this.backgroundColor);
                    labelText = new Label((Composite)grp, 16672);
                    labelText.setText(disabledToolError);
                    labelText.setBackground(this.backgroundColor);
                }
            }
            commonSettingsGrp = DashboardUiUtils.createTopLevelGroup(parent);
            commonSettingsGrp.setLayoutData((Object)new GridData(4, 128, true, false, colForTools, 1));
            commonSettingsGrp.setBackground(this.backgroundColor);
            GridLayout gl = DashboardUiUtils.createTopLevelGridLayout(3);
            gl.marginLeft = 0;
            gl.marginRight = 0;
            gl.marginWidth = 0;
            commonSettingsGrp.setLayout((Layout)gl);
        } else {
            commonSettingsGrp = parent;
        }
        this.createGeneralInfo(commonSettingsGrp);
        PERFORMANCE_LOGGER.exiting(DashboardControlsProvider.class.getName(), "updateDashboardControls - general info");
    }

    private void updateDashboardTools(@NonNull Composite parent, Collection<@NonNull ITool> tools, @Nullable String toolId4perspective) {
        PERFORMANCE_LOGGER.entering(DashboardControlsProvider.class.getName(), "updateDashboardControls - tools");
        if (this.isToolView) {
            if (toolId4perspective != null) {
                ITool firstTool = Tools.getTool((String)toolId4perspective);
                assert (firstTool != null);
                this.createToolGrpControls(firstTool, parent, false);
            }
            Composite otherToolsParent = null;
            boolean anyToolAdded = false;
            for (ITool tool : tools) {
                if (tool.getToolId().equals(toolId4perspective)) continue;
                if (otherToolsParent == null) {
                    String title = toolId4perspective != null ? Messages.get().Dashboard_SectionTitle_OtherTools : Messages.get().Dashboard_SectionTitle_SelectTool;
                    otherToolsParent = this.createCollapsibleGroup(parent, UtilsText.safeString((String)title), Boolean.TRUE, false);
                    SWTFactoryProxy.INSTANCE.setTestId((Widget)otherToolsParent, "com.nxp.swtools.dashboard.OtherToolsPart");
                    otherToolsParent.setLayout((Layout)new RowLayout());
                }
                SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
                assert (product != null);
                if (!this.addToolRefToOtherTools(tool, otherToolsParent)) continue;
                anyToolAdded = true;
            }
            if (otherToolsParent != null && !anyToolAdded) {
                otherToolsParent.setLayout((Layout)new GridLayout(1, false));
                DashboardUiUtils.addSingleRowLabelToGrid(otherToolsParent, Messages.get().Dashboard_LabelNoEnabledTool);
            }
        } else {
            for (ITool tool : tools) {
                SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
                assert (product != null);
                this.createToolGrpControls(tool, parent, false);
            }
        }
        PERFORMANCE_LOGGER.exiting(DashboardControlsProvider.class.getName(), "updateDashboardControls - tools");
    }

    void calculateScrollableContentMinHeight(@Nullable Composite curDashboardContent) {
        if (curDashboardContent == null || curDashboardContent.isDisposed()) {
            return;
        }
        curDashboardContent.layout(true, true);
        int dashboardContentWidth = curDashboardContent.getSize().x;
        if (dashboardContentWidth <= 0) {
            dashboardContentWidth = -1;
        }
        Point size = curDashboardContent.computeSize(dashboardContentWidth, -1);
        if (curDashboardContent.getSize().x == 0) {
            int width = Integer.max(this.isToolView ? 426 : 1278, size.x);
            curDashboardContent.setSize(width, 600);
            this.calculateScrollableContentMinHeight(curDashboardContent);
            return;
        }
        if (this.dashboardScrollable != null) {
            this.dashboardScrollable.setMinHeight(size.y);
        }
    }

    public @NonNull Control createDashboardControls(@NonNull Composite parent) {
        ScrolledComposite newDashboardScrollable;
        assert (!Rap.isActive());
        assert (this.dashboardContent == null) : "createDashboardControls was already called";
        this.backgroundColor = parent.getDisplay().getSystemColor(25);
        parent.setBackground(this.backgroundColor);
        this.dashboardScrollable = newDashboardScrollable = new ScrolledComposite(parent, 768);
        newDashboardScrollable.setMinWidth(this.isToolView ? 426 : 1278);
        newDashboardScrollable.setAlwaysShowScrollBars(false);
        final Composite newDashboardContent = new Composite((Composite)newDashboardScrollable, 0x20000000);
        newDashboardScrollable.setContent((Control)newDashboardContent);
        newDashboardScrollable.setExpandHorizontal(true);
        newDashboardScrollable.setExpandVertical(true);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(4, 4, true, true);
            newDashboardScrollable.setLayoutData((Object)gd);
            Monitor monitor = newDashboardScrollable.getDisplay().getPrimaryMonitor();
            if (monitor != null) {
                gd.widthHint = monitor.getBounds().width * 2 / 3;
            }
        }
        Control[] children = newDashboardContent.getChildren();
        newDashboardContent.setBackground(parent.getBackground());
        assert (children == null || children.length == 0);
        this.updateDashboardControls(newDashboardContent);
        this.dashboardContent = newDashboardContent;
        newDashboardContent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!DashboardControlsProvider.this.delayedDashboardUiRefresh.isExecRequested()) {
                    newDashboardContent.layout(true, true);
                    DashboardControlsProvider.this.calculateScrollableContentMinHeight(newDashboardContent);
                }
            }
        });
        DashboardSharedConfigurationAdapter sharedCfgListener = new DashboardSharedConfigurationAdapter();
        this.sharedConfig.addListener((ISharedConfigurationListener)sharedCfgListener);
        if (Objects.isNull(ToolchainProjectUtils.class)) {
            LOGGER.severe("ToolchainProjectUtils.class is null");
        }
        IToolchainProjectProvider projectProvider = this.sharedConfig.getToolchainProjectProvider();
        IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener genFileStsListener = () -> {
            boolean bl = this.delayedDashboardUiRefresh.requestExecution("file status updated");
        };
        if (projectProvider != null) {
            projectProvider.addGeneratedFilesStatusListener(genFileStsListener);
        }
        ValidationProblemListenerAdapter problemsChangedListener = new ValidationProblemListenerAdapter(){

            public void validationProblemsChanged(@NonNull Collection<@NonNull IValidationProblem> problems) {
                DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("validation problems changed");
            }

            public void toolProblemsChanged(@NonNull Collection<@NonNull IBaseProblem> problems) {
                DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("tool problems changed");
            }
        };
        ValidationEngineFactory.addListener((IValidationProblemListener)problemsChangedListener);
        newDashboardScrollable.addDisposeListener(arg_0 -> this.lambda$13((ISharedConfigurationListener)sharedCfgListener, projectProvider, genFileStsListener, (IValidationProblemListener)problemsChangedListener, arg_0));
        return newDashboardContent;
    }

    public void resetExpndbleSections() {
        this.expndbleSectionsExpanded.clear();
    }

    private /* synthetic */ void lambda$13(ISharedConfigurationListener iSharedConfigurationListener, IToolchainProjectProvider iToolchainProjectProvider, IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener iGeneratedFilesStatusListener, IValidationProblemListener iValidationProblemListener, DisposeEvent e) {
        this.delayedDashboardUiRefresh.lock(0);
        this.sharedConfig.removeListener(iSharedConfigurationListener);
        if (iToolchainProjectProvider != null) {
            iToolchainProjectProvider.removeGeneratedFilesStatusListener(iGeneratedFilesStatusListener);
        }
        ValidationEngineFactory.removeListener((IValidationProblemListener)iValidationProblemListener);
    }

    private final class DashboardSharedConfigurationAdapter
    extends SharedConfigurationAdapter {
        public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
            DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("config reloaded");
        }

        public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
            DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("config changed");
        }

        public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConf) {
            DashboardControlsProvider.this.delayedDashboardUiRefresh.requestExecution("common config changed");
        }

        public int getListenerOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

