/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdModelBase;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cdt.svd.parser.SvdDeviceDescriptor;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SvdDeviceModel
extends SvdModelBase {
    private final Map<String, SvdPeripheralGroup> peripheralGroups = new HashMap<String, SvdPeripheralGroup>();
    private final SvdPeripheralGroup defaultGroup = new SvdPeripheralGroup((SvdModelBase)this, null);

    public SvdDeviceModel(SvdDeviceDescriptor deviceDescriptor, SvdSourceType type) {
        super(deviceDescriptor.getUID(), type);
    }

    @Override
    public void add(SvdChildElement child) {
        throw new UnsupportedOperationException("Use getOrCreate");
    }

    public SvdPeripheralGroup getOrCreate(String groupName) {
        return this.peripheralGroups.computeIfAbsent(groupName, k -> {
            SvdPeripheralGroup result = k == null ? this.defaultGroup : new SvdPeripheralGroup((SvdModelBase)this, groupName);
            super.add(result);
            return result;
        });
    }

    public void mergeWith(SvdModelBase additionalModel) {
        List<SvdPeripheral> additionalPeripherals = additionalModel.getPeripherals();
        for (SvdPeripheral newPeripheral : additionalPeripherals) {
            String newPeripheralName = newPeripheral.getName();
            boolean containsPeripheral = this.getPeripherals().stream().anyMatch(peripheral -> newPeripheralName.equals(peripheral.getName()));
            if (containsPeripheral) continue;
            SvdPeripheralGroup group = this.getOrCreate(newPeripheral.getParent().getName());
            SvdPeripheral peripheralToAdd = new SvdPeripheral(group, newPeripheral);
            peripheralToAdd.fillFrom(newPeripheral);
            group.add(peripheralToAdd);
        }
    }
}

