/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf;

import com.google.common.base.Function;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersCompositeCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersReadAlwaysCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersReadOnceCache;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextChangeListener;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import com.nxp.s32ds.cdt.svd.utils.SvdPostponedTaskExecutor;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

public abstract class SvdDsfRegistersCompositeCacheBase
implements SvdDsfRegistersCompositeCache {
    protected DsfSession session;
    protected SvdWatchModel model;
    protected SvdWatchContextChangeListener contextChangeListener;
    protected SvdPostponedTaskExecutor updateExecutor;
    protected SvdDsfRegistersReadAlwaysCache readAlwaysCache;
    protected SvdDsfRegistersReadAlwaysCache.RegistersCacheListener registersCacheListener;
    protected SvdDsfRegistersReadOnceCache readOnceCache;
    protected boolean scheduleUpdateOnWrite = false;
    protected IDMContext idmContext;

    @Override
    public void initialize(IDMContext idmContext) {
        this.idmContext = idmContext;
        this.readAlwaysCache.initialize(idmContext);
        this.readOnceCache.initialize(idmContext);
    }

    @Override
    public void setValue(SvdRegister r, BigInteger value) {
        if (this.scheduleUpdateOnWrite) {
            this.scheduleUpdate();
        }
    }

    @Override
    public final BigInteger getValue(SvdRegister register) {
        return (BigInteger)this.forRegister(register, r -> this.readOnceCache.getValue((SvdRegister)r), r -> this.readAlwaysCache.getValue((SvdRegister)r));
    }

    @Override
    public final BigInteger getPrevValue(SvdRegister register) {
        return (BigInteger)this.forRegister(register, r -> this.readOnceCache.getPrevValue((SvdRegister)r), r -> this.readAlwaysCache.getPrevValue((SvdRegister)r));
    }

    @Override
    public final void removeRegisters(Collection<SvdRegister> registers) {
        SvdTrace.trace("removeRegisters", new Object[0]);
        this.forRegisters(registers, r -> this.readOnceCache.removeRegisters((Collection<SvdRegister>)r), r -> this.readAlwaysCache.removeRegisters((Collection<SvdRegister>)r));
    }

    @Override
    public final void addRegisters(Collection<SvdRegister> registers) {
        SvdTrace.trace("addRegisters", new Object[0]);
        this.forRegisters(registers, r -> this.readOnceCache.addRegisters((Collection<SvdRegister>)r), r -> this.readAlwaysCache.addRegisters((Collection<SvdRegister>)r));
        this.registersCacheListener.cacheInvalidated();
    }

    @Override
    public void update() {
        SvdTrace.trace("update", new Object[0]);
        this.scheduleUpdate();
    }

    @Override
    public void dispose() {
        SvdTrace.trace("dispose", new Object[0]);
        this.updateExecutor.shutdown();
        this.model.getContextManager().removeListener(this.contextChangeListener);
        this.readAlwaysCache.removeListener(this.registersCacheListener);
        this.readAlwaysCache.dispose();
        this.readOnceCache.dispose();
    }

    protected void installListeners() {
        this.model.getContextManager().addListener(this.contextChangeListener);
        this.readAlwaysCache.addListener(this.registersCacheListener);
    }

    protected void scheduleUpdate() {
        this.updateExecutor.scheduleWork();
    }

    private <T> T forRegister(SvdRegister register, Function<SvdRegister, T> readOnceFunction, Function<SvdRegister, T> readAlwaysFunction) {
        if (this.isReadOnce(register)) {
            return (T)readOnceFunction.apply((Object)register);
        }
        return (T)readAlwaysFunction.apply((Object)register);
    }

    private void forRegisters(Collection<SvdRegister> registers, Consumer<Collection<SvdRegister>> readOnceConsumer, Consumer<Collection<SvdRegister>> readAlwaysConsumer) {
        Set<Map.Entry<Boolean, List<SvdRegister>>> entrySet = registers.stream().collect(Collectors.groupingBy(r -> this.isReadOnce((SvdRegister)r))).entrySet();
        for (Map.Entry<Boolean, List<SvdRegister>> entry : entrySet) {
            List<SvdRegister> values = entry.getValue();
            if (values.isEmpty()) continue;
            if (entry.getKey().booleanValue()) {
                readOnceConsumer.accept(values);
                continue;
            }
            readAlwaysConsumer.accept(values);
        }
    }

    public void contextChanged(SvdWatchContextChangeEvent e) {
        if (e.registers.isEmpty()) {
            return;
        }
        switch (e.changeType) {
            case SET_READ_ALWAYS: {
                this.readOnceCache.removeRegisters(e.registers);
                this.readAlwaysCache.addRegisters(e.registers);
                return;
            }
            case SET_READ_ON_DEMAND: {
                this.handleReadOnce(e.registers);
                break;
            }
            case READ_REQUEST: {
                if (!e.session.equals((Object)this.session)) break;
                this.readOnceCache.update(e.registers);
                break;
            }
        }
    }

    private void handleReadOnce(Collection<SvdRegister> registers) {
        HashMap<SvdRegister, BigInteger> registerToValueMap = new HashMap<SvdRegister, BigInteger>();
        for (SvdRegister r : registers) {
            registerToValueMap.put(r, this.readAlwaysCache.getValue(r));
        }
        this.readAlwaysCache.removeRegisters(registers);
        this.readOnceCache.addRegisters(registerToValueMap);
    }

    private boolean isReadOnce(SvdRegister r) {
        return this.model.getContextManager().getContext(r).getReadPolicy().getType() == SvdWatchReadPolicyType.READ_ON_DEMAND;
    }

    protected SvdWatchContextChangeListener createContextChangeListener() {
        return e -> this.contextChanged(e);
    }

    protected SvdDsfRegistersReadAlwaysCache.RegistersCacheListener createRegistersCacheListener() {
        return () -> this.scheduleUpdate();
    }

    protected SvdPostponedTaskExecutor createUpdateExecutor() {
        return new SvdPostponedTaskExecutor(2, () -> this.readAlwaysCache.update(), 100L, TimeUnit.MILLISECONDS);
    }

    protected abstract SvdDsfRegistersReadAlwaysCache createReadAlwaysCache();

    protected abstract SvdDsfRegistersReadOnceCache createReadOnceCache();

    public static class Builder<T extends Builder<T, I>, I extends SvdDsfRegistersCompositeCacheBase> {
        protected final I instance;

        protected Builder(I instance) {
            this.instance = instance;
        }

        public T model(SvdWatchModel model) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).model = model;
            return (T)this;
        }

        public T session(DsfSession session) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).session = session;
            return (T)this;
        }

        public T updateExecutor(SvdPostponedTaskExecutor updateExecutor) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).updateExecutor = updateExecutor;
            return (T)this;
        }

        public T contextChangeListener(SvdWatchContextChangeListener contextChangeListener) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).contextChangeListener = contextChangeListener;
            return (T)this;
        }

        public T readAlwaysCache(SvdDsfRegistersReadAlwaysCache readAlwaysCache) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).readAlwaysCache = readAlwaysCache;
            return (T)this;
        }

        public T registersCacheListener(SvdDsfRegistersReadAlwaysCache.RegistersCacheListener registersCacheListener) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).registersCacheListener = registersCacheListener;
            return (T)this;
        }

        public T readOnceCache(SvdDsfRegistersReadOnceCache readOnceCache) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).readOnceCache = readOnceCache;
            return (T)this;
        }

        public T scheduleUpdateOnWrite(boolean scheduleUpdateOnWrite) {
            ((SvdDsfRegistersCompositeCacheBase)this.instance).scheduleUpdateOnWrite = scheduleUpdateOnWrite;
            return (T)this;
        }

        protected void init(I manager) {
            if (((SvdDsfRegistersCompositeCacheBase)this.instance).model == null) {
                throw new IllegalStateException("model is null");
            }
            ((SvdDsfRegistersCompositeCacheBase)manager).model = ((SvdDsfRegistersCompositeCacheBase)this.instance).model;
            if (((SvdDsfRegistersCompositeCacheBase)this.instance).session == null) {
                throw new IllegalStateException("session is null");
            }
            ((SvdDsfRegistersCompositeCacheBase)manager).session = ((SvdDsfRegistersCompositeCacheBase)this.instance).session;
            ((SvdDsfRegistersCompositeCacheBase)manager).updateExecutor = ((SvdDsfRegistersCompositeCacheBase)this.instance).updateExecutor == null ? ((SvdDsfRegistersCompositeCacheBase)manager).createUpdateExecutor() : ((SvdDsfRegistersCompositeCacheBase)this.instance).updateExecutor;
            ((SvdDsfRegistersCompositeCacheBase)manager).contextChangeListener = ((SvdDsfRegistersCompositeCacheBase)this.instance).contextChangeListener == null ? ((SvdDsfRegistersCompositeCacheBase)manager).createContextChangeListener() : ((SvdDsfRegistersCompositeCacheBase)this.instance).contextChangeListener;
            ((SvdDsfRegistersCompositeCacheBase)manager).readAlwaysCache = ((SvdDsfRegistersCompositeCacheBase)this.instance).readAlwaysCache == null ? ((SvdDsfRegistersCompositeCacheBase)manager).createReadAlwaysCache() : ((SvdDsfRegistersCompositeCacheBase)this.instance).readAlwaysCache;
            ((SvdDsfRegistersCompositeCacheBase)manager).registersCacheListener = ((SvdDsfRegistersCompositeCacheBase)this.instance).registersCacheListener == null ? ((SvdDsfRegistersCompositeCacheBase)manager).createRegistersCacheListener() : ((SvdDsfRegistersCompositeCacheBase)this.instance).registersCacheListener;
            ((SvdDsfRegistersCompositeCacheBase)manager).readOnceCache = ((SvdDsfRegistersCompositeCacheBase)this.instance).readOnceCache == null ? ((SvdDsfRegistersCompositeCacheBase)manager).createReadOnceCache() : ((SvdDsfRegistersCompositeCacheBase)this.instance).readOnceCache;
            ((SvdDsfRegistersCompositeCacheBase)manager).scheduleUpdateOnWrite = ((SvdDsfRegistersCompositeCacheBase)this.instance).scheduleUpdateOnWrite;
        }
    }
}

