/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.templateengine.process;

import com.nxp.s32ds.ext.cdt.internal.core.CoreMessages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AddFiles
extends ProcessRunner {
    private static final String PROJECT_TARGET = "projectName";
    private static final String FILES = "files";
    private static final String END_PATTERN = "endPattern";
    private static final String START_PATTERN = "startPattern";
    private TemplateCore template;

    public AddFiles() {
    }

    public AddFiles(TemplateCore template, String processId) {
        this.template = template;
    }

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        this.template = template;
        IProject projectHandle = null;
        ProcessArgument[][] files = null;
        String startPattern = null;
        String endPattern = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals(PROJECT_TARGET)) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals(FILES)) {
                files = arg.getComplexArrayValue();
            } else if (argName.equals(START_PATTERN)) {
                startPattern = arg.getSimpleValue();
            } else if (argName.equals(END_PATTERN)) {
                endPattern = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(CoreMessages.Process_project_null);
        }
        if (!projectHandle.isAccessible()) {
            String msg = NLS.bind((String)CoreMessages.Process_project_not_accessible, (Object)projectHandle.getName());
            throw new ProcessFailureException(msg);
        }
        if (files == null) {
            throw new ProcessFailureException(CoreMessages.Process_file_null);
        }
        processArgumentArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            ProcessArgument file = processArgumentArray[n2];
            String fileSourceURI = file[0].getSimpleValue();
            String fileTargetPath = file[1].getSimpleValue();
            boolean replaceable = Boolean.valueOf(file[2].getSimpleValue());
            this.addFileByTemplateParams(projectHandle, fileSourceURI, fileTargetPath, startPattern, endPattern, replaceable);
            ++n2;
        }
        try {
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFileByTemplateParams(IProject projectHandle, String fileSourceURI, String fileTargetPath, String startPattern, String endPattern, boolean replaceable) throws ProcessFailureException {
        URL urlSourceFile = null;
        try {
            URL url = new URL(fileSourceURI);
            urlSourceFile = FileLocator.toFileURL((URL)url);
            if (urlSourceFile == null) {
                String msg = NLS.bind((String)CoreMessages.Process_resource_not_found, (Object)url);
                throw new ProcessFailureException(msg);
            }
        }
        catch (IOException iOException) {
            String msg = NLS.bind((String)CoreMessages.Process_resource_could_not_parse, (Object)fileSourceURI);
            throw new ProcessFailureException(msg);
        }
        InputStream contentStream = null;
        if (replaceable) {
            String fileContents;
            try {
                fileContents = ProcessHelper.readFromFile((URL)urlSourceFile);
            }
            catch (IOException iOException) {
                String text = NLS.bind((String)CoreMessages.Process_source_resource_not_found, (Object)urlSourceFile);
                throw new ProcessFailureException(text);
            }
            fileContents = startPattern != null && endPattern != null ? ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents, (String)startPattern, (String)endPattern), (Map)this.template.getValueStore(), (String)startPattern, (String)endPattern) : ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)this.template.getValueStore());
            contentStream = new ByteArrayInputStream(fileContents.getBytes(Charset.defaultCharset()));
        } else {
            try {
                contentStream = urlSourceFile.openStream();
            }
            catch (IOException e) {
                String text = NLS.bind((String)CoreMessages.Process_source_stream_not_open, (Object)urlSourceFile);
                throw new ProcessFailureException(text, (Throwable)e);
            }
        }
        try {
            IFile iFile = projectHandle.getFile(fileTargetPath);
            if (!iFile.getParent().exists()) {
                ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
            }
            if (!iFile.exists()) {
                iFile.create(contentStream, true, null);
                iFile.refreshLocal(1, null);
                return;
            }
            if (replaceable) {
                iFile.setContents(contentStream, true, true, null);
                return;
            }
            String text = NLS.bind((String)CoreMessages.Process_target_replace_error, (Object)urlSourceFile);
            throw new ProcessFailureException(text);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }
}

