/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.view;

import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractOsekView
extends Composite {
    public static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 255, 225);
    protected Sash m_sash;
    protected OrtiImplementation m_ortii;
    protected UIJob m_updateViewUIJob;
    boolean exit = false;
    boolean delayedUpdate = false;
    protected boolean m_resumed = false;

    public AbstractOsekView(Composite parent, int style, OrtiImplementation ortii) {
        super(parent, style);
        this.m_ortii = ortii;
        this.setLayout((Layout)new FormLayout());
        this.m_sash = new Sash((Composite)this, 512);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(15, 0);
        this.m_sash.setLayoutData((Object)data);
        this.m_sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)AbstractOsekView.this.m_sash.getLayoutData()).left = new FormAttachment(0, event.x);
            }
        });
        this.m_sash.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                AbstractOsekView.this.m_sash.getParent().layout();
            }
        });
        Composite panel = this.createLeftSidePanel();
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.m_sash, 0);
        panel.setLayoutData((Object)data);
        panel = this.createRightSidePanel();
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)this.m_sash, 0);
        data.right = new FormAttachment(100, 0);
        panel.setLayoutData((Object)data);
        this.m_sash.pack();
        this.m_updateViewUIJob = this.createUpdateUIJob();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.layout();
        Point p = this.getParent().getSize();
        return new Point(p.x - 20, p.y);
    }

    private UIJob createUpdateUIJob() {
        UIJob job = new UIJob("Update current view"){
            private boolean busy;
            {
                this.busy = false;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!AbstractOsekView.this.isDisposed()) {
                    if (AbstractOsekView.this.delayedUpdate) {
                        AbstractOsekView.this.delayedUpdate = false;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            OsekPlugin.log(e);
                        }
                    }
                    this.busy = true;
                    AbstractOsekView.this.doUpdateCurrentView();
                    this.busy = false;
                }
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !this.busy;
            }
        };
        job.setSystem(true);
        return job;
    }

    protected abstract Composite createLeftSidePanel();

    protected abstract Composite createRightSidePanel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        UIJob uIJob = this.m_updateViewUIJob;
        synchronized (uIJob) {
            this.m_updateViewUIJob.schedule();
        }
    }

    protected abstract void doUpdateCurrentView();

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        this.exit = true;
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        this.m_resumed = true;
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        this.m_resumed = false;
        IRunControl.StateChangeReason scr = event.getReason();
        if (scr == IRunControl.StateChangeReason.SIGNAL) {
            this.delayedUpdate = true;
            this.updateView();
            return;
        }
        if (scr == IRunControl.StateChangeReason.BREAKPOINT || scr == IRunControl.StateChangeReason.STEP) {
            this.updateView();
        }
    }

    public void dispose() {
        super.dispose();
    }
}

