/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.parser;

import com.freescale.s32ds.debug.ka.osek.parser.ILexemeAnalyzer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LexemAnalyzer
implements ILexemeAnalyzer {
    private int m_pos;
    private int m_line;
    public ILexemeAnalyzer.OP_LexemeType m_type;
    private String text;
    private String currStr;
    private int len;
    private int numStr;
    private boolean comment;
    private boolean EOF = false;
    public List<String> rows;
    private final Pattern p_OP_ID = Pattern.compile("[a-zA-Z]+[a-zA-Z0-9_-]*");
    private final Pattern p_OP_INT = Pattern.compile("[0xX]*[0-9a-fA-F-]+");

    public LexemAnalyzer(List<String> list) {
        this.rows = list;
        this.m_line = -1;
        this.numStr = list.size();
        this.nextString();
    }

    private void nextString() {
        if (this.m_line < this.numStr - 1) {
            this.m_pos = 0;
            ++this.m_line;
            this.currStr = this.rows.get(this.m_line);
            this.len = this.currStr.length();
        } else {
            this.EOF = true;
            this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_EOF;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processWhiteSpace() {
        stop = false;
        if (!this.EOF) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            if (this.currStr.isEmpty()) {
                this.nextString();
                if (!this.EOF) continue;
                return;
            }
            ch = this.currStr.charAt(this.m_pos);
            switch (ch) {
                case '\t': 
                case ' ': {
                    ++this.m_pos;
                    break;
                }
                case '/': {
                    if (this.comment && this.currStr.charAt(this.m_pos - 1) == '*') {
                        this.comment = false;
                        ++this.m_pos;
                        break;
                    }
                    if (this.currStr.charAt(this.m_pos + 1) == '/') {
                        this.nextString();
                        break;
                    }
                    if (this.currStr.charAt(this.m_pos + 1) == '*') {
                        this.comment = true;
                    }
                    ++this.m_pos;
                    break;
                }
                default: {
                    if (this.comment) {
                        ++this.m_pos;
                        break;
                    }
                    stop = true;
                }
            }
            if (this.m_pos < this.len) continue;
            this.nextString();
lbl32:
            // 4 sources

            ** while (!stop)
        }
lbl33:
        // 1 sources

    }

    private boolean processPattern(Pattern pat) {
        Matcher matcher = pat.matcher(this.currStr);
        if (matcher.find(this.m_pos)) {
            int newPos = matcher.end();
            this.text = this.currStr.substring(this.m_pos, newPos);
            this.m_pos = newPos;
            if (this.m_pos >= this.len) {
                this.nextString();
            }
            return true;
        }
        return false;
    }

    public boolean getNext() {
        this.processWhiteSpace();
        if (this.EOF) {
            return false;
        }
        char ch = this.currStr.charAt(this.m_pos);
        if (Character.isLetter(ch)) {
            this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_ID;
            return this.processPattern(this.p_OP_ID);
        }
        if (Character.isDigit(ch)) {
            this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_IntegerConstant;
            return this.processPattern(this.p_OP_INT);
        }
        if (ch == '\"') {
            return this.processString();
        }
        if (ch == '\'') {
            this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_CharacterConstant;
            ++this.m_pos;
            int newPos = this.currStr.indexOf(ch, this.m_pos);
            if (newPos < 0) {
                return false;
            }
            this.text = this.currStr.substring(this.m_pos, newPos);
            this.m_pos = newPos + 1;
            if (this.m_pos >= this.len) {
                this.nextString();
            }
            return true;
        }
        this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_Symbol;
        this.text = Character.toString(ch);
        ++this.m_pos;
        if (this.m_pos >= this.len) {
            this.nextString();
        }
        return true;
    }

    private boolean processString() {
        this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_String;
        ++this.m_pos;
        int newPos = this.currStr.indexOf("\"", this.m_pos);
        if (newPos < 0) {
            this.m_type = ILexemeAnalyzer.OP_LexemeType.OP_MultiString;
            this.text = this.currStr.substring(this.m_pos);
            while (true) {
                this.nextString();
                newPos = this.currStr.indexOf("\"", this.m_pos);
                if (newPos > 0) break;
                this.text = String.valueOf(this.text) + this.currStr;
            }
        }
        this.text = this.currStr.substring(this.m_pos, newPos);
        this.m_pos = newPos + 1;
        if (this.m_pos >= this.len) {
            this.nextString();
        }
        return true;
    }

    public int getLineNumber() {
        return this.m_line;
    }

    public String getStr() {
        return this.text;
    }

    public boolean getNextCmp(ILexemeAnalyzer.OP_LexemeType op) {
        this.getNext();
        return this.m_type == op;
    }

    public boolean getNextCmp(ILexemeAnalyzer.OP_LexemeType op, String string) {
        return this.getNextCmp(op) && this.text.equalsIgnoreCase(string);
    }

    public void reset() {
        this.m_line = -1;
        this.m_pos = -1;
        if (this.rows != null) {
            this.rows.clear();
        }
    }

    public boolean Cmp(ILexemeAnalyzer.OP_LexemeType op, String string) {
        return this.m_type == op && this.text.equalsIgnoreCase(string);
    }
}

