/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.orti.model;

import com.freescale.s32ds.debug.ka.osek.OsekAwareAdapter;
import com.freescale.s32ds.debug.ka.osek.implementation.IntegerListHolder;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.TypeObject;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiAttributeTraceElement;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.orti.model.TraceElementViewNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class TraceModel {
    public static final int DEFAULT_TRACE_SAMPLING_INTERVAL = 50;
    public static final int MAX_VIEW_TRACE_SLOTS = 50;
    public static final int MIN_VIEW_TRACE_SLOTS = 10;
    public static final int MAX_TRACE_SLOTS = 50;
    private OrtiImplementation fOrtiIntf;
    private int fSlots = 10;
    private int fSamplingTime = 50;
    private List<OrtiAttributeTraceElement> fTraceElements = new LinkedList<OrtiAttributeTraceElement>();
    private List<OrtiAttributeTraceElement> fCrtTraceElements = new LinkedList<OrtiAttributeTraceElement>();
    private int[] fLastSendIDs = new int[0];
    private OrtiAttributeTraceElement fSampledSlots = new OrtiAttributeTraceElement("epochs", null, "epochs");
    private List<TraceElementViewNode> fViewNodes = new LinkedList<TraceElementViewNode>();
    private int fCurrentEpoch = 0;
    private boolean fNeedUpdate = false;
    private boolean fDirty = false;

    public TraceModel(OrtiImplementation ortii) {
        this.fOrtiIntf = ortii;
    }

    public void dispose() {
    }

    public OrtiImplementation GetImpl() {
        return this.fOrtiIntf;
    }

    public void setSlots(int Slots) {
        this.setDirty(this.fSlots != Slots);
        this.fSlots = Slots;
    }

    public int getSlots() {
        return this.fSlots;
    }

    public void setSamplingTime(int SamplingTime) {
        this.setDirty(this.fSamplingTime != SamplingTime);
        this.fSamplingTime = SamplingTime;
    }

    public int getSamplingTime() {
        return this.fSamplingTime;
    }

    public int getCurrentEpoch() {
        return this.fCurrentEpoch;
    }

    private void fillTraceDataStruct() {
        TypeObject[] objTree = this.fOrtiIntf.getObjectTree();
        if (objTree != null) {
            TypeObject[] typeObjectArray = objTree;
            int n = objTree.length;
            int n2 = 0;
            while (n2 < n) {
                TypeObject impltype = typeObjectArray[n2];
                OrtiImplementation.ImplObjectInfo info = this.fOrtiIntf.getImplInfo(impltype.getType());
                LinkedList<String> limplAttr = new LinkedList<String>();
                OrtiImplAttr[] ortiImplAttrArray = info.implObject.getAtributes();
                int n3 = ortiImplAttrArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    OrtiImplAttr impattr = ortiImplAttrArray[n4];
                    if (impattr.isSetToTrace()) {
                        limplAttr.add(impattr.name);
                    }
                    ++n4;
                }
                OrtiObject[] objects = info.GetObjects();
                LinkedList<TraceElementViewNode> objList = new LinkedList<TraceElementViewNode>();
                LinkedList<TraceElementViewNode> attrList = new LinkedList<TraceElementViewNode>();
                OrtiObject[] ortiObjectArray = objects;
                int n5 = objects.length;
                int n6 = 0;
                while (n6 < n5) {
                    OrtiObject obj = ortiObjectArray[n6];
                    attrList.clear();
                    OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                    int n7 = ortiObjectAttributeArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        OrtiObjectAttribute attr = ortiObjectAttributeArray[n8];
                        if (limplAttr.contains(attr.implAttribute.name)) {
                            String id = String.format("%s\\%s\\%s", impltype.getType(), obj.getName(), attr.implAttribute.name);
                            OrtiAttributeTraceElement traceE = new OrtiAttributeTraceElement(id, attr, impltype.getType());
                            this.fTraceElements.add(traceE);
                            attrList.add(new TraceElementViewNode(traceE, new Object[0]));
                        }
                        ++n8;
                    }
                    if (attrList.size() > 0) {
                        objList.add(new TraceElementViewNode(obj, attrList.toArray()));
                    }
                    ++n6;
                }
                if (objList.size() > 0) {
                    this.fViewNodes.add(new TraceElementViewNode(info.implObject, objList.toArray()));
                }
                ++n2;
            }
        }
    }

    public Object[] GetTraceableAttrHierarchy() {
        if (this.fViewNodes.isEmpty() || this.fTraceElements.isEmpty()) {
            this.fillTraceDataStruct();
        }
        return this.fViewNodes.toArray();
    }

    public void SetTracedAttr(OrtiAttributeTraceElement element, boolean traced) {
        if (traced) {
            if (!this.fCrtTraceElements.contains(element)) {
                this.fCrtTraceElements.add(element);
            }
        } else {
            this.fCrtTraceElements.remove(element);
        }
        this.setDirty(true);
    }

    public Object[] GetCurrentTracedElements(boolean refresh) {
        if (refresh && this.isUpdateNeeded()) {
            this.UpdateElementTraceDataAll();
        }
        return this.fCrtTraceElements.toArray(new Object[0]);
    }

    public int[] GetTracedAttrIdArray() {
        this.fLastSendIDs = new int[this.fCrtTraceElements.size()];
        int i = 0;
        for (OrtiAttributeTraceElement e : this.fCrtTraceElements) {
            this.fLastSendIDs[i++] = e.getAttribute().attrID;
        }
        return this.fLastSendIDs;
    }

    public OrtiAttributeTraceElement.TracedValue[] getSampledSlots() {
        return this.fSampledSlots.getLastValues(this.fSlots);
    }

    public void SendTraceParameters() {
        OsekAwareAdapter oseka = this.fOrtiIntf.getOsekAwareAdapter();
        int[] attrList = this.GetTracedAttrIdArray();
        if (oseka.SetTraceParams(this.fOrtiIntf.getSessionID(), this.fSlots, this.fSamplingTime, attrList)) {
            this.fDirty = false;
        }
    }

    public void UpdateElementTraceDataAll() {
        if (this.fCrtTraceElements.size() > 0) {
            ++this.fCurrentEpoch;
            int maxSampleCount = 0;
            for (OrtiAttributeTraceElement element : this.fCrtTraceElements) {
                this.UpdateElementTraceData(element);
                maxSampleCount = Math.max(maxSampleCount, element.getLastSampleCount());
            }
            Object[] sampl = new Integer[maxSampleCount];
            Arrays.fill(sampl, (Object)this.fSamplingTime);
            this.fSampledSlots.addTraceValues(this.fCurrentEpoch, (Integer[])sampl, new Integer[0]);
        }
        this.setNeedUpdate(false);
    }

    private void UpdateElementTraceData(OrtiAttributeTraceElement attribute) {
        int attrid = attribute.getAttribute().attrID;
        IntegerListHolder traceData = new IntegerListHolder();
        IntegerListHolder erroneousIdxData = new IntegerListHolder();
        OsekAwareAdapter oseka = this.fOrtiIntf.getOsekAwareAdapter();
        if (oseka.GetAttributeTraceBuffer(this.fOrtiIntf.getSessionID(), attrid, traceData, erroneousIdxData) && traceData.value != null && traceData.getValue().length > 0) {
            attribute.addTraceValues(this.fCurrentEpoch, traceData.getValue(), erroneousIdxData.getValue());
        }
    }

    public boolean isTraceEnabled() {
        return !this.fCrtTraceElements.isEmpty();
    }

    public void setDirty(boolean fDirty) {
        this.fDirty = fDirty;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void setNeedUpdate(boolean fNeedUpdate) {
        this.fNeedUpdate = fNeedUpdate;
    }

    public boolean isUpdateNeeded() {
        return this.fNeedUpdate;
    }

    public boolean needAttrRefresh() {
        if (this.fCrtTraceElements.size() != this.fLastSendIDs.length) {
            return true;
        }
        for (OrtiAttributeTraceElement te : this.fCrtTraceElements) {
            boolean found = false;
            int i = 0;
            while (i < this.fLastSendIDs.length) {
                if (te.checkID(this.fLastSendIDs[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            return true;
        }
        return false;
    }
}

