/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core.parsers;

import com.nxp.s32ds.cle.ide.collateral.internal.core.CollateralCoreActivator;
import com.nxp.s32ds.cle.ide.collateral.internal.core.handlers.Messages;
import com.nxp.s32ds.cle.ide.collateral.internal.core.marker.CollateralManifestMarker;
import com.nxp.s32ds.cle.ide.collateral.internal.core.parsers.CollateralManifestParserHandler;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CollateralLoadHandler {
    public static final String ENTRY_OF_MANIFEST_TO_COMPONENT_DOES_NOT_EXIST = "Entry of manifest to component does not exist";
    public static final String COLLATERAL_SERVICE_IS_NOT_EXIST = "Collateral Service is not exist";

    public static void loadFromFile(String path, CollateralRegistry collateralRegistry) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (collateralRegistry == null) {
            throw new IllegalStateException(COLLATERAL_SERVICE_IS_NOT_EXIST);
        }
        if (path == null) {
            CollateralCoreActivator.getInstance().logError(Messages.CollateralLoadHandler_PathIsNull);
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, Messages.CollateralLoadHandler_PathIsNull);
            return;
        }
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        File file = null;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            CollateralManifestParserHandler dh = new CollateralManifestParserHandler(collateralRegistry);
            file = new File(stringVariableManager.performStringSubstitution(path));
            if (!file.exists()) {
                String message = Messages.bind((String)Messages.CollateralLoadHandler_PathIsNotExist, (Object)path);
                CollateralCoreActivator.getInstance().logError(message);
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, message);
                return;
            }
            try {
                Throwable message = null;
                Object var8_13 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    saxParser.parse((InputStream)is, (DefaultHandler)dh);
                    dh.updateCollateralRegistry();
                }
                catch (Throwable throwable) {
                    if (message == null) {
                        message = throwable;
                    } else if (message != throwable) {
                        message.addSuppressed(throwable);
                    }
                    throw message;
                }
            }
            catch (IOException e) {
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
                CollateralCoreActivator.getInstance().logError(e.getMessage());
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            if (file != null) {
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, file.getAbsolutePath(), e.getMessage());
                CollateralCoreActivator.getInstance().logError(file + e.getMessage());
            } else {
                CollateralCoreActivator.getInstance().logError(e.getMessage());
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
            }
        }
        catch (CoreException e) {
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
            CollateralCoreActivator.getInstance().logError(e.getMessage());
        }
    }
}

