/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialGdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessOutputHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessWaitHandler;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.utils.FileUtils;
import com.nxp.swtools.mem.validation.utils.LoggingUtils;
import com.nxp.swtools.mem.validation.utils.PythonProcessUtilities;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PhyDebugView
extends Composite {
    protected static final Logger LOGGER = LogManager.getLogger(PhyDebugView.class);
    protected Text path;
    protected StyledText decodedText;
    protected Button decodeButton;
    protected Button exportPhyLogsButton;
    private static final String DECODE_SCRIPT = "phy_debug_command.py";
    private static final String DECODE_TAG = "DECODED:";
    private static final String EXPORT_SCRIPT = "phy_decoded_logs.txt";
    protected String decodedContent = "";
    protected String pathArg = "--path ";
    protected String ddrTypeArg = "--ddr_type ";

    public PhyDebugView(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite mainComp = new ScrolledComposite((Composite)this, 768);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setExpandHorizontal(true);
        mainComp.setExpandVertical(true);
        Composite childComp = new Composite((Composite)mainComp, 2048);
        childComp.setLayout((Layout)new GridLayout(2, false));
        childComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setContent((Control)childComp);
        final Button selectPhyLogsButton = new Button(childComp, 8);
        selectPhyLogsButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        selectPhyLogsButton.setText(Messages.SelectLogButtonLabel);
        selectPhyLogsButton.setToolTipText(Messages.SelectButtonTooltip);
        selectPhyLogsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(selectPhyLogsButton.getShell(), 4096);
                dialog.setText(Messages.Select);
                String phyFilePath = dialog.open();
                if (phyFilePath != null) {
                    PhyDebugView.this.path.setText(phyFilePath);
                    PhyDebugView.this.path.setSelection(PhyDebugView.this.path.getText().length());
                }
            }
        });
        this.path = this.createPathView(childComp);
        this.decodeButton = this.createDecodeButton(childComp);
        this.decodedText = new StyledText(childComp, 2824);
        this.decodedText.setText("");
        this.decodedText.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_BG"));
        this.decodedText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.exportPhyLogsButton = this.createExportButton(childComp);
        ScrolledCompositeHelper.updateScrollMinSize((Composite)childComp);
    }

    private Text createPathView(Composite parent) {
        Text pathLoc = new Text(parent, 2048);
        GridData pathData = new GridData(4, 0x1000000, true, false);
        pathData.horizontalIndent = 3;
        pathLoc.setLayoutData((Object)pathData);
        pathLoc.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
        final ControlDecoration ctrlDecorator = new ControlDecoration((Control)pathLoc, 16512);
        ctrlDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        ctrlDecorator.setDescriptionText(Messages.InvalidFilePathOrExtension);
        pathLoc.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text text = (Text)event.widget;
                String fullPath = text.getText();
                File pathFile = new File(fullPath);
                if (pathFile.exists() && fullPath.endsWith(".bin")) {
                    text.setBackground(null);
                    ctrlDecorator.hide();
                    PhyDebugView.this.decodeButton.setEnabled(true);
                } else {
                    text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                    ctrlDecorator.show();
                    PhyDebugView.this.decodeButton.setEnabled(false);
                }
            }
        });
        return pathLoc;
    }

    private Button createDecodeButton(Composite parent) {
        final Button decodeButtonLoc = new Button(parent, 8);
        decodeButtonLoc.setLayoutData((Object)new GridData(4, 4, false, false));
        decodeButtonLoc.setText(Messages.DecodeButtonLabel);
        decodeButtonLoc.setEnabled(false);
        decodeButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IComponentInstanceConfig instance;
                String ddrMode = "";
                decodeButtonLoc.setEnabled(false);
                decodeButtonLoc.setText(Messages.Decoding);
                IConfigProvider context = ValidationContext.getInstance().getConfigController();
                if (context != null && (instance = context.getInstance(context.getCurrentInstanceName())) != null) {
                    ddrMode = instance.getMode().getId();
                }
                if (!ddrMode.equals("")) {
                    try {
                        String newPlatform;
                        PythonProcessUtilities.startProcess();
                        Process process = PythonProcessUtilities.getProcess();
                        PythonProcessUtilities.addProcessHandlers();
                        ProcessOutputHandler outHandler = PythonProcessUtilities.getOutHandler();
                        ProcessWaitHandler waitHandler = PythonProcessUtilities.getWaitHandler();
                        StringBuilder execName = new StringBuilder();
                        String pythonPath = SerialGdbPyRunAction.getPythonBinPath(null);
                        if (pythonPath.equals("")) {
                            execName.append("python ");
                        } else {
                            execName.append(pythonPath).append(" ");
                        }
                        String decodeScriptPath = String.valueOf(Activator.getDefault().getConfigManager().getScriptsFolder()) + File.separator + PhyDebugView.DECODE_SCRIPT + " ";
                        execName.append(decodeScriptPath);
                        execName.append(String.valueOf(PhyDebugView.this.pathArg) + "\"" + PhyDebugView.this.path.getText() + "\"");
                        VPresentationModel vData = ValidationContext.getInstance().getData();
                        VModel vModel = vData.getModel();
                        if (vModel != null && (newPlatform = vModel.getCustomOption("generate_code_option")) != null) {
                            execName.append(" ");
                            execName.append(String.valueOf(PhyDebugView.this.ddrTypeArg) + "\"" + ddrMode + "\"");
                        }
                        Throwable throwable = null;
                        Object var13_15 = null;
                        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Objects.requireNonNull(process).getOutputStream(), StandardCharsets.UTF_8));){
                            PythonProcessUtilities.sendCommands(writer, execName.toString());
                            if (outHandler != null && waitHandler != null) {
                                PhyDebugView.this.dealWithProcessExecution(outHandler, waitHandler);
                            }
                            PythonProcessUtilities.sendCommands(writer, "exit");
                            PythonProcessUtilities.terminate();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException error) {
                        LOGGER.severe(error.getMessage());
                        PhyDebugView.this.decodedText.setText(Messages.DecodingFailedMessage);
                        PythonProcessUtilities.terminate();
                    }
                } else {
                    PhyDebugView.this.decodedText.setText(Messages.MemTypeFailedMessage);
                }
                decodeButtonLoc.setEnabled(true);
                decodeButtonLoc.setText(Messages.DecodeButtonLabel);
            }
        });
        return decodeButtonLoc;
    }

    private Button createExportButton(Composite parent) {
        final Button exportPhyLogsButtonLoc = new Button(parent, 8);
        exportPhyLogsButtonLoc.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        exportPhyLogsButtonLoc.setText(Messages.ExportPhyButtonLabel);
        exportPhyLogsButtonLoc.setEnabled(false);
        exportPhyLogsButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(exportPhyLogsButtonLoc.getShell(), 8192);
                dialog.setText(Messages.ExportPhyButtonLabel);
                String directoryPath = dialog.open();
                if (directoryPath != null) {
                    if (new File(directoryPath).isDirectory()) {
                        try {
                            Throwable throwable = null;
                            Object var5_8 = null;
                            try (FileOutputStream fileOutStream = new FileOutputStream(Paths.get(directoryPath, PhyDebugView.EXPORT_SCRIPT).toString());){
                                fileOutStream.write(PhyDebugView.this.decodedText.getText().getBytes(StandardCharsets.UTF_8));
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException exception) {
                            LOGGER.severe(exception.getMessage());
                        }
                    } else {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (workbenchWindow != null) {
                            Shell shell = workbenchWindow.getShell();
                            MessageBox notifyUserBox = new MessageBox(shell, 65576);
                            notifyUserBox.setMessage(Messages.InvalidPath);
                            notifyUserBox.open();
                        }
                    }
                }
            }
        });
        return exportPhyLogsButtonLoc;
    }

    protected void dealWithProcessExecution(ProcessOutputHandler outHandler, ProcessWaitHandler waitHandler) {
        StringBuilder processOutput = new StringBuilder();
        String filePath = null;
        boolean isPyException = false;
        while (waitHandler.getState() == RunAction.ExecStatus.RUNNING) {
            String out = outHandler.getOutput();
            processOutput.append(out);
            isPyException = LoggingUtils.isPyException(processOutput.toString());
            if (isPyException) {
                waitHandler.cancel();
                continue;
            }
            if (!out.contains(DECODE_TAG)) continue;
            filePath = out.split(DECODE_TAG)[1].replaceAll("(\\r|\\n)", "");
            waitHandler.cancel();
        }
        if (filePath == null) {
            if (waitHandler.getState() == RunAction.ExecStatus.TIMED_OUT) {
                this.decodedText.setText(Messages.TimeoutMessage);
            } else if (waitHandler.getState() == RunAction.ExecStatus.CANCELLED) {
                String errorMsg = LoggingUtils.extractErrorMessage(processOutput.toString());
                this.decodedText.setText(errorMsg != null ? errorMsg : "");
            } else if (waitHandler.getState() == RunAction.ExecStatus.TERMINATED) {
                this.decodedText.setText(Messages.TerminatedMessage);
            }
            this.exportPhyLogsButton.setEnabled(false);
        } else {
            File decodedFile = new File(filePath);
            if (decodedFile.exists()) {
                this.decodedContent = FileUtils.readTextFile(filePath);
                this.decodedText.setText(this.decodedContent);
                this.decodedText.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_BG"));
                this.exportPhyLogsButton.setEnabled(true);
            } else {
                this.decodedText.setText(Messages.MissingContentMessage);
            }
        }
    }
}

