/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import java.util.Objects;
import java.util.logging.Logger;

public class TableFinishUiUpdater
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(TableFinishUiUpdater.class);
    private VPresentationModel data;
    private VTable table;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private CellResultsMainView cellsView;
    @Nullable
    private final MainView view;

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public TableFinishUiUpdater(VPresentationModel _data, VTable _table) {
        this.data = _data;
        this.table = _table;
        MainView viewLoc = this.view = Objects.requireNonNull(this.data.getView());
        if (!viewLoc.isDisposed()) {
            this.scenarioView = viewLoc.getScenarioView();
            this.cellsView = viewLoc.getCellResultsMainView();
        }
    }

    @Override
    public void run() {
        if (this.view != null && !this.view.isDisposed()) {
            TableFinishUiUpdater.trace(UtilsText.safeString((String)Messages.TableFinishUiUpdater_0));
            if (this.scenarioView != null) {
                this.scenarioView.redrawScenarioFigure();
            }
            VParamVariation selCell = this.data.getSelectedCell();
            VParamVariation goldCell = this.table.getGoldenVariation();
            if (selCell != null && selCell == goldCell && this.cellsView != null) {
                this.cellsView.setInput(selCell, null, true);
            }
        } else {
            TableFinishUiUpdater.trace(UtilsText.safeString((String)Messages.TableFinishUiUpdater_1));
        }
    }
}

