/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValueFactory;
import java.util.Objects;

public class VScriptConfig {
    public static final String START_ADDRESS_PARAM_ID = "app.test_params.start_addr";
    public static final String SIZE_PARAM_ID = "app.test_params.size";
    @Nullable
    private Object owner;
    private VScript parent;
    private VScriptParamValue[] paramValues;
    private boolean selected;
    private int numRuns;
    private boolean prevSelected;
    private int prevNumRuns;

    public VScriptConfig(VScript _parent, VScriptParamValue[] _paramValues, boolean _selected, int _numRuns) {
        this.parent = _parent;
        this.paramValues = (VScriptParamValue[])_paramValues.clone();
        this.selected = _selected;
        this.numRuns = _numRuns;
        this.prevSelected = _selected;
        this.prevNumRuns = _numRuns;
    }

    public VScriptConfig(VScriptConfig proto) {
        this.parent = proto.parent;
        this.paramValues = new VScriptParamValue[proto.paramValues.length];
        int i = 0;
        while (i < this.paramValues.length) {
            this.paramValues[i] = VScriptParamValueFactory.create(proto.paramValues[i]);
            ++i;
        }
        this.selected = proto.selected;
        this.numRuns = proto.numRuns;
        this.prevSelected = proto.prevSelected;
        this.prevNumRuns = proto.prevNumRuns;
    }

    public void applyCurrentSelection() {
        this.prevSelected = this.selected;
        this.prevNumRuns = this.numRuns;
    }

    public String getName() {
        return String.format(Messages.VScriptConfig_0, this.parent.getName(), new Integer(this.prevNumRuns));
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public @Nullable Object getOwner() {
        return this.owner;
    }

    public @Nullable VScriptParamValue getParamValue(String paramId) {
        VScriptParamValue[] vScriptParamValueArray = this.paramValues;
        int n = this.paramValues.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptParamValue paramValue = vScriptParamValueArray[n2];
            if (paramValue.getParam().getId().equals(paramId)) {
                return paramValue;
            }
            ++n2;
        }
        return null;
    }

    public VScriptParamValue[] getParamValues() {
        return (VScriptParamValue[])this.paramValues.clone();
    }

    public int getPrevNumRuns() {
        return this.prevNumRuns;
    }

    public VScript getScript() {
        return this.parent;
    }

    public boolean isPrevSelected() {
        return this.prevSelected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setNumRuns(int _numRuns) {
        this.numRuns = _numRuns;
    }

    public void setOwner(Object _owner) {
        this.owner = _owner;
    }

    public void setSelected(boolean _selected) {
        this.selected = _selected;
    }

    public @Nullable VScriptParam getSizeParam() {
        VScriptParamValue[] vScriptParamValueArray = this.paramValues;
        int n = this.paramValues.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptParamValue pv = vScriptParamValueArray[n2];
            if (VScriptParam.VScriptParamType.INT_SIZE_DEC.equals((Object)pv.getParam().getType())) {
                return pv.getParam();
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return this.owner == null ? this.parent.getName() : String.valueOf(this.parent.getName()) + " from " + Objects.requireNonNull(this.owner).toString();
    }
}

