/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.Tables;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioGroup;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import java.io.File;
import java.util.List;

public class ValidationModel {
    private VStage[] stages;
    private Tables tables;
    private Scripts scripts;

    public ValidationModel(ValidationModel prototype, ValidationContext vContext) {
        IScenarioElement scenario;
        int n;
        int n2;
        IScenarioElement[] iScenarioElementArray;
        this.scripts = new Scripts(prototype.scripts);
        this.tables = new Tables(prototype.tables, this.scripts, vContext);
        this.stages = new VStage[prototype.stages.length];
        int i = 0;
        while (i < this.stages.length) {
            this.stages[i] = new VStage(prototype.stages[i]);
            ++i;
        }
        VStage[] vStageArray = this.stages;
        int n3 = this.stages.length;
        int n4 = 0;
        while (n4 < n3) {
            VStage stage = vStageArray[n4];
            iScenarioElementArray = stage.getScenarioElements();
            n2 = iScenarioElementArray.length;
            n = 0;
            while (n < n2) {
                scenario = iScenarioElementArray[n];
                this.updateTableReferences(scenario, this.tables);
                ++n;
            }
            ++n4;
        }
        vStageArray = this.stages;
        n3 = this.stages.length;
        n4 = 0;
        while (n4 < n3) {
            VStage stage = vStageArray[n4];
            iScenarioElementArray = stage.getScenarioElements();
            n2 = iScenarioElementArray.length;
            n = 0;
            while (n < n2) {
                scenario = iScenarioElementArray[n];
                this.updateScriptConfigReferences(scenario);
                ++n;
            }
            ++n4;
        }
    }

    public ValidationModel(VStage[] _vStages, Tables _tables, Scripts _scripts) {
        this.stages = (VStage[])_vStages.clone();
        this.tables = _tables;
        this.scripts = _scripts;
    }

    public void addScript(VScript userScript, VStage crtStage, VScenario crtScenario, boolean stageSync) {
        this.scripts.addScript(userScript);
        VStage[] vStageArray = this.stages;
        int n = this.stages.length;
        int n2 = 0;
        while (n2 < n) {
            VStage stage = vStageArray[n2];
            IScenarioElement[] iScenarioElementArray = stage.getScenarioElements();
            int n3 = iScenarioElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IScenarioElement elem = iScenarioElementArray[n4];
                if (stage == crtStage && stageSync) {
                    this.addScriptConfig(elem, crtScenario, userScript, true, 1);
                } else {
                    this.addScriptConfig(elem, crtScenario, userScript, false, 0);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void addScriptConfig(IScenarioElement elem, VScenario crtScenario, VScript userScript, boolean selected, int numRuns) {
        VScenario scenario;
        if (elem instanceof VScenarioGroup) {
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                this.addScriptConfig(child, crtScenario, userScript, selected, numRuns);
                ++n2;
            }
        }
        if (elem instanceof VScenario && (scenario = (VScenario)elem) == crtScenario) {
            VScriptConfig sc = new VScriptConfig(userScript, new VScriptParamValue[0], true, 1);
            scenario.addScriptConfig(sc);
        }
    }

    public boolean deleteScript(VScript script) {
        if (!script.isUserScript()) {
            return false;
        }
        boolean deleteWorked = true;
        String scriptInputFilePath = String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + script.getId() + ".json";
        File scriptInputFile = new File(scriptInputFilePath);
        if (!scriptInputFile.exists()) {
            return false;
        }
        deleteWorked = scriptInputFile.delete();
        if (deleteWorked) {
            this.scripts.removeScript(script);
            VStage[] vStageArray = this.stages;
            int n = this.stages.length;
            int n2 = 0;
            while (n2 < n) {
                VStage stage = vStageArray[n2];
                IScenarioElement[] iScenarioElementArray = stage.getScenarioElements();
                int n3 = iScenarioElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IScenarioElement elem = iScenarioElementArray[n4];
                    this.removeScriptConfig(elem, script);
                    ++n4;
                }
                ++n2;
            }
            Activator.getDefault().getCgenManager().onRemoveScript(script);
        }
        return deleteWorked;
    }

    public @Nullable VScript getScript(String scriptId) {
        return this.scripts.getScript(scriptId);
    }

    public List<VScript> getScriptList() {
        return this.scripts.getScripts();
    }

    public int getUserScriptListSize() {
        int i = 0;
        for (VScript script : this.scripts.getScripts()) {
            if (!script.isUserScript()) continue;
            ++i;
        }
        return i;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public VTable getTable(String tableId) {
        return this.tables.getTable(tableId);
    }

    public List<VTable> getTables() {
        return this.tables.getTables();
    }

    public VTable[] getTables(String idSubstr) {
        return this.tables.getTables(idSubstr);
    }

    public VStage[] getValidationStages() {
        return (VStage[])this.stages.clone();
    }

    public void populate(ValidationContext vContext) {
        this.tables.populate(vContext);
    }

    private void removeScriptConfig(IScenarioElement elem, VScript script) {
        if (elem instanceof VScenarioGroup) {
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                this.removeScriptConfig(child, script);
                ++n2;
            }
        }
        if (elem instanceof VScenario) {
            VScenario scenario = (VScenario)elem;
            scenario.removeScriptConfig(script);
        }
    }

    public void setTables(Tables tables) {
        this.tables = tables;
    }

    public void update(ValidationContext vContext) {
        VStage[] vStageArray = this.stages;
        int n = this.stages.length;
        int n2 = 0;
        while (n2 < n) {
            VStage stage = vStageArray[n2];
            CollectionsUtils.Pair<String, String> condition = stage.getVisibleCondition();
            if (condition != null) {
                String propertyValue;
                IConfigProvider configController = vContext.getConfigController();
                if (configController != null && (propertyValue = configController.getPropertyEnumId((String)condition.getFirst())) != null) {
                    stage.setVisible(propertyValue.equals(condition.getSecond()));
                }
            } else {
                stage.setVisible(true);
            }
            VScenario[] vScenarioArray = stage.getScenarios();
            int n3 = vScenarioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VScenario scenario = vScenarioArray[n4];
                condition = scenario.getVisibleCondition();
                if (condition != null) {
                    String propertyValue;
                    IConfigProvider configController = vContext.getConfigController();
                    if (configController != null && (propertyValue = configController.getPropertyEnumId((String)condition.getFirst())) != null) {
                        scenario.setVisible(propertyValue.equals(condition.getSecond()));
                    }
                } else {
                    scenario.setVisible(true);
                }
                ++n4;
            }
            ++n2;
        }
        this.tables.update(vContext);
        this.scripts.update(vContext);
    }

    private void updateScriptConfigReferences(IScenarioElement element) {
        if (element instanceof VScenarioGroup) {
            IScenarioElement[] iScenarioElementArray = element.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                this.updateScriptConfigReferences(child);
                ++n2;
            }
        }
        if (element instanceof VScenario) {
            VScenario scenario = (VScenario)element;
            scenario.resolveScriptConfigReferences();
        }
    }

    private void updateTableReferences(IScenarioElement element, Tables tables) {
        VTableGroup group;
        VTable[] oldTables;
        IScenarioElement child;
        int n;
        int n2;
        IScenarioElement[] iScenarioElementArray;
        if (element instanceof VScenarioGroup) {
            iScenarioElementArray = element.getChildren();
            n2 = iScenarioElementArray.length;
            n = 0;
            while (n < n2) {
                child = iScenarioElementArray[n];
                this.updateTableReferences(child, tables);
                ++n;
            }
        }
        if (element instanceof VScenario) {
            iScenarioElementArray = element.getChildren();
            n2 = iScenarioElementArray.length;
            n = 0;
            while (n < n2) {
                child = iScenarioElementArray[n];
                this.updateTableReferences(child, tables);
                ++n;
            }
        }
        if (element instanceof VTableGroup && (oldTables = (group = (VTableGroup)element).getTables()) != null) {
            VTable[] newTables = new VTable[oldTables.length];
            int i = 0;
            while (i < oldTables.length) {
                VTable oldTable = oldTables[i];
                if (oldTable != null) {
                    newTables[i] = tables.getTable(oldTable.getId());
                }
                ++i;
            }
            group.setChildren(newTables);
        }
    }

    public void updateTables(ValidationContext vContext) {
        this.tables.update(vContext);
    }
}

