/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class VRunResult {
    public static final String ERROR_CAPT_HEADER = "Err. capture registers";
    public static final String DEBUG_HEADER = "Dump:";
    public static final String DATA_HEADER = "Data:";
    protected VScriptConfig scriptConfig;
    protected VParamVariation paramVariation;
    protected int numRun;
    protected ResultType type;
    protected String errMessage;
    protected String extraData = "";
    private VLoggingUtils.ScriptResultType failureType;
    private long startTime = -1L;
    private long finalElapsedTime = -1L;
    private String resultText;

    public VRunResult(VParamVariation _paramVariation, VScriptConfig _scriptConfig, int _numRun) {
        this.paramVariation = _paramVariation;
        this.scriptConfig = _scriptConfig;
        this.numRun = _numRun;
        this.type = ResultType.QUEUED;
        this.errMessage = "";
        this.failureType = VLoggingUtils.ScriptResultType.PASSED;
        this.resultText = "";
    }

    public int[] extractDataValues(String log) {
        String[] lines = log.split(CgenManager.LINE_SEPARATOR);
        int dataLineIdx = -1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].indexOf(DATA_HEADER) != -1) {
                dataLineIdx = i + 1;
                break;
            }
            ++i;
        }
        if (dataLineIdx < 0 || dataLineIdx >= lines.length) {
            return new int[0];
        }
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        String[] dataElems = lines[dataLineIdx].split("[\\s,]+");
        String[] stringArray = dataElems;
        int n = dataElems.length;
        int n2 = 0;
        while (n2 < n) {
            String dataElem = stringArray[n2];
            if (dataElem.length() > 0) {
                dataList.add(Integer.decode(dataElem));
            }
            ++n2;
        }
        int[] data = new int[dataList.size()];
        int idx = 0;
        for (Integer ld : dataList) {
            data[idx++] = ld;
        }
        return data;
    }

    public String getErrorMessage() {
        return this.errMessage;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public int getNumRun() {
        return this.numRun;
    }

    public VParamVariation getParamVariation() {
        return this.paramVariation;
    }

    public VScriptConfig getScriptConfig() {
        return this.scriptConfig;
    }

    public ResultType getType() {
        return this.type;
    }

    public void setErrorMessage(String _errMessage) {
        this.errMessage = _errMessage;
    }

    public void setExtraData(String extractExtraData) {
        this.extraData = extractExtraData;
    }

    public void setParamVariation(VParamVariation _paramVariation) {
        this.paramVariation = _paramVariation;
    }

    public void setType(ResultType _type) {
        this.type = _type;
        this.finalElapsedTime = System.currentTimeMillis() - this.startTime;
    }

    public String toString() {
        return String.valueOf(this.scriptConfig.getScript().getName()) + String.format(" - Run %d (%s)", new Integer(this.numRun + 1), this.type.uiName());
    }

    public VLoggingUtils.ScriptResultType getFailureType() {
        return this.failureType;
    }

    public void setFailureType(VLoggingUtils.ScriptResultType failureType) {
        this.failureType = failureType;
    }

    public void setRunning() {
        this.startTime = System.currentTimeMillis();
    }

    public String getElapsedTime() {
        if (this.startTime < 0L || this.type.equals((Object)ResultType.SKIPPED)) {
            return Messages.NotAvailable;
        }
        long elapsedTime = this.finalElapsedTime;
        if (elapsedTime < 0L) {
            elapsedTime = System.currentTimeMillis() - this.startTime;
        }
        return String.format("%02dh %02dm %02ds", new Long(TimeUnit.MILLISECONDS.toHours(elapsedTime)), new Long(TimeUnit.MILLISECONDS.toMinutes(elapsedTime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(elapsedTime))), new Long(TimeUnit.MILLISECONDS.toSeconds(elapsedTime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(elapsedTime))));
    }

    public String getResultText() {
        return this.resultText;
    }

    public void setResultText(String resultText) {
        this.resultText = resultText;
    }

    public static enum ResultType {
        QUEUED("Queued"),
        PASSED("Passed"),
        FAILED("Failed"),
        SKIPPED("Skipped"),
        PHY("PHY Results");

        private final String uiName;

        private ResultType(String _uiName) {
            this.uiName = _uiName;
        }

        public String uiName() {
            return this.uiName;
        }
    }
}

