/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.lproviders;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.ui.UIResourceManager;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.Objects;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TestRunResultsLabelProvider
extends ColumnLabelProvider {
    public static final int NAME_COLUMN_IDX = 0;
    public static final int ITERATION_COLUMN_IDX = 1;
    public static final int ELAPSED_COLUMN_IDX = 2;
    public static final int STATE_COLUMN_IDX = 3;
    public static final int DESCRIPTION_COLUMN_IDX = 4;
    private int columnIndex;

    public TestRunResultsLabelProvider(int _columnIndex) {
        this.columnIndex = _columnIndex;
    }

    public @NonNull Color getForeground(@Nullable Object element) {
        Color fallBackColor;
        if (element instanceof VRunResult) {
            VRunResult runResult = (VRunResult)element;
            if (this.columnIndex == 3) {
                switch (runResult.getType()) {
                    case PASSED: {
                        return Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.DARK_GREEN));
                    }
                    case FAILED: {
                        return Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_RED));
                    }
                }
            }
        }
        if (element != null && (fallBackColor = super.getForeground(element)) != null) {
            return fallBackColor;
        }
        return Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.DARK_GRAY));
    }

    public @Nullable Image getImage(@Nullable Object element) {
        if (element instanceof VRunResult) {
            VRunResult runResult = (VRunResult)element;
            if (this.columnIndex == 3 && !runResult.getErrorMessage().isEmpty()) {
                return Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui/icons/full/obj16/info_tsk.png");
            }
        }
        return null;
    }

    public @NonNull String getText(@Nullable Object element) {
        if (element instanceof VRunResult) {
            VRunResult runResult = (VRunResult)element;
            if (this.columnIndex == 0) {
                return Objects.requireNonNull(runResult.getScriptConfig().getScript().getName());
            }
            if (this.columnIndex == 1) {
                return "" + (runResult.getNumRun() + 1);
            }
            if (this.columnIndex == 2) {
                return runResult.getElapsedTime();
            }
            if (this.columnIndex == 3) {
                return Objects.requireNonNull(runResult.getType().uiName());
            }
            if (this.columnIndex == 4) {
                return Objects.requireNonNull(runResult.getErrorMessage());
            }
        }
        return "";
    }

    public @NonNull Font getToolTipFont(@Nullable Object element) {
        if (element instanceof VRunResult) {
            VRunResult runResult = (VRunResult)element;
            if (this.columnIndex == 3 && !runResult.getErrorMessage().isEmpty()) {
                Font validationFailureHint = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.viewerfont");
                if (validationFailureHint == null) {
                    validationFailureHint = Objects.requireNonNull(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
                }
                return validationFailureHint;
            }
        }
        return Objects.requireNonNull(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
    }

    public @NonNull String getToolTipText(@Nullable Object element) {
        if (element instanceof VRunResult) {
            VRunResult runResult = (VRunResult)element;
            if (this.columnIndex == 3 && !runResult.getErrorMessage().isEmpty()) {
                return Objects.requireNonNull(VLoggingUtils.getHintMessage(runResult));
            }
        }
        return "";
    }
}

