/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class BytePatternParamModifyListener
implements ModifyListener {
    private static final String PATTERN_REGEX = "^(\\s*(0[xX]){0,1}[0-9a-fA-F]{1,8}\\s*\\,{1}\\s*)*((0[xX]){0,1}[0-9a-fA-F]{1,8}\\s*){1}";
    private VPresentationModel data;

    public static String beautifyBytePattern(Long[] bytePattern) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytePattern.length) {
            sb.append(String.format("0x%X", bytePattern[i]));
            sb.append(i == bytePattern.length - 1 ? "" : ", ");
            sb.append((i + 1) % 4 == 0 ? "\n" : "");
            ++i;
        }
        return sb.toString();
    }

    public static String beautifyBytePattern(String bytePattern, boolean appendNewLines) {
        StringBuilder sb = new StringBuilder();
        String tmp = bytePattern;
        String[] cmp = tmp.split(",");
        int i = 0;
        while (i < cmp.length) {
            if (cmp[i].trim().toLowerCase().startsWith("0x")) {
                sb.append(cmp[i].trim());
            } else {
                sb.append("0x" + cmp[i].trim());
            }
            if (i != cmp.length - 1) {
                sb.append(",");
            }
            if (appendNewLines && (i + 1) % 4 == 0) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public BytePatternParamModifyListener(VPresentationModel data) {
        this.data = data;
    }

    public VPresentationModel getData() {
        return this.data;
    }

    public void modifyText(@Nullable ModifyEvent event) {
        VScriptConfig scriptConfig;
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String newPatternStr = text.getText().trim();
        Pattern p = Pattern.compile(PATTERN_REGEX, 8);
        Matcher m = p.matcher(newPatternStr);
        VScriptParamValue model = (VScriptParamValue)text.getData("qcs.validation.ddr.model");
        VScenarioPresentation selectedScenario = this.data.getSelectedScenario();
        ValidationPresentationModel validation = this.data.getValidationModel();
        if (selectedScenario != null && validation != null && model != null && (scriptConfig = selectedScenario.getSelectedScriptConfig()) != null) {
            String paramName = model.getParam().getName();
            String beautifulBytePattern = BytePatternParamModifyListener.beautifyBytePattern(newPatternStr, false);
            model.setValue(beautifulBytePattern);
            boolean validPattern = this.data.validatePattern();
            if (m.find() && m.group().equals(newPatternStr) && validPattern && this.checkCustomPatterLength(newPatternStr)) {
                text.setBackground(null);
                validation.removeInvalidScriptConfig(scriptConfig, paramName);
            } else {
                text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                validation.addInvalidScriptConfig(scriptConfig, paramName);
            }
            this.data.validateSelectedScriptConfig();
        }
    }

    public boolean checkCustomPatterLength(String pattern) {
        String customPatterLength;
        VModel vModel = ValidationContext.getInstance().getData().getModel();
        if (vModel != null && (customPatterLength = vModel.getCustomOption("custom_pattern_length")) != null) {
            String[] tokenValues = pattern.replace("\n", "").replace(" ", "").split(",");
            return tokenValues.length <= Integer.parseInt(customPatterLength);
        }
        return true;
    }
}

