/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.TestResult;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessOutputHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemInstance;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemLauncher;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessDiscovery;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.LoggingUtils;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SerialRunAction
extends RunAction {
    private StringBuilder outResult = new StringBuilder();

    @Override
    public boolean runRequest(RunScriptRequest runScriptRequest, String logLevel) throws ResourceNotFoundException {
        VParamVariation runningCell;
        ValidationPresentationModel validationModel;
        StringBuilder runScriptCommand = new StringBuilder();
        Path pythonPath = new Path(System.getProperty("user.dir"));
        if ((pythonPath = pythonPath.append(System.getProperty("python.dir"))) == null) {
            LOGGER.log(Level.SEVERE, Messages.PropertyNotFound_0, "python.dir");
            return false;
        }
        if (!new File(pythonPath.toOSString()).exists()) {
            LOGGER.log(Level.SEVERE, Messages.PythonDirecoryNotFound_0, pythonPath.toOSString());
            return false;
        }
        IPath pythonExePath = null;
        if (OSDetect.isWindows()) {
            runScriptCommand.append("prompt test-prefix : " + System.lineSeparator());
            pythonExePath = pythonPath.append("python");
        } else {
            runScriptCommand.append(String.format("PS1 = \"%s\"%s", "test-prefix : ", System.lineSeparator()));
            pythonExePath = pythonPath.append("bin/python");
        }
        VModel vModel = VModel.newInstance(ValidationContext.getInstance(), Activator.getDefault().getConfigManager());
        if (vModel == null) {
            LOGGER.log(Level.SEVERE, Messages.PropertyNotFound_0, "mainScript in custom_config.xml");
            return false;
        }
        String scriptPath = null;
        String scriptName = vModel.getCustomOption("mainScript");
        if (scriptName != null) {
            scriptPath = pythonPath.append(scriptName).toOSString();
        }
        if (scriptPath == null) {
            runScriptCommand.append(("\"" + pythonExePath + "\"" + " " + "-E " + "\"" + Activator.getDefault().getConfigManager().getScriptsFolder() + File.separator + "s.py" + "\"").replaceAll("\\\\", "/"));
        } else {
            runScriptCommand.append(String.valueOf(("\"" + pythonExePath + "\"").replaceAll("\\\\", "/")) + " " + ("\"" + scriptPath + "\"").replaceAll("\\\\", "/"));
            runScriptCommand.append(" -t \"runtest\"");
            runScriptCommand.append(" -d " + ("\"" + Activator.getDefault().getConfigManager().getMainDir() + "\"").replaceAll("\\\\", "/"));
        }
        scriptPath = vModel.getCustomOption("filterPhyLog");
        if (scriptPath != null && Boolean.parseBoolean(scriptPath) && this.model != null && (validationModel = this.model.getValidationModel()) != null && (runningCell = validationModel.getRunningCell()) != null) {
            IScenarioElement vScenario;
            String phyLogFilePath = TestResultsLogger.getPhyTrainingLogFilePath(runningCell);
            runScriptCommand.append(" -p " + ("\"" + phyLogFilePath + "\"").replaceAll("\\\\", "/"));
            VTable table = runningCell.getParent();
            IScenarioElement scenario = table.getParent();
            if (scenario != null && (vScenario = scenario.getParent()) instanceof VScenario) {
                VScenario validationScenario = (VScenario)vScenario;
                boolean useImageEye = false;
                String useImageEyeOption = vModel.getCustomOption("useImageEye");
                if (useImageEyeOption != null) {
                    useImageEye = Boolean.parseBoolean(useImageEyeOption);
                }
                if (validationScenario.isCAEye() || validationScenario.isDiagsEye() && useImageEye) {
                    String figureFilePath = ("\"" + TestResultsLogger.getFigureLogFilePath(runningCell) + "\"").replaceAll("\\\\", "/");
                    runScriptCommand.append(" -i " + figureFilePath);
                }
                if (validationScenario.isVREFTest()) {
                    String vrefFilePath = ("\"" + TestResultsLogger.getVrefLogFilePath(runningCell) + "\"").replaceAll("\\\\", "/");
                    runScriptCommand.append(" -v " + vrefFilePath);
                }
            }
        }
        runScriptCommand.append(" -l " + logLevel);
        RunScriptRequest.ScriptFile[] scriptFileArray = runScriptRequest.files;
        int n = runScriptRequest.files.length;
        int n2 = 0;
        while (n2 < n) {
            RunScriptRequest.ScriptFile file = scriptFileArray[n2];
            runScriptCommand.append(" \"" + (String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + file.name + "\"").replaceAll("\\\\", "/"));
            ++n2;
        }
        runScriptCommand.append(System.lineSeparator());
        this.sysInstance.sendCommands(runScriptCommand.toString());
        return true;
    }

    private static String extractTestSummary(String logResults) {
        String appStateStr = "'app_state': \\d+";
        Pattern appStatePattern = Pattern.compile(appStateStr);
        String[] stringArray = logResults.split(UtilsText.platformEOL);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = appStatePattern.matcher(line);
            if (matcher.find()) {
                return line.substring(line.indexOf("{"));
            }
            ++n2;
        }
        return VLoggingUtils.extractErrorMessage(logResults);
    }

    @Override
    public TestResult[] getResults() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        ProcessOutputHandler handler = this.sysInstance.getOutputHandler();
        if (handler != null) {
            int delimiterIndex = 0;
            while ((delimiterIndex = this.outResult.indexOf("****DONE****")) > 0) {
                String resultTxt = this.outResult.substring(0, delimiterIndex + "****DONE****".length());
                if (resultTxt == null) continue;
                VLoggingUtils.ScriptResultType resultType = this.isTestPassed(resultTxt) ? VLoggingUtils.ScriptResultType.PASSED : VLoggingUtils.getFailureType(SerialRunAction.extractTestSummary(resultTxt));
                String shortTxt = this.createShortLog(resultType, resultTxt);
                results.add(new TestResult(resultTxt, shortTxt, false, resultType));
                this.outResult.delete(0, delimiterIndex + "****DONE****".length());
            }
            if (LoggingUtils.isPyException(this.outResult.toString()) || this.outResult.toString().lastIndexOf("test-prefix : ") > this.outResult.toString().lastIndexOf("python") && this.outResult.toString().lastIndexOf("python") > 0) {
                results.add(new TestResult(this.outResult.toString(), VLoggingUtils.extractErrorMessage(this.outResult.toString()), true, VLoggingUtils.ScriptResultType.TARGET_ERROR));
                this.outResult.delete(0, this.outResult.length());
                this.setFinished(true);
                this.completionReason = RunAction.CompletionReason.Error;
            }
        }
        return results.toArray(new TestResult[results.size()]);
    }

    @Override
    public synchronized String getOutput() {
        ProcessOutputHandler handler = this.sysInstance.getOutputHandler();
        String outString = "";
        if (handler != null) {
            outString = handler.getOutput();
            this.outResult.append(outString);
        }
        return outString;
    }

    @Override
    protected TASystemInstance aquireSysInstance() throws IOException, ResourceNotFoundException {
        TASystemDescriptor targetAccessDescriptor = TargetAccessDiscovery.getDefaultDescriptor(TargetAccessType.SERIAL);
        TASystem system = TargetAccessDiscovery.getTASystem(targetAccessDescriptor, TargetAccessDiscovery.getUsbExecPaths());
        return TASystemLauncher.getInstance().acquire(system, new HashMap<String, String>(), SerialRunAction.getPythonEnv());
    }

    private static Map<String, String> getPythonEnv() {
        IConfigProvider configController;
        if (SwToolsProduct.isImxProduct() && (configController = ValidationContext.getInstance().getConfigController()) != null && configController.isEnabled()) {
            return configController.getPythonEnv();
        }
        return new HashMap<String, String>();
    }
}

