/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialGdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.actions.TestResult;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessOutputHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemInstance;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemLauncher;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessDiscovery;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.utils.LoggingUtils;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class SerialPyRunAction
extends RunAction {
    private StringBuilder outResult = new StringBuilder();
    protected static final Logger LOGGER = LogManager.getLogger(SerialPyRunAction.class);
    protected String @Nullable [] processesPID;

    @Override
    protected TASystemInstance aquireSysInstance() throws IOException, ResourceNotFoundException {
        TASystemDescriptor targetAccessDescriptor = TargetAccessDiscovery.getDefaultDescriptor(TargetAccessType.SERIAL);
        TASystem system = TargetAccessDiscovery.getTASystem(targetAccessDescriptor, TargetAccessDiscovery.getUsbExecPaths());
        return TASystemLauncher.getInstance().acquire(system, new HashMap<String, String>(), SerialGdbPyRunAction.getPythonEnv(targetAccessDescriptor));
    }

    public String getExecName() {
        String pythonBinPath;
        StringBuilder execName = new StringBuilder();
        TASystemDescriptor targetAccessDescriptor = TargetAccessDiscovery.getDefaultDescriptor(TargetAccessType.SERIAL);
        if (OSDetect.isUnix()) {
            execName.append("exec ");
        }
        if ((pythonBinPath = SerialGdbPyRunAction.getPythonBinPath(targetAccessDescriptor)).equals("")) {
            execName.append("python ");
        } else {
            execName.append(pythonBinPath).append(" ");
        }
        return execName.toString();
    }

    @Override
    public boolean runRequest(RunScriptRequest runScriptRequest, String logLevel) throws ResourceNotFoundException {
        String installScriptCmd = String.valueOf(this.getExecName()) + Activator.getDefault().getConfigManager().getScriptsFolder() + File.separator + "s.py" + " ";
        StringBuilder runScriptCommand = new StringBuilder();
        runScriptCommand.append(installScriptCmd);
        runScriptCommand.append(" ");
        runScriptCommand.append("-l " + logLevel);
        ValidationContext vContext = ValidationContext.getInstance();
        IConfigProvider configProvider = vContext.getConfigController();
        if (configProvider != null && !configProvider.getComponentInfo().schemaVersionOlderThan("9.0")) {
            runScriptCommand.append(" ");
            runScriptCommand.append("-parentPID " + this.parentPID);
        }
        RunScriptRequest.ScriptFile[] scriptFileArray = runScriptRequest.files;
        int n = runScriptRequest.files.length;
        int n2 = 0;
        while (n2 < n) {
            RunScriptRequest.ScriptFile file = scriptFileArray[n2];
            runScriptCommand.append(" \"" + (String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + file.name + "\"").replaceAll("\\\\", "/"));
            ++n2;
        }
        this.sysInstance.sendCommands(runScriptCommand.toString());
        return true;
    }

    @Override
    public TestResult[] getResults() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        int delimiterIndex = 0;
        while ((delimiterIndex = this.outResult.indexOf("****DONE****")) > 0) {
            String resultTxt = this.outResult.substring(0, delimiterIndex + "****DONE****".length());
            if (resultTxt == null) continue;
            VLoggingUtils.ScriptResultType resultType = this.isTestPassed(resultTxt) ? VLoggingUtils.ScriptResultType.PASSED : VLoggingUtils.getFailureType(VLoggingUtils.extractErrorMessage(resultTxt));
            String shortTxt = this.createShortLog(resultType, resultTxt);
            results.add(new TestResult(resultTxt, shortTxt, false, resultType));
            this.outResult.delete(0, delimiterIndex + "****DONE****".length());
        }
        if (LoggingUtils.isPyException(this.outResult.toString()) || LoggingUtils.isPhyinitError(this.outResult.toString())) {
            results.add(new TestResult(this.outResult.toString(), VLoggingUtils.extractErrorMessage(this.outResult.toString()), true, VLoggingUtils.ScriptResultType.TARGET_ERROR));
            this.outResult.delete(0, this.outResult.length());
            this.setFinished(true);
        }
        return results.toArray(new TestResult[results.size()]);
    }

    @Override
    public synchronized String getOutput() {
        ProcessOutputHandler handler = this.sysInstance.getOutputHandler();
        if (handler != null) {
            String output = handler.getOutput();
            this.outResult.append(output);
            return output;
        }
        return "";
    }

    @Override
    public void terminate() {
        try {
            try {
                this.processesPID = this.getPidsFromLogFile();
                this.sysInstance.terminate(this.processesPID);
            }
            catch (ResourceNotFoundException e) {
                LOGGER.severe(e.getMessage());
                this.cleanupPidLogFile();
            }
        }
        finally {
            this.cleanupPidLogFile();
        }
    }

    @Override
    public synchronized void cancel() {
        try {
            try {
                this.processesPID = this.getPidsFromLogFile();
                this.sysInstance.terminate(this.processesPID);
            }
            catch (ResourceNotFoundException e) {
                LOGGER.severe(e.getMessage());
                this.cleanupPidLogFile();
            }
        }
        finally {
            this.cleanupPidLogFile();
        }
    }
}

