/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.connections.actions.TestResult;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemInstance;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.utils.FileUtils;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RunAction {
    protected static final Logger LOGGER = LogManager.getLogger(RunAction.class);
    protected static long SERVICE_INTERACTION_TIMEOUT = 90000L;
    protected static String jsonTxt = "";
    public static final int SLEEP_MS = 200;
    public static final int TIMEOUT_MS = 12000;
    protected static final int RESULT_QUEUE_SIZE = 100;
    public static final long QUICK_REQUEST_TIMEOUT = 5000L;
    protected String parentPID;
    protected static final String PID_FILENAME_SUFFIX = "child_pid.log";
    private String output = "";
    private AtomicBoolean responseReceived = new AtomicBoolean(false);
    private boolean actionCanceled = false;
    private long startTime;
    protected boolean actionFinished = false;
    protected TASystemInstance sysInstance;
    protected CompletionReason completionReason = CompletionReason.Error;
    private boolean connected = false;
    @Nullable
    protected VPresentationModel model;

    public static void trace(String message) {
        LOGGER.info(message);
    }

    public RunAction() throws IOException, ResourceNotFoundException {
        this.startTime = System.currentTimeMillis();
        this.sysInstance = this.aquireSysInstance();
        if (!this.sysInstance.isRunning()) {
            throw new ResourceNotFoundException(Messages.ConnectionServerDown_1);
        }
        this.connected = true;
        String[] tokens = ManagementFactory.getRuntimeMXBean().getName().split("@");
        this.parentPID = tokens.length > 0 ? tokens[0] : "";
    }

    protected abstract TASystemInstance aquireSysInstance() throws IOException, ResourceNotFoundException;

    public abstract boolean runRequest(RunScriptRequest var1, String var2) throws ResourceNotFoundException;

    public boolean actionFinished() {
        return this.actionFinished || this.actionCanceled;
    }

    public synchronized void cancel() {
        this.actionCanceled = true;
        try {
            this.sysInstance.terminate(null);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.info(e.getMessage());
        }
    }

    public Object getCompletionReason() {
        return this.completionReason;
    }

    public synchronized long getLastResponseElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public synchronized String getOutput() {
        return this.output;
    }

    public abstract TestResult[] getResults();

    public ExecStatus getStatus() {
        throw new UnsupportedOperationException(Messages.RunScriptAction_0);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isSuccess() {
        return false;
    }

    public boolean runScriptResponseReceived() {
        return this.responseReceived.get();
    }

    public void setFinished(boolean finished) {
        this.actionFinished = finished;
    }

    public void waitActionFinished() {
        block1: {
            TestResult[] results;
            long startMs = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() - startMs < 12000L) continue;
                this.completionReason = CompletionReason.TimedOut;
                break block1;
            } while ((results = this.getResults()).length <= 0);
            this.completionReason = CompletionReason.Interrupted;
        }
    }

    public void terminate() {
        try {
            this.sysInstance.terminate(null);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.info(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isTestPassed(String logResults) {
        boolean app_state_found = false;
        try {
            Pattern appStatePattern = Pattern.compile("'app_state': \\d+");
            jsonTxt = "";
            String[] stringArray = logResults.split(UtilsText.platformEOL);
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return app_state_found;
                }
                String line = stringArray[n2];
                Matcher matcher = appStatePattern.matcher(line);
                if (matcher.find()) {
                    JSONObject jsonObject = new JSONObject(line.substring(line.indexOf("{")));
                    jsonTxt = jsonObject.toString();
                    if (jsonObject.has("phy_error_state") && jsonObject.getString("phy_error_state") != null) {
                        return false;
                    }
                    if (219023885L == (long)jsonObject.getInt("app_state")) {
                        return false;
                    }
                    if (jsonObject.has("records")) {
                        JSONArray records = jsonObject.getJSONArray("records");
                        int recIdx = 0;
                        while (recIdx < records.length()) {
                            if (records.getJSONObject(recIdx).getInt("state") == 0) {
                                return false;
                            }
                            ++recIdx;
                        }
                    }
                    app_state_found = true;
                }
                ++n2;
            }
        }
        catch (JSONException e) {
            LOGGER.info(e.getLocalizedMessage());
            return false;
        }
    }

    protected String createShortLog(VLoggingUtils.ScriptResultType resultType, String logResults) {
        StringBuilder result = new StringBuilder();
        if (resultType == VLoggingUtils.ScriptResultType.PASSED) {
            result.append(Messages.RunAction_TestPass);
            result.append("\r\n");
        } else {
            result.append(Messages.RunAction_TestFail);
            result.append("\r\n");
            if (!jsonTxt.isEmpty()) {
                try {
                    JSONObject jsonObject = new JSONObject(jsonTxt);
                    JSONObject record = jsonObject.getJSONArray("records").getJSONObject(0);
                    JSONArray recordData = record.getJSONArray("data");
                    TestFailType errCode = TestFailType.fromValue(recordData.getInt(0));
                    result.append(String.valueOf(errCode.errMessage) + "\r\n");
                    result.append(String.format("%s: 0x%08x%n", Messages.RunAction_AddressStr, recordData.getLong(1)));
                    result.append(String.valueOf(Messages.RunAction_TestDataLabel) + ": ");
                    result.append(record.getJSONArray("data"));
                }
                catch (JSONException e) {
                    LOGGER.info(e.getMessage());
                }
            } else {
                result.append(VLoggingUtils.extractErrorMessage(logResults));
            }
        }
        return result.toString();
    }

    public void setModel(VPresentationModel data) {
        this.model = data;
    }

    protected String[] getPidsFromLogFile() {
        String filePath = String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + this.parentPID + "_" + PID_FILENAME_SUFFIX;
        if (new File(filePath).exists()) {
            String processesLog = FileUtils.readTextFile(filePath);
            String[] fileLines = processesLog.split(System.lineSeparator());
            String[] pids = new String[fileLines.length];
            int i = 0;
            while (i <= fileLines.length - 1) {
                String[] splitter = fileLines[i].split(": ");
                if (splitter.length > 1) {
                    pids[i] = splitter[1];
                }
                ++i;
            }
            return pids;
        }
        return new String[0];
    }

    protected void cleanupPidLogFile() {
        FileUtils.deleteDirectory(String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + this.parentPID + "_" + PID_FILENAME_SUFFIX);
    }

    public static enum CompletionReason {
        CompletedNormally,
        Error,
        TimedOut,
        Disconnected,
        Interrupted;

    }

    public static enum ExecStatus {
        RUNNING,
        TERMINATED,
        TIMED_OUT,
        CANCELLED,
        INTERNAL_ERROR,
        IDLE;

    }

    static enum TestFailType {
        NO_FAIL(0, Messages.RunAction_NoFailMsg),
        DMA_TRANSFER_FAIL(1, Messages.RunAction_DMAErrMsg),
        DATA_MISCOMPARE(2, Messages.RunAction_DatMisscompareMsg),
        DDR_ERR_DETECT(3, Messages.RunAction_DDRErrMsg);

        private int errCode;
        String errMessage;

        private TestFailType(int errCode, String errMessage) {
            this.errMessage = errMessage;
            this.errCode = errCode;
        }

        protected static TestFailType fromValue(int errCode) {
            TestFailType[] testFailTypeArray = TestFailType.values();
            int n = testFailTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestFailType value = testFailTypeArray[n2];
                if (value.errCode == errCode) {
                    return value;
                }
                ++n2;
            }
            return NO_FAIL;
        }
    }
}

