/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.ConstraintsRefs;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ExtensionTypes;
import com.nxp.swtools.bootimage.settings.ImageAddress;
import com.nxp.swtools.bootimage.settings.ImageHeader;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.SignedImageSetting;
import com.nxp.swtools.bootimage.settings.ValueLockedSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.ValidatedSimpleBooleanProperty;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javafx.beans.property.SimpleIntegerProperty;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="input_file", strict=false)
public class InputFileSetting
extends ABaseCustomComponentSetting
implements IProblemSource {
    @Attribute(name="byte_order", required=false)
    private String byteOrder = "be";
    @Attribute(name="show_content", required=false)
    private String showContent = "true";
    @Element(name="header", required=false)
    private ImageHeader header;
    @Element(name="constraints_refs", required=false)
    @Nullable
    private @Element(name="constraints_refs", required=false) @Nullable ConstraintsRefs constraintsRefs;
    @Element(name="extension_types", required=false)
    @Nullable
    private @Element(name="extension_types", required=false) @Nullable ExtensionTypes extensionTypes;
    @Element(name="image_addr", required=false)
    @Nullable
    private @Element(name="image_addr", required=false) @Nullable ImageAddress imageAddr;
    @Nullable
    private ImageSegment imageSegment;
    private String currentValue;
    private SimpleIntegerProperty sizeProperty;
    @Element(name="locked", required=false)
    @Nullable
    private @Element(name="locked", required=false) @Nullable ValueLockedSetting locked;
    @Element(name="sign_image", required=false)
    @Nullable
    private @Element(name="sign_image", required=false) @Nullable SignedImageSetting signImage;
    @Attribute(name="reserved_space", required=false)
    private String reservedSpace;
    @Attribute(name="include_reserved_space", required=false)
    private boolean includeReservedSpace;
    protected ValidatedSimpleBooleanProperty signImageProperty = new ValidatedSimpleBooleanProperty();
    private static final Logger LOGGER = LogManager.getLogger(InputFileSetting.class);

    public InputFileSetting(String id, String label, @Nullable Description description, String offset, String size, String initValue, String byteOrder, String showContent, ImageHeader header, @Nullable ConstraintsRefs constraintsRefs, SimpleIntegerProperty sizeProperty, @Nullable ImageSegment imageSegment, String options, @Nullable MessagesSetting messages, ImageAddress imageAddr, @Nullable ValueLockedSetting locked, String reservedSpace) {
        super(id, label, description, offset, size, initValue, -1L, options, messages, null, "");
        this.sizeProperty = sizeProperty;
        this.header = header;
        this.constraintsRefs = constraintsRefs;
        this.imageSegment = imageSegment;
        this.byteOrder = byteOrder;
        this.showContent = showContent;
        this.currentValue = initValue;
        this.imageAddr = imageAddr;
        this.locked = locked;
        this.reservedSpace = reservedSpace;
        this.includeReservedSpace = false;
    }

    public InputFileSetting() {
        super("", "", null, "", "", "N/A", -1L, "", null, null, "");
        this.showContent = "true";
        this.header = new ImageHeader();
        this.constraintsRefs = null;
        this.imageSegment = null;
        this.currentValue = "N/A";
        this.sizeProperty = new SimpleIntegerProperty();
        this.imageAddr = null;
        this.locked = null;
        this.reservedSpace = "";
        this.includeReservedSpace = false;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public ImageHeader getImageHeader() {
        return this.header;
    }

    public SimpleIntegerProperty getSizeProperty() {
        return this.sizeProperty;
    }

    public void setSize(int size) {
        this.sizeProperty.set(size);
    }

    public @Nullable ConstraintsRefs getConstraintsRefs() {
        return this.constraintsRefs;
    }

    public @Nullable ImageSegment getImageSegment() {
        return this.imageSegment;
    }

    public void setImageSegment(ImageSegment imageSegment) {
        this.imageSegment = imageSegment;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public ValidatedSimpleBooleanProperty getSignImageProperty() {
        return this.signImageProperty;
    }

    public void setSignImage(boolean signImage) {
        this.signImageProperty.set(signImage);
    }

    public @Nullable SignedImageSetting getSignImage() {
        return this.signImage;
    }

    public boolean showFileContent() {
        return this.showContent.equals("true");
    }

    public @Nullable ExtensionTypes getExtensionTypes() {
        return this.extensionTypes;
    }

    public @Nullable ImageAddress getImageAddr() {
        return this.imageAddr;
    }

    public @Nullable ValueLockedSetting getLockedSetting() {
        return this.locked;
    }

    public boolean isValueLocked() {
        if (this.locked != null) {
            return this.locked.getInitialState();
        }
        return false;
    }

    public String getReservedSpace() {
        return this.reservedSpace;
    }

    public int getReservedSpaceValue() {
        int reservedSpaceVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.reservedSpace);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return reservedSpaceVal;
    }

    public boolean includeReservedSpace() {
        return this.includeReservedSpace;
    }
}

