/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="tag", strict=false)
public class ImageTagSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(ImageTagSetting.class);
    @Attribute(name="size")
    private String size;
    @Attribute(name="offset")
    private String offset;
    @Attribute(name="possible_values", required=false)
    private String possibleValues;

    public ImageTagSetting(String id, String label, @Nullable Description description, String size, String value, String possibleValues, String offset, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
        this.possibleValues = possibleValues;
        this.size = size;
        this.offset = offset;
    }

    public ImageTagSetting() {
        this.possibleValues = "";
        this.size = "";
        this.offset = "";
    }

    public int getSizeValue() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return sizeVal;
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetVal = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        } else if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        }
        return offsetVal;
    }

    public long getTagValue() {
        long tagValue = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
            tagValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getInitValue());
        } else if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
            tagValue = NumberFormatValidator.getLongFromStringDecimal((String)this.getInitValue());
        }
        return tagValue;
    }

    public List<Long> getPossibleTagValues() {
        List<String> values = this.parsePossibleValues();
        if (values.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> tagValues = new ArrayList<Long>();
        for (String value : values) {
            Long tagValue = null;
            if (NumberFormatValidator.isValidXmlHexFormat((String)value)) {
                tagValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)value);
            } else if (NumberFormatValidator.isValidDecimal((String)value)) {
                tagValue = NumberFormatValidator.getLongFromStringDecimal((String)value);
            } else {
                LOGGER.log(Level.SEVERE, "Parsing of the tag value failed");
                break;
            }
            tagValues.add(tagValue);
        }
        return tagValues;
    }

    private List<String> parsePossibleValues() {
        String[] tempValuesBuffer;
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = tempValuesBuffer = this.possibleValues.split("\\|");
        int n = tempValuesBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            String tempStr = stringArray[n2];
            if (!tempStr.equals("")) {
                values.add(tempStr);
            }
            ++n2;
        }
        return values;
    }

    public byte[] getBufferToWrite() {
        ByteBuffer bufferToWrite = ByteBuffer.allocate(this.getSizeValue());
        ByteBuffer tagBuffer = ByteBuffer.allocate(8).putLong(this.getTagValue());
        if (this.getSizeValue() > 8) {
            int i = 0;
            while (i < 8) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, tagBuffer.get(7 - i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getSizeValue()) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, tagBuffer.get(7 - i));
                ++i;
            }
        }
        return bufferToWrite.array();
    }
}

