/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service;

import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.HardwareLaunchConfigurationService;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.LaunchConfigurationAttributesMapper;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.LaunchConfigurationHardwareDataMapper;
import com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service.internal.ServiceErrorMessages;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class HardwareLaunchConfigurationActivator
extends RcpBundle {
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.runtime.hardware.launch.configuration.service";
    private static HardwareLaunchConfigurationActivator INSTANCE;
    private static BundleContext context;
    private static ServiceTracker<HardwareLaunchConfigurationService, HardwareLaunchConfigurationService> tracker;
    private static HardwareLaunchConfigurationService service;

    public static HardwareLaunchConfigurationActivator getInstance() {
        return INSTANCE;
    }

    public HardwareLaunchConfigurationService getService() {
        return service;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        INSTANCE = this;
        this.initService();
    }

    public void initService() {
        String serviceClassName = HardwareLaunchConfigurationService.class.getName();
        tracker = new ServiceTracker(context, serviceClassName, null);
        tracker.open();
        service = (HardwareLaunchConfigurationService)tracker.getService();
        if (service != null) {
            this.registerLCAttributes();
            this.registerHWModelAttributes();
        } else {
            this.logError(NLS.bind((String)ServiceErrorMessages.Service_error_initialisation, (Object)HardwareLaunchConfigurationService.class.getName()));
        }
    }

    private void registerLCAttributes() {
        String ns = HardwareLaunchConfigurationActivator.getInstance().getBundleId();
        String ep = "launchConfigurationAttributes";
        String attributes = "attributeNames";
        List lcElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)attributes, (String[])new String[]{"lcType"});
        for (IConfigurationElement element : lcElements) {
            HashMap<String, String> hwData = new HashMap<String, String>();
            hwData.put("lcType", element.getAttribute("lcType"));
            String attr = element.getAttribute("lcTargetDeviceCoreIdAttribute");
            if (attr != null) {
                hwData.put("lcTargetDeviceCoreIdAttribute", attr);
            } else {
                hwData.put("lcTargetCoreAttribute", element.getAttribute("lcTargetCoreAttribute"));
                hwData.put("lcTargetCoreAttributeType", element.getAttribute("lcTargetCoreAttributeType"));
                hwData.put("lcTargetDeviceAttribute", element.getAttribute("lcTargetDeviceAttribute"));
                hwData.put("lcTargetDeviceAttributeType", element.getAttribute("lcTargetDeviceAttributeType"));
            }
            service.addLaunchConfigurationMapper(new LaunchConfigurationAttributesMapper(hwData));
        }
    }

    private void registerHWModelAttributes() {
        String ns = HardwareLaunchConfigurationActivator.getInstance().getBundleId();
        String ep = "launchConfigurationHardwareModel";
        String model = "hardwareModel";
        String lcType = "lcType";
        String deviceId = "lcTargetDeviceId";
        String deviceCoreId = "s32dsDeviceCoreId";
        List boardElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)model, (String[])new String[]{lcType, deviceId, deviceCoreId});
        for (IConfigurationElement element : boardElements) {
            HashMap<String, String> hwData = new HashMap<String, String>();
            hwData.put("lcType", element.getAttribute(lcType));
            hwData.put("lcTargetCoreId", element.getAttribute("lcTargetCoreId"));
            hwData.put("lcTargetDeviceId", element.getAttribute(deviceId));
            hwData.put("s32dsDeviceCoreId", element.getAttribute(deviceCoreId));
            String defaultDesc = element.getAttribute("default");
            if (defaultDesc != null) {
                hwData.put("default", defaultDesc);
            }
            service.addLaunchConfigurationHardwareDataMapper(new LaunchConfigurationHardwareDataMapper(hwData));
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        INSTANCE = null;
        context = null;
        if (tracker != null) {
            tracker.close();
            service = null;
        }
    }

    public String getBundleId() {
        return BUNDLE_ID;
    }
}

