/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ProtocolDescriptors {
    public static ProtocolRegistry getProtocolRegistry() {
        ProtocolRegistry protocolRegistry = HardwareRegistryCoreActivator.getDefault().getProtocolRegistry();
        return protocolRegistry;
    }

    public static List<ProtocolDescriptor> getProtocolDescriptors() {
        ProtocolRegistry protocolRegistry = HardwareRegistryCoreActivator.getDefault().getProtocolRegistry();
        return protocolRegistry.getProtocolDescriptors();
    }

    public static ProtocolDescriptor getProtocolDescriptor(String familyId) {
        ProtocolRegistry protocolRegistry = HardwareRegistryCoreActivator.getDefault().getProtocolRegistry();
        return protocolRegistry.getProtocolDescriptor(familyId);
    }

    public static List<FlashDescriptor> getFlashDescriptors(String protocolId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FlashRegistry flashRegistry = activator.getFlashRegistry();
        List flashProtocolDescriptors = flashRegistry.getFlashProtocolDescriptorsByProtocolId(protocolId);
        LinkedHashSet<String> flashIds = new LinkedHashSet<String>();
        for (FlashProtocolDescriptor flashProtocolDescriptor : flashProtocolDescriptors) {
            String flashId = flashProtocolDescriptor.getFlashId();
            flashIds.add(flashId);
        }
        ArrayList<FlashDescriptor> result = new ArrayList<FlashDescriptor>();
        for (String flashId : flashIds) {
            FlashDescriptor flashDescriptor = flashRegistry.getFlashDescriptor(flashId);
            if (flashDescriptor == null) continue;
            result.add(flashDescriptor);
        }
        return result;
    }

    public static String getProtocolLabel(ProtocolDescriptor protocolDescriptor) {
        if (protocolDescriptor == null) {
            return null;
        }
        return protocolDescriptor.getName();
    }
}

