/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.AbstractResourceTagsConverter;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

class SingleResourceTagsConverter
extends AbstractResourceTagsConverter {
    protected SingleResourceTagsConverter(Element resourceElement, String sdkBasePath) {
        super(resourceElement, sdkBasePath);
    }

    @Override
    protected Collection<Element> convertInternally() {
        ResourceSdkKind baseKind = ResourceSdkKind.of((String)this.resourceElement.getNodeName()).getBaseKind();
        if (baseKind.isFolderKind()) {
            this.resourceElement.setAttribute("mask", "*");
            return this.createResourceElements();
        }
        Element element = this.resourceElement.getOwnerDocument().createElement(baseKind.getXmlElementName());
        this.getAttributes(this.resourceElement).entrySet().forEach(e -> element.setAttribute((String)e.getKey(), (String)e.getValue()));
        return Collections.singletonList(element);
    }

    @Override
    protected void adjustFileElementCopyAttributes(Element fileElement, Element folderElement) {
        fileElement.setAttribute("copy", Boolean.TRUE.toString());
        String folderCopyToPath = SingleResourceTagsConverter.getResourceCopyPath(folderElement);
        String filePathParent = Paths.get(SingleResourceTagsConverter.getResourcePath(fileElement), new String[0]).getParent().toString();
        fileElement.setAttribute("copyToProjectPath", Paths.get(folderCopyToPath, filePathParent).toString());
    }

    @Override
    protected List<Path> collectFileResourcesPathsSameLevel(Path fromPath, boolean isFileAction) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> fileListStream = Files.list(fromPath);){
            return fileListStream.filter(path -> path.toFile().isFile()).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected AbstractResourceTagsConverter.FileVisitor getFileVisitor(Path fromPath, PathMatcher pathMatcher) {
        return new AbstractResourceTagsConverter.FileVisitor(fromPath, pathMatcher){

            @Override
            protected FileVisitResult handleVisitFile(Path startPath, Path path, PathMatcher pathMatcher, Collection<Path> resourcesPaths) {
                resourcesPaths.add(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            protected FileVisitResult handlePreVisitDirectory(Path startPath, Path path, PathMatcher pathMatcher, Collection<Path> resourcesPaths) {
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

