/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkAction;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.condition.Condition;
import com.nxp.s32ds.cle.cdt.sdk.core.condition.ConditionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.MessageAction;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractSdkAction
implements SdkAction {
    protected String sdkId;
    protected String toolChainId;
    protected Set<SdkAction> successorActions = new LinkedHashSet<SdkAction>();
    private String conditionRef;

    protected AbstractSdkAction() {
    }

    protected AbstractSdkAction(Element element) {
        this();
        this.initialize(element);
    }

    public IStatus postExecute(IProject project, IConfiguration configuration) {
        SdkAction successorAction;
        if (!this.successorActions.isEmpty() && (successorAction = this.successorActions.iterator().next()) instanceof MessageAction) {
            return ((MessageAction)successorAction).execute(project, configuration);
        }
        return Status.CANCEL_STATUS;
    }

    public void convertToXml(Document document, Element actionElement) {
        SdkAction successorAction;
        if (!this.successorActions.isEmpty() && (successorAction = this.successorActions.iterator().next()) instanceof MessageAction) {
            ((MessageAction)successorAction).convertToXml(document, actionElement);
        }
    }

    protected void convertAttributesToXml(Document document, Element element) {
        if (this.conditionRef != null && !this.conditionRef.isEmpty()) {
            element.setAttribute("conditionRef", this.conditionRef);
        }
    }

    public boolean isApplicable(IConfiguration configuration) {
        Condition condition = ConditionsHolder.INSTANCE.getCondition(this.sdkId, this.toolChainId, this.conditionRef);
        return condition == null || condition.check((Object)configuration);
    }

    protected UpdateOperation getUpdateOperation(SdkActionOperations actionOperations) {
        switch (actionOperations) {
            case PROJECT_FOLDER_CREATE: 
            case OPTION_VALUE_ADD: 
            case LAUNCH_VALUE_ADD: {
                return UpdateOperation.ADD;
            }
            case PROJECT_FOLDER_CLEANUP: 
            case OPTION_VALUE_CLEANUP: 
            case LAUNCH_VALUE_CLEANUP: 
            case BUILDER_ATTRIBUTE_VALUE_CLEANUP: {
                return UpdateOperation.CLEAN_EXISTING;
            }
            case PROJECT_FOLDER_REMOVE: 
            case OPTION_VALUE_REMOVE: 
            case LAUNCH_VALUE_REMOVE: {
                return UpdateOperation.REMOVE;
            }
            case OPTION_VALUE_SET: 
            case LAUNCH_VALUE_SET: 
            case BUILDER_ATTRIBUTE_VALUE_SET: {
                return UpdateOperation.REPLACE_EXISTING;
            }
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.successorActions == null ? 0 : this.successorActions.hashCode());
        result = 31 * result + (this.conditionRef == null ? 0 : this.conditionRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractSdkAction)) {
            return false;
        }
        AbstractSdkAction other = (AbstractSdkAction)obj;
        if (this.successorActions == null ? other.successorActions != null : !this.successorActions.equals(other.successorActions)) {
            return false;
        }
        return !(this.conditionRef == null ? other.conditionRef != null : !this.conditionRef.equals(other.conditionRef));
    }

    private void initialize(Element element) {
        SdkActionsHolder sdkActionsHolder = Objects.requireNonNull((SdkActionsHolder)element.getUserData("action_holder"));
        this.sdkId = sdkActionsHolder.getSdkId();
        this.toolChainId = sdkActionsHolder.getToolChainId();
        NodeList messageElements = element.getElementsByTagName("message");
        if (messageElements.getLength() == 1) {
            this.successorActions.add(new MessageAction((Element)messageElements.item(0)));
        }
        this.conditionRef = element.getAttribute("conditionRef");
    }
}

