/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class SdksValidator {
    public Map<String, IStatus> validate(Collection<SdkDescriptor> sdksList) {
        HashMap<String, IStatus> invalidSdks = new HashMap<String, IStatus>();
        SdkValidator sdkValidator = new SdkValidator();
        for (SdkDescriptor sdkDescriptor : sdksList) {
            IStatus validationStatus = sdkValidator.validate(sdkDescriptor);
            if (validationStatus.isOK()) continue;
            MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus(4, NLS.bind((String)"SDK {0} v {1} is not valid.", (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion()));
            resultStatus.merge(validationStatus);
            if (SdkType.INTERNAL == sdkDescriptor.getType()) {
                SdkCoreActivator.getInstance().log((IStatus)resultStatus);
            }
            invalidSdks.put(sdkDescriptor.getId(), (IStatus)resultStatus);
        }
        return invalidSdks;
    }
}

