/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ExternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.PersistentSdksLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdksValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeListener;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventParser;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerComponent;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPayload;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class SdksLoader
implements ComponentChangeListener {
    private boolean isSdksLoaded;
    private WorkspaceJob persistentSdksLoadingJob;

    public SdksLoader() {
        this.createPersistentSdksLoadingJob();
    }

    public void onComponentChange(ComponentChangeEvent event) {
        ComponentChangeEventParser parser = new ComponentChangeEventParser(event);
        String archetypeId = parser.getArchetype();
        if ("software_package_eventevent appeared".equals(archetypeId)) {
            this.isSdksLoaded = true;
            this.addSdks(event);
        }
        if ("software_package_loading_finished".equals(archetypeId) && !this.isSdksLoaded) {
            this.loadPersistentSdks();
        }
    }

    private void addSdks(ComponentChangeEvent event) {
        ArrayList<SoftwareManagerComponent> sdkComponents = new ArrayList<SoftwareManagerComponent>();
        Object payLoad = event.getParameters().get("payload");
        if (payLoad instanceof SoftwareManagerPayload) {
            SoftwareManagerPayload managerPayload = (SoftwareManagerPayload)payLoad;
            for (SoftwareManagerPackageDescriptor packageDescriptor : managerPayload.getCurrentSoftwareManagerDescriptors()) {
                packageDescriptor.getComponents().stream().filter(component -> "sdk".equals(component.getType())).forEach(sdkComponents::add);
            }
        }
        if (!sdkComponents.isEmpty()) {
            this.loadIntegrationSdks(sdkComponents);
        } else {
            this.loadPersistentSdks();
        }
    }

    private void loadIntegrationSdks(final List<SoftwareManagerComponent> sdkComponents) {
        WorkspaceJob sdkLoaderJob = new WorkspaceJob("Integration SDKs loading"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int workAmount = sdkComponents.size();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workAmount);
                for (SoftwareManagerComponent sdkComponent : sdkComponents) {
                    subMonitor.beginTask(sdkComponent.getName(), workAmount);
                    ExternalSdkLoader.loadSdkFromDescriptorFile(sdkComponent.getManifest(), false);
                    subMonitor.worked(1);
                }
                SdkAttachDataHelper.checkStatusOfAttachedSdks();
                subMonitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(SdksLoader.class);
            }
        };
        sdkLoaderJob.schedule();
        sdkLoaderJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent evt) {
                SdksLoader.this.loadPersistentSdks();
            }
        });
    }

    private void createPersistentSdksLoadingJob() {
        this.persistentSdksLoadingJob = new WorkspaceJob("Persistent SDKs loading"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                subMonitor.beginTask("Persistent SDKs loading", 100);
                new PersistentSdksLoader().loadSdks((IProgressMonitor)subMonitor);
                subMonitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(SdksLoader.class);
            }
        };
        this.persistentSdksLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            private RcpStatusHandler loadSdkStatusHandler = new RcpStatusHandler(){

                public Object handleStatus(IStatus status, Object source) throws CoreException {
                    if (!status.isOK() && status.isMultiStatus() && ((MultiStatus)status).getChildren().length > 0) {
                        StatusManager.getManager().handle(status, 2);
                    }
                    SdkCoreActivator.getInstance().log(status);
                    return source;
                }
            };

            public void done(IJobChangeEvent evt) {
                Map<String, IStatus> invalidSdks = new SdksValidator().validate(SdkDescriptors.getSdkDescriptors());
                for (Map.Entry<String, IStatus> e : invalidSdks.entrySet()) {
                    this.handleSdkValidationError(e.getValue());
                    SdkDescriptor invalidDescriptor = SdkDescriptors.getSdkDescriptor((String)e.getKey());
                    if (invalidDescriptor == null) continue;
                    String invalidSdkId = invalidDescriptor.getId();
                    SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)invalidSdkId);
                    SdkEnvironmentUtils.removeEnvironment(invalidSdkId);
                }
            }

            private void handleSdkValidationError(IStatus validationStatus) {
                try {
                    this.loadSdkStatusHandler.handleStatus(validationStatus, null);
                }
                catch (CoreException ce) {
                    SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to handle SDK validation error status: {0}", (Object)validationStatus), ce);
                }
            }
        });
    }

    private void loadPersistentSdks() {
        this.persistentSdksLoadingJob.schedule();
    }

    protected WorkspaceJob getPersistentSdksLoadingJob() {
        return this.persistentSdksLoadingJob;
    }
}

