/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectLocalSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.SdkPreferencesHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectLocalSdkLoader {
    public static final String PROJECT_SDK_ERROR_MARKER = "com.nxp.s32ds.cle.cdt.sdk.core.projectSdkErrorMarker";

    private ProjectLocalSdkLoader() {
    }

    public static Map<String, List<SdkDescriptor>> loadProjectLocalSdks() {
        HashMap<String, List<SdkDescriptor>> loadedSdks = new HashMap<String, List<SdkDescriptor>>();
        SdkManagementUtils.getAvailableProjects().forEach(project -> {
            boolean bl = loadedSdks.computeIfAbsent(project.getName(), s -> new ArrayList()).addAll(ProjectLocalSdkLoader.loadProjectLocalSdks(project));
        });
        return loadedSdks;
    }

    public static List<SdkDescriptor> loadProjectLocalSdks(IProject project) {
        if (project == null) {
            SdkCoreActivator.getInstance().logError("Unable to load project local SDKs: project is null");
            return Collections.emptyList();
        }
        String projectLocaSdksXml = SdkPreferencesHelper.getPersistedProjectLocalSdksXml((IProject)project);
        if (projectLocaSdksXml.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return new SdkDescriptorParser().loadSdks(projectLocaSdksXml, null, project, null, SdkType.PROJECT_LOCAL);
        }
        catch (LoadSdkException lse) {
            String projectName = project.getName();
            String causeMessage = lse.getMessage();
            SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdksLoader_project_sdk_load_error_log, (Object)projectName, (Object)causeMessage));
            ProjectLocalSdkLoader.createErrorMarker((IResource)project, NLS.bind((String)Messages.SdksLoader_project_sdk_load_error_marker, (Object)projectName, (Object)causeMessage));
            return Collections.emptyList();
        }
    }

    public static void updatePersistedProjectLocalSdks(IProject project) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk");
            String sdkDescriptorsXml = SdkManagementUtils.getOrderedSdksString(new ProjectLocalSdksFilter(project));
            prefs.put("com.nxp.s32ds.cle.runtime.sdk.project.local.sdks", sdkDescriptorsXml);
            prefs.put("com.nxp.s32ds.cle.runtime.sdk.mgmt.version", SdkRegistryCore.getSdkManagementVersion());
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to update SDKs persitent data for project {0}", (Object)project.getName()), bse);
        }
    }

    public static void updatePersistedProjectLocalSdks() {
        SdkManagementUtils.getAvailableProjects().forEach(ProjectLocalSdkLoader::updatePersistedProjectLocalSdks);
    }

    private static void createErrorMarker(IResource resource, String message) {
        try {
            IMarker marker = resource.createMarker(PROJECT_SDK_ERROR_MARKER);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)resource.getLocation().toString());
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Error while creating SDK problem marker.", ce);
        }
    }
}

