/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterOptionsUtils {
    private FilterOptionsUtils() {
    }

    public static Map<String, Set<String>> emptyHardwareParams() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", Collections.emptySet());
        return result;
    }

    public static Map<String, Set<String>> createHardwareParams(String deviceId, String deviceCoreId, String coreId, String deviceRevisionId) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", deviceId != null && !deviceId.isEmpty() ? Collections.singleton(deviceId) : Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", deviceCoreId != null && !deviceCoreId.isEmpty() ? Collections.singleton(deviceCoreId) : Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", coreId != null && !coreId.isEmpty() ? Collections.singleton(coreId) : Collections.emptySet());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", deviceRevisionId != null && !deviceRevisionId.isEmpty() ? Collections.singleton(deviceRevisionId) : Collections.emptySet());
        return result;
    }

    public static Map<String, Set<String>> createHardwareParams(String hardwareParamsString, String deviceRevisionId) {
        if (hardwareParamsString == null || hardwareParamsString.isEmpty()) {
            return FilterOptionsUtils.emptyHardwareParams();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set hardwareParamsGroups = Arrays.stream(hardwareParamsString.split(",")).map(String::trim).collect(Collectors.toSet());
        for (String hardwareParamsGroup : hardwareParamsGroups) {
            String[] hardwareParamsIds = hardwareParamsGroup.split(":");
            int hardwareParamsCount = hardwareParamsIds.length;
            if (hardwareParamsCount == 0) continue;
            String deviceId = null;
            String deviceCoreId = null;
            String coreId = null;
            if (hardwareParamsCount >= 1) {
                deviceId = hardwareParamsIds[0].trim();
            }
            if (hardwareParamsCount >= 2) {
                deviceCoreId = hardwareParamsIds[1].trim();
            }
            if (hardwareParamsCount >= 3) {
                coreId = hardwareParamsIds[2].trim();
            }
            FilterOptionsUtils.createHardwareParams(deviceId, deviceCoreId, coreId, deviceRevisionId).entrySet().forEach(e -> {
                boolean bl = result.computeIfAbsent((String)e.getKey(), s -> new HashSet()).addAll((Collection)e.getValue());
            });
        }
        return result;
    }

    public static void collectHardwareParams(List<DeviceCoreDescriptor> deviceCoreDescriptors, String deviceRevisionId, Map<String, Set<String>> hardwareParams) {
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            String coreId;
            String deviceCoreId;
            String deviceId = deviceCoreDescriptor.getDeviceId();
            if (deviceId != null) {
                hardwareParams.computeIfAbsent("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", s -> new HashSet()).add(deviceId);
            }
            if ((deviceCoreId = deviceCoreDescriptor.getId()) != null) {
                hardwareParams.computeIfAbsent("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", s -> new HashSet()).add(deviceCoreId);
            }
            if ((coreId = deviceCoreDescriptor.getCoreId()) == null) continue;
            hardwareParams.computeIfAbsent("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", s -> new HashSet()).add(coreId);
        }
        String revisionId = Objects.toString(deviceRevisionId, "");
        hardwareParams.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", !revisionId.isEmpty() ? Collections.singleton(revisionId) : Collections.emptySet());
    }
}

