/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.ddr.report.DDRSummaryGenerator;
import com.nxp.swtools.ddr.report.HtmlUtils;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.DiagsOverlapView;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;

public class OverlayHtmlReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(OverlayHtmlReportGenerator.class);
    public static final String HEADER_TAG = "<h1>%s</h1>";
    public static final String SNAPSHOT_EXT = "png";
    public static final String IMAGE_ENCODE_TAG = "<img src='data:image/png;charset=utf-8;base64,";
    public static final String HEADER_CELL_TAG = "<th>%s</th>";
    public static final String TABLE_ROW_START_TAG = "<tr>";
    public static final String TABLE_ROW_END_TAG = "</tr>";
    public static final String BOLD_TEXT_TAG = "<b>%s</b><span> :</span>";
    public static final String TABLE_CELL_DATA_TAG = "<td><b>%s</b></td>";
    public static final String TEMPLATE_VAR_DATE = "$DATE$";
    public static final String TEMPLATE_MARKER_COPYRIGHT_START = "$COPYRIGHT_START$";
    public static final String TEMPLATE_MARKER_COPYRIGHT_END = "$COPYRIGHT_END$";
    public static final String TEMPLATE_MARKER_CONTENT = "$CONTENT$";
    private static String htmlHeader = "";
    private static String htmlFooter = "";
    private static String htmlCopyright = "";
    private static int contentTabs = 0;

    public static String getReportTemplatePath() {
        String templatesDir = Activator.getDefault().getConfigManager().getTemplatesDir();
        return String.valueOf(templatesDir) + File.separator + "diags_template.html";
    }

    public static String generateHtmlReport(String selScenName, DiagsOverlapView diagOverlapChart) {
        OverlayHtmlReportGenerator.parseHtmlTemplate();
        StringBuilder sb = new StringBuilder();
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)htmlHeader, (int)0);
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)UtilsText.safeString((String)String.format(HEADER_TAG, selScenName.replace("Diag ", ""))), (int)contentTabs);
        String encodedImage = OverlayHtmlReportGenerator.encodeImage(diagOverlapChart);
        sb = encodedImage != null ? HtmlUtils.addLine((StringBuilder)sb, (String)encodedImage, (int)contentTabs) : HtmlUtils.addLine((StringBuilder)sb, (String)("<p>" + Messages.ImageDecodeFailed + "</p>"), (int)contentTabs);
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"<div class='container'>", (int)contentTabs);
        sb.append(OverlayHtmlReportGenerator.getTableHtml(diagOverlapChart));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"</div>", (int)contentTabs);
        sb.append(DDRSummaryGenerator.getFormattedCopyright((String)htmlCopyright)).append(UtilsText.platformEOL);
        sb.append(htmlFooter);
        return UtilsText.safeString((String)sb.toString());
    }

    public static void parseHtmlTemplate() {
        Path htmlPath = Paths.get(OverlayHtmlReportGenerator.getReportTemplatePath(), new String[0]);
        if (!htmlPath.toFile().exists()) {
            return;
        }
        StringJoiner copyrightBuilder = new StringJoiner(UtilsText.platformEOL);
        StringJoiner footerBuilder = new StringJoiner(UtilsText.platformEOL);
        StringJoiner headerBuilder = new StringJoiner(UtilsText.platformEOL);
        boolean copyrightSection = false;
        boolean markerMet = false;
        try {
            List<String> content = Files.readAllLines(htmlPath, StandardCharsets.UTF_8);
            int i = 0;
            while (i < content.size()) {
                if (content.get(i).contains(TEMPLATE_MARKER_COPYRIGHT_START)) {
                    copyrightSection = true;
                } else if (content.get(i).contains(TEMPLATE_MARKER_COPYRIGHT_END)) {
                    copyrightSection = false;
                } else if (copyrightSection) {
                    String line = content.get(i);
                    copyrightBuilder.add(line);
                } else if (content.get(i).contains(TEMPLATE_MARKER_CONTENT)) {
                    contentTabs = HtmlUtils.getTabsLevel((String)content.get(i));
                    markerMet = true;
                } else if (markerMet) {
                    footerBuilder.add(content.get(i));
                } else {
                    headerBuilder.add(content.get(i));
                }
                ++i;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not read HTML template file for DDR Report : " + e.getMessage());
            return;
        }
        htmlHeader = UtilsText.safeString((String)headerBuilder.toString());
        htmlFooter = UtilsText.safeString((String)footerBuilder.toString());
        htmlCopyright = UtilsText.safeString((String)copyrightBuilder.toString());
    }

    public static String getTableHtml(DiagsOverlapView diagOverlapChart) {
        TableView<DiagsOverlapView.EyeResult> tableView = diagOverlapChart.getTable();
        if (tableView != null) {
            StringBuilder sb = new StringBuilder();
            ObservableList tableColumns = tableView.getColumns();
            if (!tableColumns.isEmpty()) {
                ArrayList<String> columnsNames = new ArrayList<String>();
                for (TableColumn column : tableColumns) {
                    columnsNames.add(column.getText());
                }
                String byteLane = (String)columnsNames.remove(0);
                StringBuilder colNameHtml = new StringBuilder();
                colNameHtml = HtmlUtils.addLine((StringBuilder)colNameHtml, (String)TABLE_ROW_START_TAG, (int)(contentTabs + 5));
                for (String name : columnsNames) {
                    colNameHtml = HtmlUtils.addLine((StringBuilder)colNameHtml, (String)UtilsText.safeString((String)String.format(HEADER_CELL_TAG, name)), (int)(contentTabs + 6));
                }
                colNameHtml = HtmlUtils.addLine((StringBuilder)colNameHtml, (String)TABLE_ROW_END_TAG, (int)(contentTabs + 5));
                String colNameHtmlStr = UtilsText.safeString((String)colNameHtml.toString());
                if (!byteLane.equals(Messages.ByteLaneColumn)) {
                    return "";
                }
                ObservableList eyeResultList = tableView.getItems();
                for (DiagsOverlapView.EyeResult eyeResult : eyeResultList) {
                    sb.append(OverlayHtmlReportGenerator.createByteConfigHtml(eyeResult, colNameHtmlStr, byteLane));
                }
                return UtilsText.safeString((String)sb.toString());
            }
        }
        return "";
    }

    public static String createByteConfigHtml(DiagsOverlapView.EyeResult eyeResult, String colNameHtmlStr, String byteLane) {
        StringBuilder sb = new StringBuilder();
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"<div class='ui'>", (int)(contentTabs + 1));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)UtilsText.safeString((String)String.format(BOLD_TEXT_TAG, String.valueOf(byteLane) + " " + eyeResult.getByteLane())), (int)(contentTabs + 2));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"<ul>", (int)(contentTabs + 2));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"<table class=\"propertiesTable\">", (int)(contentTabs + 3));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"<tbody>", (int)(contentTabs + 4));
        sb.append(colNameHtmlStr);
        Map<String, List<String>> bitMap = eyeResult.getBitMap();
        for (Map.Entry<String, List<String>> entry : bitMap.entrySet()) {
            String bitLane = entry.getKey();
            List<String> bitProperties = entry.getValue();
            sb = HtmlUtils.addLine((StringBuilder)sb, (String)TABLE_ROW_START_TAG, (int)(contentTabs + 5));
            sb = HtmlUtils.addLine((StringBuilder)sb, (String)OverlayHtmlReportGenerator.createBitConfigHtml(bitLane, bitProperties), (int)(contentTabs + 6));
            sb = HtmlUtils.addLine((StringBuilder)sb, (String)TABLE_ROW_END_TAG, (int)(contentTabs + 5));
        }
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"</tbody>", (int)(contentTabs + 4));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"</table>", (int)(contentTabs + 3));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"</ul>", (int)(contentTabs + 2));
        sb = HtmlUtils.addLine((StringBuilder)sb, (String)"</div>", (int)(contentTabs + 1));
        return UtilsText.safeString((String)sb.toString());
    }

    public static String createBitConfigHtml(String bitLane, List<String> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(TABLE_CELL_DATA_TAG, bitLane));
        int i = 0;
        while (i < properties.size()) {
            sb.append(String.format(TABLE_CELL_DATA_TAG, properties.get(i)));
            ++i;
        }
        return UtilsText.safeString((String)sb.toString());
    }

    public static @Nullable String encodeImage(DiagsOverlapView diagOverlapChart) {
        CustomLineChart lineChart = diagOverlapChart.getLineChart();
        if (lineChart != null) {
            WritableImage lineChartImage = lineChart.snapshot(new SnapshotParameters(), null);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();){
                    BufferedImage buffImage = SwingFXUtils.fromFXImage((Image)lineChartImage, null);
                    ImageIO.write((RenderedImage)buffImage, SNAPSHOT_EXT, Base64.getEncoder().wrap(byteArrayOutStream));
                    String base64 = byteArrayOutStream.toString(StandardCharsets.UTF_8.name());
                    return IMAGE_ENCODE_TAG + base64 + "'>";
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] " + e.getMessage());
                return null;
            }
        }
        return null;
    }
}

