/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.integration.diags.DiagsOverlapView;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.OverlayHtmlReportGenerator;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.embed.swt.FXCanvas;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class DiagsProvider
implements IDiagsProvider {
    protected static final Logger LOGGER = LogManager.getLogger(DiagsProvider.class);
    @Nullable
    private CTabItem diagsOverlapTab = null;
    private Map<String, @Nullable DiagsOverlapView> overlapViewMap = new HashMap<String, DiagsOverlapView>();
    @Nullable
    private FXCanvas overlapGraphCanvas;

    public void createOverlappedChartsTab(@Nullable CTabFolder scenTabFolder) {
        if (this.diagsOverlapTab == null || this.diagsOverlapTab != null && this.diagsOverlapTab.isDisposed()) {
            CTabItem diagsOverlapTabLoc = this.diagsOverlapTab = new CTabItem(Objects.requireNonNull(scenTabFolder), 0, 2);
            diagsOverlapTabLoc.setText(Messages.DiagsTabName);
        }
    }

    public void updateOverlappedCharts(CTabFolder scenTabFolder, @Nullable VStagePresentation selectedStage) {
        VScenarioPresentation scenarioTest;
        List scenariodIds;
        if (this.overlapViewMap.isEmpty() && selectedStage != null && !(scenariodIds = selectedStage.getScenarioFigureKeys()).isEmpty()) {
            for (String scenarioId : scenariodIds) {
                this.overlapViewMap.put(scenarioId, new DiagsOverlapView());
            }
        }
        if (selectedStage != null && (scenarioTest = selectedStage.getSelectedScenario()) instanceof VDiagsPresentation) {
            String scenarioId;
            scenarioId = scenarioTest.getModel().getId();
            DiagsOverlapView diagOverlayChart = this.overlapViewMap.get(scenarioId);
            if (this.diagsOverlapTab != null && diagOverlayChart != null) {
                CTabItem diagsOverlapTabLoc = this.diagsOverlapTab;
                VDiagsPresentation diagsScenarioTest = (VDiagsPresentation)scenarioTest;
                IDisplayFigure figureTest = diagsScenarioTest.getChart();
                if (figureTest != null && figureTest.getModel().getState().equals((Object)VTable.TableState.CLEAN)) {
                    diagOverlayChart.setChartGenState(false);
                }
                if (!diagOverlayChart.getChartGenerationState()) {
                    diagOverlayChart.disposeParentComposite();
                    this.overlapGraphCanvas = diagOverlayChart.setInput(selectedStage, scenTabFolder, diagsOverlapTabLoc);
                    if (figureTest instanceof VDiagsOverlayFigure) {
                        boolean chartGenerated = ((VDiagsOverlayFigure)figureTest).drawOverlappedCharts();
                        diagOverlayChart.setChartGenState(chartGenerated);
                    }
                } else {
                    ScrolledComposite scrolledComp = diagOverlayChart.getScrolledPanel();
                    if (scrolledComp != null && !scrolledComp.isDisposed()) {
                        diagsOverlapTabLoc.setControl((Control)scrolledComp);
                    }
                }
            }
        }
    }

    public void disposeDiagsTab() {
        if (this.diagsOverlapTab != null) {
            this.diagsOverlapTab.dispose();
        }
    }

    public void populateOverlappedChartsFigures(VScenario model, VDiagsPresentation diagsPresentation) {
        VTableGroup[] tableGroups = model.getTableGroups();
        Map diagFiguresMap = diagsPresentation.getDiagOverFiguresMap();
        if (tableGroups != null) {
            VDiagsOverlayFigure[][] crtOverTableFigures = new VDiagsOverlayFigure[tableGroups.length][];
            int i = 0;
            while (i < crtOverTableFigures.length) {
                VTableGroup tableGrp = tableGroups[i];
                VTable[] tables = tableGrp.getTables();
                crtOverTableFigures[i] = new VDiagsOverlayFigure[tables.length];
                int j = 0;
                while (j < tables.length) {
                    VDiagsOverlayFigure tableOverFigure;
                    crtOverTableFigures[i][j] = tableOverFigure = new VDiagsOverlayFigure(tables[j]);
                    diagFiguresMap.put(tables[j].getId(), tableOverFigure);
                    ++j;
                }
                ++i;
            }
            diagsPresentation.setDiagOverFigures((IDisplayFigure[][])crtOverTableFigures);
        }
    }

    public @Nullable Canvas getOverlapGraphCanvas() {
        return this.overlapGraphCanvas;
    }

    public boolean isOverlayCanvas(Canvas canvas) {
        if (this.overlapGraphCanvas != null) {
            return this.overlapGraphCanvas.equals(canvas);
        }
        return false;
    }

    public void resetOverlayGeneratedFlag(String scenarioId) {
        DiagsOverlapView overlapChart = this.overlapViewMap.get(scenarioId);
        if (overlapChart != null) {
            overlapChart.setChartGenState(false);
        }
    }

    public void exportCharts(String path, String selScenName, String selScenId) {
        DiagsOverlapView overlapChart = this.overlapViewMap.get(selScenId);
        if (overlapChart != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileWriter fileWriter = new FileWriter(path, StandardCharsets.UTF_8);){
                    fileWriter.write(OverlayHtmlReportGenerator.generateHtmlReport(selScenName, overlapChart));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] " + e.getMessage());
            }
        }
    }
}

