/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Callback;
import javafx.util.Duration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiagsOverlapView {
    protected static final Logger LOGGER = LogManager.getLogger(DiagsOverlapView.class);
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private FXCanvas graphCanvas;
    @Nullable
    private VStagePresentation selectedStage;
    @Nullable
    private CustomLineChart lineAreaChart;
    @Nullable
    private HBox hBoxCheckBoxes;
    @Nullable
    private TableView<EyeResult> eyeResult;
    @Nullable
    private VBox vBox;
    @Nullable
    private ScrollPane scrollPane;
    private boolean chartGenerated = false;

    public @Nullable FXCanvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsOverlapTab) {
        int numGraphs = this.readNumGraphs();
        ScrolledComposite graphScrolledPanelLoc = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 0);
        graphScrolledPanelLoc.setExpandHorizontal(true);
        graphScrolledPanelLoc.setExpandVertical(true);
        FXCanvas graphCanvasLoc = this.graphCanvas = new FXCanvas((Composite)this.graphScrolledPanel, 0);
        graphCanvasLoc.setData((Object)Messages.DiagsTabName);
        if (numGraphs == 0) {
            this.createStatusLabel(graphCanvasLoc);
            this.lineAreaChart = null;
            this.hBoxCheckBoxes = null;
            this.eyeResult = null;
            this.vBox = null;
            this.scrollPane = null;
        } else if (this.selectedStage != null) {
            URL chartsSkin;
            String detailsTableOption;
            NumberAxis xAxis = new NumberAxis();
            NumberAxis yAxis = new NumberAxis();
            xAxis.setLabel(Messages.StrobeDelayLabel);
            yAxis.setLabel(Messages.VrefLabel);
            xAxis.setAutoRanging(false);
            yAxis.setAutoRanging(false);
            xAxis.setTickUnit(2.0);
            yAxis.setTickUnit(0.05);
            double[] initialBounds = new double[4];
            Platform.runLater(() -> DiagsOverlapView.setAxisBounds(xAxis, yAxis, initialBounds));
            CustomLineChart lineAreaChartLoc = this.lineAreaChart = new CustomLineChart((Axis<Number>)xAxis, (Axis<Number>)yAxis);
            lineAreaChartLoc.setCreateSymbols(false);
            lineAreaChartLoc.setAnimated(false);
            lineAreaChartLoc.setCursor(Cursor.CROSSHAIR);
            lineAreaChartLoc.setLegendSide(Side.RIGHT);
            lineAreaChartLoc.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
            lineAreaChartLoc.setMinHeight(600.0);
            lineAreaChartLoc.setMinWidth(1000.0);
            lineAreaChartLoc.setHorizontalZeroLineVisible(false);
            lineAreaChartLoc.setVerticalZeroLineVisible(false);
            VBox.setVgrow((Node)this.lineAreaChart, (Priority)Priority.ALWAYS);
            int graph = 0;
            while (graph < numGraphs) {
                XYChart.Series series = new XYChart.Series();
                lineAreaChartLoc.getData().add((Object)series);
                ++graph;
            }
            HBox hBoxCheckBoxesLoc = this.hBoxCheckBoxes = new HBox();
            hBoxCheckBoxesLoc.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)this.hBoxCheckBoxes, (Priority)Priority.ALWAYS);
            hBoxCheckBoxesLoc.setPadding(new Insets(0.0, 0.0, 0.0, 220.0));
            HBox xAxisUnitHbox = new HBox(2.0);
            xAxisUnitHbox.setAlignment(Pos.CENTER_LEFT);
            xAxisUnitHbox.setPadding(new Insets(0.0, 5.0, 0.0, 30.0));
            Label xAxisLabel = new Label();
            xAxisLabel.setText(Messages.OxAxisUnitLabel);
            xAxisLabel.setFont(new Font(14.0));
            xAxisLabel.setAlignment(Pos.CENTER_LEFT);
            ComboBox xAxisUnit = new ComboBox();
            xAxisUnit.getItems().addAll((Object[])new String[]{"UI", "ps"});
            xAxisUnit.setValue((Object)"UI");
            xAxisUnit.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
                DiagsOverlapView.resetPlot(xAxis, yAxis, initialBounds);
                lineAreaChartLoc.applyOxUnit((String)newValue);
                lineAreaChartLoc.setOxBounds((String)newValue);
                if (this.eyeResult != null) {
                    TableView<EyeResult> eyeResultLoc = this.eyeResult;
                    for (EyeResult eyeRes : eyeResultLoc.getItems()) {
                        eyeRes.updateDelayProperties((String)newValue);
                        eyeRes.setTableCellValues(eyeRes.getBitLane());
                    }
                    this.updateColumnsName((String)newValue);
                    eyeResultLoc.refresh();
                }
                Platform.runLater(() -> DiagsOverlapView.setAxisBounds(xAxis, yAxis, initialBounds));
            });
            xAxisUnitHbox.getChildren().addAll((Object[])new Node[]{xAxisLabel, xAxisUnit});
            Pane chartPane = this.addZoom(xAxis, yAxis, initialBounds, lineAreaChartLoc);
            HBox lineChartControlHbox = new HBox();
            lineChartControlHbox.setPadding(new Insets(0.0, 0.0, 30.0, 0.0));
            lineChartControlHbox.getChildren().addAll((Object[])new Node[]{this.hBoxCheckBoxes, xAxisUnitHbox});
            VBox vBoxLoc = this.vBox = new VBox();
            vBoxLoc.setPrefSize(1003.0, 860.0);
            vBoxLoc.getChildren().addAll((Object[])new Node[]{chartPane, lineChartControlHbox});
            VPresentationModel vData = ValidationContext.getInstance().getData();
            VModel vModel = vData.getModel();
            if (vModel != null && (detailsTableOption = vModel.getCustomOption("overlay_details_table")) != null && Boolean.parseBoolean(detailsTableOption)) {
                HBox hBoxTable = new HBox();
                hBoxTable.setPadding(new Insets(0.0, 0.0, 5.0, 62.0));
                this.eyeResult = this.createTableView();
                Optional<TableView<EyeResult>> optTableView = Optional.ofNullable(this.eyeResult);
                optTableView.ifPresent(table -> {
                    MenuButton menuButton = new MenuButton("+");
                    for (TableColumn column : table.getColumns()) {
                        CheckMenuItem menuItem = new CheckMenuItem(column.getText());
                        menuItem.setSelected(true);
                        menuItem.selectedProperty().addListener((obs, oldValue, newValue) -> column.setVisible(newValue.booleanValue()));
                        menuButton.getItems().add((Object)menuItem);
                    }
                    hBoxTable.getChildren().addAll((Object[])new Node[]{table, menuButton});
                    vBoxLoc.getChildren().add((Object)hBoxTable);
                });
            }
            ScrollPane scrollPaneLoc = this.scrollPane = new ScrollPane();
            scrollPaneLoc.setFitToWidth(true);
            scrollPaneLoc.setContent((Node)vBoxLoc);
            Scene scene = new Scene((Parent)scrollPaneLoc, (Paint)Color.rgb((int)graphScrolledPanelLoc.getBackground().getRed(), (int)graphScrolledPanelLoc.getBackground().getGreen(), (int)graphScrolledPanelLoc.getBackground().getBlue()));
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null && (chartsSkin = classLoader.getResource("resources/overlapped-charts-skin.css")) != null) {
                scene.getStylesheets().add((Object)chartsSkin.getPath());
            }
            graphCanvasLoc.setScene(scene);
        }
        graphScrolledPanelLoc.setContent((Control)this.graphCanvas);
        CTabItem diagsOverlapTabLoc = diagsOverlapTab;
        if (diagsOverlapTabLoc != null && !diagsOverlapTabLoc.isDisposed()) {
            diagsOverlapTabLoc.setControl((Control)this.graphScrolledPanel);
        }
        return this.graphCanvas;
    }

    public Pane addZoom(NumberAxis xAxis, NumberAxis yAxis, double[] initialBounds, CustomLineChart lineChart) {
        boolean[] validZoom = new boolean[1];
        double[] startPoint = new double[2];
        Rectangle zoomRect = new Rectangle();
        zoomRect.setManaged(false);
        zoomRect.setFill((Paint)Color.TRANSPARENT);
        zoomRect.setStrokeWidth(1.0);
        zoomRect.setStroke((Paint)Color.BLACK);
        zoomRect.getStrokeDashArray().addAll((Object[])new Double[]{OverlapChartsConstants.RECT_WIDTH, OverlapChartsConstants.RECT_LENGTH, OverlapChartsConstants.RECT_WIDTH, OverlapChartsConstants.RECT_LENGTH});
        Pane chartPane = new Pane();
        chartPane.getChildren().add((Object)lineChart);
        long[] lastClickTime = new long[1];
        lineChart.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if ((double)(currentTime - lastClickTime[0]) <= 300.0) {
                DiagsOverlapView.resetPlot(xAxis, yAxis, initialBounds);
                return;
            }
            lArray[0] = currentTime;
            Bounds boundsInScene = lineChart.localToScene(lineChart.getBoundsInLocal());
            dArray2[0] = event.getSceneX() - boundsInScene.getMinX();
            dArray2[1] = event.getSceneY() - boundsInScene.getMinY();
            if (DiagsOverlapView.isInPlottingArea(startPoint[0], startPoint[1])) {
                blArray[0] = true;
                zoomRect.setX(startPoint[0]);
                zoomRect.setY(startPoint[1]);
                zoomRect.setWidth(0.0);
                zoomRect.setHeight(0.0);
                chartPane.getChildren().add((Object)zoomRect);
            } else {
                blArray[0] = false;
            }
        });
        lineChart.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            double yEndPoint;
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            Bounds boundsInScene = lineChart.localToScene(lineChart.getBoundsInLocal());
            double xEndPoint = event.getSceneX() - boundsInScene.getMinX();
            if (DiagsOverlapView.isInPlottingArea(xEndPoint, yEndPoint = event.getSceneY() - boundsInScene.getMinY())) {
                zoomRect.setWidth(Math.abs(xEndPoint - startPoint[0]));
                zoomRect.setHeight(Math.abs(yEndPoint - startPoint[1]));
                zoomRect.setX(Math.min(startPoint[0], xEndPoint));
                zoomRect.setY(Math.min(startPoint[1], yEndPoint));
            }
        });
        lineChart.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            if (validZoom[0] && zoomRect.getWidth() > 0.5 && zoomRect.getHeight() > 0.5) {
                DiagsOverlapView.performZoom(zoomRect, xAxis, yAxis);
            }
            chartPane.getChildren().remove((Object)zoomRect);
        });
        chartPane.setMinWidth(1000.0);
        chartPane.setMaxWidth(600.0);
        return chartPane;
    }

    private static void setAxisBounds(NumberAxis xAxis, NumberAxis yAxis, double[] bounds) {
        bounds[0] = xAxis.getLowerBound();
        bounds[1] = xAxis.getUpperBound();
        bounds[2] = yAxis.getLowerBound();
        bounds[3] = yAxis.getUpperBound();
    }

    private static boolean isInPlottingArea(double x, double y) {
        return 72.0 < x && x < 868.0 && 15.0 < y && y < 540.0;
    }

    private static void performZoom(Rectangle zoomRect, NumberAxis xAxis, NumberAxis yAxis) {
        double centerX = zoomRect.getX() + zoomRect.getWidth() / 2.0;
        double centerY = zoomRect.getY() + zoomRect.getHeight() / 2.0;
        double centerValueX = xAxis.getValueForDisplay(centerX).doubleValue();
        double centerValueY = yAxis.getValueForDisplay(centerY).doubleValue();
        double xRange = xAxis.getUpperBound() - xAxis.getLowerBound();
        double yRange = yAxis.getUpperBound() - yAxis.getLowerBound();
        double zoomFactor = 0.6;
        double newLowerBoundX = centerValueX - xRange * zoomFactor / 2.0;
        double newUpperBoundX = centerValueX + xRange * zoomFactor / 2.0;
        double newLowerBoundY = centerValueY - yRange * zoomFactor / 2.0;
        double newUpperBoundY = centerValueY + yRange * zoomFactor / 2.0;
        xAxis.setLowerBound(newLowerBoundX);
        xAxis.setUpperBound(newUpperBoundX);
        yAxis.setLowerBound(newLowerBoundY);
        yAxis.setUpperBound(newUpperBoundY);
    }

    private static void resetPlot(NumberAxis xAxis, NumberAxis yAxis, double[] initialBounds) {
        xAxis.setLowerBound(initialBounds[0]);
        xAxis.setUpperBound(initialBounds[1]);
        yAxis.setLowerBound(initialBounds[2]);
        yAxis.setUpperBound(initialBounds[3]);
    }

    private void createStatusLabel(FXCanvas gCanvas) {
        VParamVariation cell;
        VTable table;
        VStagePresentation stage = this.selectedStage;
        Label label = new Label();
        label.setAlignment(Pos.TOP_LEFT);
        label.setFont(new Font(15.0));
        if (stage != null && (table = stage.getSelectedScenarioTable()) != null && (cell = table.getParamVariation(new Point(0, 0))) != null) {
            VRunResult runResult = cell.getResult(0);
            if (runResult != null && runResult.getType() == VRunResult.ResultType.FAILED) {
                label.setText(runResult.getErrorMessage());
            } else if (table.getState() == VTable.TableState.RUNNING) {
                label.setText(Messages.CollectingDataLabel);
            } else {
                label.setText(Messages.NoDataCollectedLabel);
            }
        }
        Scene scene = new Scene((Parent)label);
        gCanvas.setScene(scene);
    }

    private int readNumGraphs() {
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        VScenarioPresentation scenario;
        if (this.selectedStage != null && (scenario = this.selectedStage.getSelectedScenario()) instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure) {
            return ((VDiagsOverlayFigure)figure).getNoEyeTables();
        }
        return 0;
    }

    public @Nullable FXCanvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem overlappedChartsTab) {
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, overlappedChartsTab);
        VScenarioPresentation scenario = selectedStage.getSelectedScenario();
        if (scenario instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure) {
            ((VDiagsOverlayFigure)figure).updateDiagsInfo(this.lineAreaChart, this.hBoxCheckBoxes, this.eyeResult);
            if (this.graphCanvas != null) {
                this.graphCanvas.redraw();
            }
        }
        return this.graphCanvas;
    }

    public TableView<EyeResult> createTableView() {
        TableColumn byteColumn = new TableColumn(Messages.ByteLaneColumn);
        byteColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.ByteLaneObject));
        TableColumn bitColumn = new TableColumn(Messages.BitLaneColumn);
        bitColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.BitLaneObject));
        TableColumn goldenVrefColumn = new TableColumn();
        this.setColumnLabel(goldenVrefColumn, Messages.CenterVrefColumn, Messages.CenterVrefTooltip);
        goldenVrefColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.GoldenVrefObject));
        TableColumn goldenDelayColumn = new TableColumn();
        this.setColumnLabel(goldenDelayColumn, String.format(Messages.CenterDelayColumn, "UI"), Messages.CenterDelayTooltip);
        goldenDelayColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.GoldenDelayObject));
        TableColumn closestVrefMarginColumn = new TableColumn();
        this.setColumnLabel(closestVrefMarginColumn, Messages.MarginPointVrefColumn, Messages.VrefMarginPointTooltip);
        closestVrefMarginColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((EyeResult)cellData.getValue()).getClosestVrefMarginAsDouble()));
        closestVrefMarginColumn.setCellFactory(column -> new TableCell<EyeResult, Double>(){

            protected void updateItem(@Nullable Double item, boolean empty) {
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    ObservableList items;
                    super.updateItem((Object)item, empty);
                    TableView tableView = this.getTableView();
                    if (tableView != null && (items = tableView.getItems()) != null) {
                        EyeResult result = (EyeResult)items.get(this.getIndex());
                        this.setText(result.getClosestVrefMargin());
                    }
                }
            }
        });
        TableColumn closestDelayMarginColumn = new TableColumn();
        this.setColumnLabel(closestDelayMarginColumn, String.format(Messages.MarginPointDelayColumn, "UI"), Messages.DelayMarginPointTooltip);
        closestDelayMarginColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.ClosestDelayMarginObject));
        TableColumn deltaVrefColumn = new TableColumn();
        this.setColumnLabel(deltaVrefColumn, Messages.DeltaVrefColumn, Messages.DeltaVrefTooltip);
        deltaVrefColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((EyeResult)cellData.getValue()).getDeltaVrefAsDouble()));
        deltaVrefColumn.setCellFactory(column -> new TableCell<EyeResult, Double>(){

            protected void updateItem(@Nullable Double item, boolean empty) {
                if (empty || item == null) {
                    this.setText(null);
                } else {
                    ObservableList items;
                    super.updateItem((Object)item, empty);
                    TableView tableView = this.getTableView();
                    if (tableView != null && (items = tableView.getItems()) != null) {
                        EyeResult result = (EyeResult)items.get(this.getIndex());
                        this.setText(result.getDeltaVref());
                    }
                }
            }
        });
        TableColumn deltaDelayColumn = new TableColumn();
        this.setColumnLabel(deltaDelayColumn, String.format(Messages.DeltaDelayColumn, "UI"), Messages.DeltaDelayTooltip);
        deltaDelayColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.DeltaDelayObject));
        TableView table = new TableView();
        table.setEditable(true);
        List<TableColumn> columns = Arrays.asList(byteColumn, bitColumn, goldenVrefColumn, goldenDelayColumn, deltaVrefColumn, closestVrefMarginColumn, deltaDelayColumn, closestDelayMarginColumn);
        for (TableColumn column2 : columns) {
            table.getColumns().add((Object)column2);
        }
        table.setPrefHeight(200.0);
        table.setPrefWidth(903.0);
        byteColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.085));
        bitColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.085));
        goldenVrefColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.115));
        goldenDelayColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.13));
        closestVrefMarginColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.155));
        closestDelayMarginColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.166));
        deltaVrefColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.115));
        deltaDelayColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.13));
        return table;
    }

    public <T> void setColumnLabel(TableColumn<EyeResult, T> column, String columnName, String tooltipMessage) {
        Label columnLabel = new Label(columnName);
        Tooltip tooltip = new Tooltip(tooltipMessage);
        tooltip.getStyleClass().add((Object)"custom-tooltip");
        tooltip.setShowDelay(Duration.millis((double)10.0));
        String columnNameWithoutUnit = columnName.split("\\(")[0].strip();
        column.setText(columnNameWithoutUnit);
        column.getStyleClass().add((Object)"invisible-header-text");
        columnLabel.setTooltip(tooltip);
        column.setGraphic((Node)columnLabel);
    }

    public void updateColumnsName(String unit) {
        if (this.eyeResult != null) {
            TableView<EyeResult> eyeResultLoc = this.eyeResult;
            try {
                TableColumn deltaDelayColumn;
                TableColumn minDelayMarginColumn;
                TableColumn goldenDelayColumn = (TableColumn)eyeResultLoc.getColumns().get(3);
                if (goldenDelayColumn != null) {
                    this.setLabelNameOfColumn(goldenDelayColumn, String.format(Messages.CenterDelayColumn, unit));
                }
                if ((minDelayMarginColumn = (TableColumn)eyeResultLoc.getColumns().get(7)) != null) {
                    this.setLabelNameOfColumn(minDelayMarginColumn, String.format(Messages.MarginPointDelayColumn, unit));
                }
                if ((deltaDelayColumn = (TableColumn)eyeResultLoc.getColumns().get(6)) != null) {
                    this.setLabelNameOfColumn(deltaDelayColumn, String.format(Messages.DeltaDelayColumn, unit));
                }
            }
            catch (IndexOutOfBoundsException error) {
                LOGGER.warning(error.getMessage());
            }
        }
    }

    public void setLabelNameOfColumn(TableColumn<EyeResult, ?> column, String columnName) {
        if (column.getGraphic() instanceof Label) {
            Label columnLabel = (Label)column.getGraphic();
            columnLabel.setText(columnName);
        }
    }

    public @Nullable CustomLineChart getLineChart() {
        return this.lineAreaChart;
    }

    public @Nullable TableView<EyeResult> getTable() {
        return this.eyeResult;
    }

    public @Nullable ScrolledComposite getScrolledPanel() {
        return this.graphScrolledPanel;
    }

    public boolean getChartGenerationState() {
        return this.chartGenerated;
    }

    public void setChartGenState(boolean generated) {
        this.chartGenerated = generated;
    }

    public void disposeParentComposite() {
        if (this.graphScrolledPanel != null) {
            this.graphScrolledPanel.dispose();
        }
    }

    public static class EyeResult {
        private final SimpleStringProperty byteLane;
        private final SimpleStringProperty bitLane;
        private final SimpleStringProperty goldenVref;
        private final SimpleStringProperty goldenDelay;
        private final SimpleStringProperty closestVrefMargin;
        private final SimpleIntegerProperty closestDelayMargin;
        private final SimpleStringProperty deltaVref;
        private final SimpleStringProperty deltaDelay;
        private Map<String, List<String>> bitMap = new HashMap<String, List<String>>();
        private Map<String, Map<String, List<String>>> delayPropertyMap = new HashMap<String, Map<String, List<String>>>();
        public static final int TAP_DELAY_INDEX_MAP = 0;
        public static final int MARGIN_DELAY_POINT_INDEX_MAP = 1;
        public static final int MARGIN_DELAY_INDEX_MAP = 2;
        public static final int CENTER_DELAY_COL_INDEX = 3;
        public static final int CLOSEST_DELAY_COL_INDEX = 7;
        public static final int DELTA_DELAY_COL_INDEX = 6;
        public static final int BIT0 = 0;
        public static final int BIT7 = 8;

        EyeResult(String byteLaneParam, String bitLaneParam, String goldenVrefParam, String goldenDelayParam, String closestVrefMarginParam, int closestDelayMarginParam, String deltaVref, String deltaDelay) {
            this.byteLane = new SimpleStringProperty(byteLaneParam);
            this.bitLane = new SimpleStringProperty(bitLaneParam);
            this.goldenVref = new SimpleStringProperty(goldenVrefParam);
            this.goldenDelay = new SimpleStringProperty(goldenDelayParam);
            this.closestVrefMargin = new SimpleStringProperty(closestVrefMarginParam);
            this.closestDelayMargin = new SimpleIntegerProperty(closestDelayMarginParam);
            this.deltaVref = new SimpleStringProperty(deltaVref);
            this.deltaDelay = new SimpleStringProperty(deltaDelay);
        }

        public String getByteLane() {
            return Objects.requireNonNull(this.byteLane.get());
        }

        public String getBitLane() {
            return Objects.requireNonNull(this.bitLane.get());
        }

        public void setBitLane(String bitLaneParam) {
            this.bitLane.set(bitLaneParam);
        }

        public String getGoldenVref() {
            return Objects.requireNonNull(this.goldenVref.get());
        }

        public String getGoldenDelay() {
            return Objects.requireNonNull(this.goldenDelay.get());
        }

        public void setGoldenVref(String goldenVrefParam) {
            this.goldenVref.set(goldenVrefParam);
        }

        public void setGoldenDelay(String goldenDelayParam) {
            this.goldenDelay.set(goldenDelayParam);
        }

        public String getClosestVrefMargin() {
            return Objects.requireNonNull(this.closestVrefMargin.get());
        }

        public int getClosestDelayMargin() {
            return this.closestDelayMargin.get();
        }

        public void setClosestVrefMargin(String closestVrefMarginParam) {
            this.closestVrefMargin.set(closestVrefMarginParam);
        }

        public void setClosestDelayMargin(int closestDelayMarginParam) {
            this.closestDelayMargin.set(closestDelayMarginParam);
        }

        public String getDeltaVref() {
            return Objects.requireNonNull(this.deltaVref.get());
        }

        public void setDeltaVref(String deltaVref) {
            this.deltaVref.set(deltaVref);
        }

        public String getDeltaDelay() {
            return Objects.requireNonNull(this.deltaDelay.get());
        }

        public void setDeltaDelay(String deltaDelay) {
            this.deltaDelay.set(deltaDelay);
        }

        public double getClosestVrefMarginAsDouble() {
            return Double.parseDouble(this.getClosestVrefMargin().replace("~", ""));
        }

        public double getDeltaVrefAsDouble() {
            return Double.parseDouble(this.getDeltaVref().replace("~", ""));
        }

        public void addBitKey(String bitNumber, List<String> parameters) {
            this.bitMap.put(bitNumber, parameters);
        }

        public void setTableCellValues(String bitLaneParam) {
            String centerVref = "";
            String centerDelay = "";
            String closestVref = "";
            String closestDelay = "";
            String vrefMarginDistance = "";
            String delayMarginDistance = "";
            List<String> paramList = this.bitMap.get(bitLaneParam);
            if (paramList != null) {
                try {
                    centerVref = paramList.get(PropertyIndex.CENTER_VREF.ordinal());
                    centerDelay = paramList.get(PropertyIndex.CENTER_DELAY.ordinal());
                    closestVref = paramList.get(PropertyIndex.CLOSEST_VREF.ordinal());
                    closestDelay = paramList.get(PropertyIndex.CLOSEST_DELAY.ordinal());
                    vrefMarginDistance = paramList.get(PropertyIndex.DELTA_VREF.ordinal());
                    delayMarginDistance = paramList.get(PropertyIndex.DELTA_DELAY.ordinal());
                }
                catch (IndexOutOfBoundsException error) {
                    LOGGER.warning(error.getMessage());
                }
            }
            this.setGoldenVref(centerVref);
            this.setGoldenDelay(centerDelay);
            this.setClosestVrefMargin(closestVref);
            this.setClosestDelayMargin(Integer.parseInt(closestDelay.replaceAll("~", "")));
            this.setDeltaVref(vrefMarginDistance);
            this.setDeltaDelay(delayMarginDistance);
        }

        public void updateDelayProperties(String unit) {
            for (Map.Entry<String, Map<String, List<String>>> entry : this.delayPropertyMap.entrySet()) {
                Map<String, List<String>> delayMap = entry.getValue();
                List<String> delayList = delayMap.get(unit);
                if (delayList == null) continue;
                String tapDelay = delayList.get(0);
                String marginDelayPoint = delayList.get(1);
                String marginDelay = delayList.get(2);
                List<String> propertyList = this.bitMap.get(entry.getKey());
                if (propertyList == null) continue;
                propertyList.set(PropertyIndex.CENTER_DELAY.ordinal(), tapDelay);
                propertyList.set(PropertyIndex.CLOSEST_DELAY.ordinal(), marginDelayPoint);
                propertyList.set(PropertyIndex.DELTA_DELAY.ordinal(), marginDelay);
            }
        }

        public void addBitProperties(int bit, String goldenVrefParam, int tapDelay, String closestOyMargin, String closestOxMargin, String vrefMarginDistance, String delayMarginDistance, Map<String, List<String>> unitMap) {
            String bitEntry = String.valueOf(bit);
            ArrayList<String> params = new ArrayList<String>();
            params.add(goldenVrefParam);
            params.add(String.valueOf(tapDelay));
            params.add(vrefMarginDistance);
            params.add(closestOyMargin);
            params.add(delayMarginDistance);
            params.add(closestOxMargin);
            this.addBitKey(bitEntry, params);
            this.addDelayPropertiesValues(bitEntry, unitMap);
        }

        public void addDelayPropertiesValues(String bit, Map<String, List<String>> delayMap) {
            this.delayPropertyMap.put(bit, delayMap);
        }

        public Map<String, List<String>> getBitMap() {
            return this.bitMap;
        }

        public static enum PropertyIndex {
            CENTER_VREF,
            CENTER_DELAY,
            DELTA_VREF,
            CLOSEST_VREF,
            DELTA_DELAY,
            CLOSEST_DELAY;

        }
    }

    private static class OverlapChartsConstants {
        private static final int VBOX_WIDTH = 1003;
        private static final int VBOX_HEIGHT = 860;
        private static final int LINE_CHART_WIDTH = 1000;
        private static final int LINE_CHART_HEIGHT = 600;
        private static final int ESTIMATED_PLOT_END_WIDTH = 868;
        private static final int ESTIMATED_PLOT_END_HEIGHT = 540;
        private static final int ESTIMATED_PLOT_START_WIDTH = 72;
        private static final int ESTIMATED_PLOT_START_HEIGHT = 15;
        private static final int TABLE_WIDTH = 903;
        private static final int TABLE_HEIGHT = 200;
        private static final double BYTE_BIT_COL_MULTIPLY = 0.085;
        private static final double VREF_CENTER_AND_MARGIN_MULTIPLY = 0.115;
        private static final double DELAY_CENTER_AND_MARGIN_MULTIPLY = 0.13;
        private static final double VREF_POINTS_MULTIPLY = 0.155;
        private static final double DELAY_POINTS_MULTIPLY = 0.166;
        private static final double CLICK_LIMIT = 300.0;
        static final Double RECT_LENGTH = 5.0;
        static final Double RECT_WIDTH = 2.0;

        private OverlapChartsConstants() {
        }
    }
}

