/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.TilePane;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.util.Pair;

public class CustomLineChart
extends LineChart<Number, Number> {
    @Nullable
    private List<XYChart.Data<Number, Number>> centerPoints;
    @Nullable
    private Label lastHighlightedLabel;
    @Nullable
    private XYChart.Series<Number, Number> lastSeries = new XYChart.Series();
    private Map<CheckBox, ObservableList<XYChart.Series<Number, Number>>> byteLaneMap = new HashMap<CheckBox, ObservableList<XYChart.Series<Number, Number>>>();
    private Map<String, Map<String, List<Integer>>> dqMap = new HashMap<String, Map<String, List<Integer>>>();
    private Map<String, Pair<Integer, Integer>> boundsMap = new HashMap<String, Pair<Integer, Integer>>();

    public CustomLineChart(Axis<Number> xAxis, Axis<Number> yAxis) {
        super(xAxis, yAxis);
    }

    protected void layoutPlotChildren() {
        ArrayList<LineTo> constructedPath = new ArrayList<LineTo>(this.getData().size());
        int seriesIndex = 0;
        while (seriesIndex < this.getData().size()) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Node seriesNode = series.getNode();
            if (seriesNode instanceof Path) {
                Path node = (Path)seriesNode;
                ObservableList seriesLine = node.getElements();
                seriesLine.clear();
                constructedPath.clear();
                Iterator it = this.getDisplayedDataIterator(series);
                while (it.hasNext()) {
                    XYChart.Data center = (XYChart.Data)series.getData().get(series.getData().size() - 1);
                    XYChart.Data item = (XYChart.Data)it.next();
                    double x = this.getXAxis().getDisplayPosition((Object)((Number)item.getXValue()));
                    double y = this.getYAxis().getDisplayPosition((Object)((Number)this.getYAxis().toRealValue(this.getYAxis().toNumericValue((Object)((Number)item.getYValue())))));
                    Node symbol = item.getNode();
                    if (symbol != null) {
                        double w = symbol.prefWidth(-1.0);
                        double h = symbol.prefHeight(-1.0);
                        symbol.resizeRelocate(x - w / 2.0, y - h / 2.0, w, h);
                    }
                    if (center.equals(item)) continue;
                    constructedPath.add(new LineTo(x, y));
                }
                if (!constructedPath.isEmpty()) {
                    LineTo first = (LineTo)constructedPath.get(0);
                    seriesLine.add((Object)new MoveTo(first.getX(), first.getY()));
                    seriesLine.addAll(constructedPath);
                    seriesLine.add((Object)new LineTo(first.getX(), first.getY()));
                }
            }
            ++seriesIndex;
        }
    }

    public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    XYChart.Data<Number, Number>> getCenterPoints() {
        return this.centerPoints;
    }

    public void setCenterPoints(@Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    XYChart.Data<Number, Number>> cPoints) {
        this.centerPoints = cPoints;
    }

    public void setByteMap(Map<CheckBox, ObservableList<XYChart.Series<Number, Number>>> byteLaneMapParam) {
        this.byteLaneMap = byteLaneMapParam;
    }

    public void addLegendListener() {
        for (XYChart.Series series : this.getData()) {
            Label label = this.getLabelOfSeries((XYChart.Series<Number, Number>)series);
            if (label == null) continue;
            label.setOnMouseClicked(me -> {
                Node seriesNode;
                if (me.getButton() == MouseButton.PRIMARY && (seriesNode = series.getNode()) != null) {
                    boolean visible = !seriesNode.isVisible();
                    this.setSeriesVisibility((XYChart.Series<Number, Number>)series, visible, false);
                    CustomLineChart.setLabelOpacity(label, visible);
                    this.updateByteBoxState((XYChart.Series<Number, Number>)series);
                }
            });
            label.setOnMouseEntered(event -> {
                Node seriesNode = series.getNode();
                if (!this.lastSeries.getData().isEmpty()) {
                    Node lastNode = this.lastSeries.getNode();
                    if (seriesNode.isVisible() && lastNode != null && this.lastHighlightedLabel != null) {
                        CustomLineChart.setLabelStyle(this.lastHighlightedLabel, "display-font-color");
                        CustomLineChart.setLabelStyle(label, "highlight-font-color");
                        this.lastHighlightedLabel = label;
                        this.lastSeries = series;
                        seriesNode.toFront();
                        CustomLineChart.setSeriesToFront((XYChart.Series<Number, Number>)series);
                    }
                } else {
                    seriesNode.toFront();
                    CustomLineChart.setLabelStyle(label, "highlight-font-color");
                    this.lastSeries = series;
                    this.lastHighlightedLabel = label;
                    CustomLineChart.setSeriesToFront((XYChart.Series<Number, Number>)series);
                }
            });
        }
    }

    public static void setSeriesToFront(XYChart.Series<Number, Number> series) {
        for (XYChart.Data data : series.getData()) {
            Node dataNode = data.getNode();
            if (dataNode == null) continue;
            dataNode.toFront();
        }
    }

    public void setListOfSeriesVisibility(ObservableList<XYChart.Series<Number, Number>> seriesList, boolean visible, boolean applyLabel) {
        for (XYChart.Series series : seriesList) {
            this.setSeriesVisibility((XYChart.Series<Number, Number>)series, visible, applyLabel);
        }
    }

    public void setSeriesVisibility(XYChart.Series<Number, Number> series, boolean visible, boolean applyLabel) {
        Label label;
        Node seriesNode = series.getNode();
        if (seriesNode != null) {
            seriesNode.setVisible(visible);
        }
        for (XYChart.Data data : series.getData()) {
            Node dataNode = data.getNode();
            if (dataNode == null) continue;
            dataNode.setVisible(visible);
        }
        if (applyLabel && (label = this.getLabelOfSeries(series)) != null) {
            CustomLineChart.setLabelOpacity(label, visible);
        }
    }

    public @Nullable Label getLabelOfSeries(XYChart.Series<Number, Number> series) {
        for (Node node : this.getChildrenUnmodifiable()) {
            if (!(node instanceof TilePane)) continue;
            TilePane pane = (TilePane)node;
            pane.setCursor(Cursor.HAND);
            for (Node child : pane.getChildrenUnmodifiable()) {
                if (!(child instanceof Label)) continue;
                Label label = (Label)child;
                if (!series.getName().equals(label.getText())) continue;
                return label;
            }
        }
        return null;
    }

    public static void setLabelOpacity(Label label, boolean visible) {
        label.setOpacity(visible ? 1.0 : 0.4);
    }

    public static void setLabelStyle(Label label, String style) {
        label.getStyleClass().setAll((Object[])new String[]{style});
    }

    public void updateByteBoxState(XYChart.Series<Number, Number> series) {
        for (Map.Entry<CheckBox, ObservableList<XYChart.Series<Number, Number>>> entry : this.byteLaneMap.entrySet()) {
            ObservableList<XYChart.Series<Number, Number>> seriesList = entry.getValue();
            if (!seriesList.contains(series)) continue;
            entry.getKey().setSelected(CustomLineChart.isListOfSeriesVisible(seriesList));
        }
    }

    public static boolean isListOfSeriesVisible(ObservableList<XYChart.Series<Number, Number>> seriesList) {
        boolean visible = false;
        for (XYChart.Series series : seriesList) {
            Node seriesNode = series.getNode();
            if (seriesNode == null || !seriesNode.isVisible()) continue;
            return true;
        }
        return visible;
    }

    public void applyOxUnit(String xUnit) {
        for (XYChart.Series series : this.getData()) {
            Map<String, List<Integer>> unitMap = this.dqMap.get(series.getName());
            if (unitMap == null) continue;
            List<Integer> unitDelayList = unitMap.get(xUnit);
            ObservableList dataList = series.getData();
            if (unitDelayList == null || unitDelayList.size() != dataList.size()) continue;
            int i = 0;
            while (i < unitDelayList.size()) {
                XYChart.Data dataPoint = (XYChart.Data)dataList.get(i);
                if (i == dataList.size() - 1) {
                    dataPoint.setXValue((Object)0);
                } else {
                    dataPoint.setXValue((Object)unitDelayList.get(i));
                    Node dataNode = dataPoint.getNode();
                    if (dataNode instanceof VDiagsOverlayFigure.HoveredThresholdNode) {
                        VDiagsOverlayFigure.HoveredThresholdNode hoverNode = (VDiagsOverlayFigure.HoveredThresholdNode)dataNode;
                        hoverNode.setLabelXCoord(unitDelayList.get(i));
                    }
                }
                ++i;
            }
        }
    }

    public void setOyBounds(double lowerBound, double upperBound, double gap) {
        NumberAxis yAxis = (NumberAxis)this.getYAxis();
        if (yAxis != null) {
            yAxis.setLowerBound(lowerBound - gap);
            yAxis.setUpperBound(upperBound + gap);
        }
    }

    public void setOxBounds(String unit) {
        Pair<Integer, Integer> bounds;
        double limitGap = 0.0;
        int tickUnit = 2;
        NumberAxis xAx = (NumberAxis)this.getXAxis();
        if (xAx != null && (bounds = this.boundsMap.get(unit)) != null) {
            if (unit.equals("ps")) {
                xAx.setLabel(Messages.TimeDelayLabel);
                limitGap = 10.0;
                tickUnit = 35;
            } else if (unit.equals("UI")) {
                xAx.setLabel(Messages.StrobeDelayLabel);
                limitGap = 1.0;
                tickUnit = 2;
            }
            xAx.setLowerBound((double)((Integer)bounds.getKey()).intValue() - limitGap);
            xAx.setUpperBound((double)((Integer)bounds.getValue()).intValue() + limitGap);
            xAx.setTickUnit((double)tickUnit);
        }
    }

    public void extractOxBounds(String unit) {
        int max = -100000;
        int min = 100000;
        for (Map.Entry<String, Map<String, List<Integer>>> entry : this.dqMap.entrySet()) {
            Map<String, List<Integer>> map = entry.getValue();
            List<Integer> list = map.get(unit);
            if (list == null) continue;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) > max) {
                    max = list.get(i);
                }
                if (list.get(i) < min) {
                    min = list.get(i);
                }
                ++i;
            }
        }
        this.boundsMap.put(unit, (Pair<Integer, Integer>)new Pair((Object)min, (Object)max));
    }

    public void addDelayValuesToMap(String dqNumber, List<Integer> delayValues, String unit) {
        List<Integer> delayList;
        Map<String, List<Integer>> unitList = this.dqMap.get(dqNumber);
        if (unitList != null && (delayList = unitList.get(unit)) != null) {
            delayList.addAll(delayValues);
        }
    }

    public Map<String, Map<String, List<Integer>>> getDqMap() {
        return this.dqMap;
    }
}

