/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatcher;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatchers;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.core.S32DebuggerSecureData;
import com.nxp.s32ds.debug.ide.internal.core.ErrorMessages;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence_7_12;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;

public abstract class DebuggerLaunchSequence
extends FinalLaunchSequence_7_12 {
    private static final String KEY_STORAGE_KEYWORD = "lc_keyword";
    private static final String SC_PASSWORD_STORAGE = "sc_password";
    protected static final String USER_CANCELED_KEYWORD_INSERTION = "Keyword insertion for secure debugging was cancelled by user";
    protected static final String GROUP_S32_DEBUGGER = "GROUP_S32Debugger";
    protected static final String HEX_PREFIX = "0x";
    protected static final String DEFAULT = "default";
    protected static final String SOURCE_S = "source %s";
    protected static final String PY_RESET_DELAY_S = "py _RESET_DELAY = %s";
    protected static final String PY_SECURE_TYPE = "py _SECURE_TYPE = \"%s\"";
    protected static final String PY_SECURE_KEY = "py _SECURE_KEY = \"%s\"";
    protected static final String PY_RESET_TYPE_S = "py _RESET_TYPE = \"%s\"";
    protected static final String PY_RESET_TYPE_NONE = "py _RESET_TYPE = None";
    protected static final String PY_GDB_SERVER_PORT_S = "py _GDB_SERVER_PORT = %s";
    protected static final String PY_PROBE_IP_S = "py _PROBE_IP = \"%s\"";
    protected static final String PY_IS_LOGGING_ENABLED_S = "py _IS_LOGGING_ENABLED = %s";
    protected static final String PY_JTAG_SPEED_S = "py _JTAG_SPEED = %s";
    protected static final String PY_SOC_NAME = "py _SOC_NAME = \"%s\"";
    protected static final String PY_REVISION = "py _SOC_REVISION = \"%s\"";
    protected static final String PY_CCS_IP_S = "py _CCS_IP = \"%s\"";
    protected static final String PY_CCS_PORT_S = "py _CCS_PORT = %s";
    protected static final String STEP_DATA_MODEL_INITIALIZATION_COMPLETE = "stepDataModelInitializationComplete";
    protected static final String STEP_NEW_PROCESS = "stepNewProcess";
    protected static final String STEP_INITIALIZE_DEBUGGER_FINAL_LAUNCH_SEQUENCE = "stepInitializeDebuggerFinalLaunchSequence";
    protected static final String STEP_INITIALIZE_GDB_SERVER_PROCESS = "stepInitializeGdbServerProcess";
    protected static final String STEP_DEBUGGER_CLEANUP = "stepDebuggerCleanup";
    protected static final String LIST_THREADS = "-list-thread-groups";
    protected static final String THREAD_SELECT = "-thread-select 1";
    protected static final String VOLKANO_DIRECTORY = "${S32DS_GDB_SERVER_DIR}/Debugger/Server/CCS/bin/";
    protected static final String VOLKANO_EXECUTABLE = "volkano.exe";
    protected static final String VOLKANO_COMMAND_GET_VERSION = "--version";
    protected static final String CARD_DISCONNECTED_MARKER = "smart card disconnected";
    protected DsfServicesTracker tracker;
    protected S32DSGdbLaunch launch;
    protected String keyWord;

    public DebuggerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        Object curLaunch = session.getModelAdapter(ILaunch.class);
        if (curLaunch instanceof S32DSGdbLaunch) {
            this.launch = (S32DSGdbLaunch)curLaunch;
        } else {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.ui.handlers.noLaunchFailureStatusHandler", S32DebuggerErrorStatuses.getGDBNoLaunchStatus());
        }
        this.keyWord = "";
    }

    /*
     * Exception decompiling
     */
    protected IStatus checkSmartCardConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IStatus getSmartCardPassword() {
        block12: {
            Map settings;
            IStatus status = this.checkSmartCardConnection();
            if (!status.isOK()) {
                RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.missingSmartcardStatusHandler");
                try {
                    Object result = handler.handleStatus(null, (Object)this);
                    if (result instanceof Boolean) {
                        Boolean userConfirmation = (Boolean)result;
                        if (userConfirmation.booleanValue()) {
                            this.keyWord = "";
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            String configName = this.launch.getLaunchConfiguration().getName();
            if (dispatcher != null && (settings = dispatcher.getProtectedSettings(configName)) != null && settings.containsKey(SC_PASSWORD_STORAGE)) {
                this.keyWord = (String)settings.get(SC_PASSWORD_STORAGE);
            }
            if (this.keyWord.isEmpty()) {
                try {
                    RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.smartCardPasswordStatusHandler");
                    if (handler == null) {
                        return DebuggerCoreActivator.getInstance().createError(ErrorMessages.NoStatusHandlerStorageDispatcher_message);
                    }
                    Object result = handler.handleStatus(null, (Object)this);
                    if (!(result instanceof S32DebuggerSecureData)) break block12;
                    S32DebuggerSecureData payload = (S32DebuggerSecureData)result;
                    this.keyWord = payload.getKeyWord();
                    if (this.keyWord.isEmpty()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!payload.storeData()) break block12;
                    HashMap<String, String> configurationSettings = new HashMap<String, String>();
                    configurationSettings.put(SC_PASSWORD_STORAGE, this.keyWord);
                    if (dispatcher != null) {
                        dispatcher.storeProtectedSettings(configName, configurationSettings);
                        break block12;
                    }
                    return DebuggerCoreActivator.getInstance().createError(ErrorMessages.NoStorageDispatcher_message);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getSecureDebuggingKeyWord() {
        block7: {
            Map settings;
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            String configName = this.launch.getLaunchConfiguration().getName();
            if (dispatcher != null && (settings = dispatcher.getProtectedSettings(configName)) != null && settings.containsKey(KEY_STORAGE_KEYWORD)) {
                this.keyWord = (String)settings.get(KEY_STORAGE_KEYWORD);
            }
            if (this.keyWord.isEmpty()) {
                try {
                    RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.passwordEnterStatusHandler");
                    if (handler == null) {
                        return DebuggerCoreActivator.getInstance().createError(ErrorMessages.NoStatusHandlerStorageDispatcher_message);
                    }
                    Object result = handler.handleStatus(null, (Object)this);
                    if (!(result instanceof S32DebuggerSecureData)) break block7;
                    S32DebuggerSecureData secureData = (S32DebuggerSecureData)result;
                    this.keyWord = secureData.getKeyWord();
                    if (this.keyWord.isEmpty()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!secureData.storeData()) break block7;
                    HashMap<String, String> configurationSettings = new HashMap<String, String>();
                    configurationSettings.put(KEY_STORAGE_KEYWORD, this.keyWord);
                    if (dispatcher != null) {
                        dispatcher.storeProtectedSettings(configName, configurationSettings);
                        break block7;
                    }
                    return DebuggerCoreActivator.getInstance().createError(ErrorMessages.NoStorageDispatcher_message);
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected void cleanUp() {
        if (this.tracker != null) {
            this.tracker.dispose();
            this.tracker = null;
        }
    }

    public void shutdownOnError(String handlerId, IStatus status) {
        if (this.launch != null) {
            this.launch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
            if (status != null) {
                DebugPlugin.getDefault().asyncExec(() -> {
                    try {
                        RcpStatusHandlers.getStatusHandlerService().getStatusHandler(handlerId).handleStatus(status, (Object)this.launch);
                        RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchStatusHandler").handleStatus(status, (Object)this.launch);
                    }
                    catch (CoreException ex) {
                        DebuggerCoreActivator.getInstance().log(ex.getStatus());
                    }
                });
            }
        } else {
            this.getSession().getExecutor().shutdown();
        }
        this.cleanUp();
    }

    private static /* synthetic */ boolean lambda$0(String line) {
        return line.toLowerCase().contains(CARD_DISCONNECTED_MARKER);
    }
}

