/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.ui.xml.settings;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.LayoutSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.LayoutType;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.model.utils.EfuseXmlSettingsUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseButtonSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseTextSetting;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="struct", strict=false)
public class EfuseStructSetting
extends ABaseUIComponentSetting {
    @Attribute(name="fuse_word", required=false)
    private String parentFuseWordId;
    @Attribute(name="fuse_field", required=false)
    private String fuseFieldId;
    @Attribute(name="ecc_field", required=false)
    private boolean eccField;
    @Element(name="layout", required=false)
    private LayoutSetting layoutSetting;
    @ElementList(inline=true, required=false)
    private List<EfuseStructSetting> structSettings;
    @ElementList(inline=true, required=false)
    private List<EfuseBoolSetting> boolSettings;
    @ElementList(inline=true, required=false)
    private List<EfuseEnumSetting> enumSettings;
    @ElementList(inline=true, required=false)
    private List<EfuseIntegerSetting> integerSettings;
    @ElementList(inline=true, required=false)
    private List<EfuseBitsSetting> bitsSettings;
    @ElementList(inline=true, required=false)
    private List<EfuseButtonSetting> buttonSettings;
    @ElementList(inline=true, required=false)
    private List<ArraySetting> arraySettings;
    @ElementList(inline=true, required=false)
    private List<EfuseTextSetting> textSettings;
    @Attribute(name="showBinaryConfiguration", required=false)
    private boolean showBinaryConfiguration;

    public EfuseStructSetting() {
        this.parentFuseWordId = "";
        this.fuseFieldId = "";
        this.eccField = false;
        this.layoutSetting = new LayoutSetting();
        this.structSettings = new ArrayList<EfuseStructSetting>();
        this.boolSettings = new ArrayList<EfuseBoolSetting>();
        this.enumSettings = new ArrayList<EfuseEnumSetting>();
        this.integerSettings = new ArrayList<EfuseIntegerSetting>();
        this.bitsSettings = new ArrayList<EfuseBitsSetting>();
        this.buttonSettings = new ArrayList<EfuseButtonSetting>();
        this.arraySettings = new ArrayList<ArraySetting>();
        this.textSettings = new ArrayList<EfuseTextSetting>();
        this.showBinaryConfiguration = false;
    }

    public EfuseStructSetting(String id, EfuseStructSetting structSetting) {
        super(id, (ABaseUIComponentSetting)structSetting);
        this.parentFuseWordId = structSetting.parentFuseWordId;
        this.fuseFieldId = structSetting.fuseFieldId;
        this.eccField = structSetting.eccField;
        this.layoutSetting = structSetting.layoutSetting;
        this.structSettings = new ArrayList<EfuseStructSetting>(structSetting.structSettings);
        this.boolSettings = structSetting.boolSettings;
        this.enumSettings = new ArrayList<EfuseEnumSetting>();
        int i = 0;
        while (i < structSetting.enumSettings.size()) {
            EfuseEnumSetting enumS = new EfuseEnumSetting(structSetting.enumSettings.get(i), this);
            this.enumSettings.add(enumS);
            ++i;
        }
        this.integerSettings = new ArrayList<EfuseIntegerSetting>();
        i = 0;
        while (i < structSetting.integerSettings.size()) {
            EfuseIntegerSetting intS = new EfuseIntegerSetting(structSetting.integerSettings.get(i));
            this.integerSettings.add(intS);
            ++i;
        }
        this.bitsSettings = structSetting.bitsSettings;
        this.buttonSettings = structSetting.buttonSettings;
        this.arraySettings = structSetting.arraySettings;
        this.textSettings = structSetting.textSettings;
        this.showBinaryConfiguration = structSetting.showBinaryConfiguration;
    }

    public String getParentFuseWordID() {
        return this.parentFuseWordId;
    }

    public String getFuseFieldID() {
        return this.fuseFieldId;
    }

    public boolean isEccField() {
        return this.eccField;
    }

    public void setEccField(boolean eccField) {
        this.eccField = eccField;
    }

    public LayoutSetting getLayoutSetting() {
        return this.layoutSetting;
    }

    public List<EfuseStructSetting> getStructSettings() {
        return this.structSettings;
    }

    public @Nullable EfuseStructSetting getStructSettingById(String id) {
        return EfuseXmlSettingsUtils.getStructSettingById(this.structSettings, id);
    }

    public List<EfuseBoolSetting> getBoolSettings() {
        return this.boolSettings;
    }

    public @Nullable EfuseBoolSetting getBoolSettingById(String id) {
        return EfuseXmlSettingsUtils.getBoolSettingById(this.boolSettings, id);
    }

    public List<EfuseEnumSetting> getEnumSettings() {
        return this.enumSettings;
    }

    public @Nullable EfuseEnumSetting getEnumSettingById(String id) {
        return EfuseXmlSettingsUtils.getEnumSettingById(this.enumSettings, id);
    }

    public List<EfuseIntegerSetting> getIntegerSettings() {
        return this.integerSettings;
    }

    public @Nullable EfuseIntegerSetting getIntegerSettingById(String id) {
        return EfuseXmlSettingsUtils.getIntegerSettingById(this.integerSettings, id);
    }

    public List<EfuseBitsSetting> getBitsSettings() {
        return this.bitsSettings;
    }

    public @Nullable EfuseBitsSetting getBitsSettingById(String id) {
        return EfuseXmlSettingsUtils.getBitsSettingById(this.bitsSettings, id);
    }

    public List<EfuseButtonSetting> getButtonSettings() {
        return this.buttonSettings;
    }

    public @Nullable EfuseButtonSetting getButtonSettingById(String id) {
        for (EfuseButtonSetting setting : this.buttonSettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public List<ArraySetting> getArraySettings() {
        return this.arraySettings;
    }

    public @Nullable ArraySetting getArraySettingById(String id) {
        for (ArraySetting setting : this.arraySettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public List<EfuseTextSetting> getTextSettings() {
        return this.textSettings;
    }

    public @Nullable EfuseTextSetting getTextSettingById(String id) {
        for (EfuseTextSetting setting : this.textSettings) {
            if (!id.equalsIgnoreCase(setting.getId())) continue;
            return setting;
        }
        return null;
    }

    public LayoutType getLayoutType() {
        return this.layoutSetting.getType();
    }

    public List<ABaseUIComponentSetting> getChildrenComponents() {
        ArrayList<ABaseUIComponentSetting> scalarComponents = new ArrayList<ABaseUIComponentSetting>();
        this.structSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.boolSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.enumSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.integerSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.bitsSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.arraySettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        this.textSettings.forEach(setting -> {
            boolean bl = scalarComponents.add((ABaseUIComponentSetting)setting);
        });
        return scalarComponents;
    }

    public long getValueToWrite() {
        return -1L;
    }

    public boolean shouldShowBinaryConfiguration() {
        return this.showBinaryConfiguration;
    }
}

