/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.internal.ui.wizards.ExamplesActivator;
import com.nxp.s32ds.ext.ide.core.ExtendedActionDescriptor;
import com.nxp.s32ds.ext.ide.core.ExtendedActions;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ExampleWorkspaceModifyOperation
implements IRunnableWithProgress {
    private static final String PE_JOB_TITLE = "Open Processor Expert file";
    private static final String PROCESSOR_EXPERT_FILE = "ProcessorExpert.pe";
    private static final String UPDATE_SELECTION_JOB_TITLE = "Selecting project";
    private static final String EXAMPLE_ACTIONS_GROUP = "examples.actions";
    private List<IProject> projects;
    Collection<ExtendedActionDescriptor> actions;

    public ExampleWorkspaceModifyOperation(List<IProject> projects) {
        this.projects = projects;
        this.actions = ExtendedActions.getExtendedActionsByType((String)EXAMPLE_ACTIONS_GROUP);
    }

    public void run(final IProgressMonitor monitor) {
        for (final IProject project : this.projects) {
            UIJob openPeFile = new UIJob(PE_JOB_TITLE){

                public IStatus runInUIThread(IProgressMonitor ipm) {
                    IFile file;
                    if (ExampleWorkspaceModifyOperation.this.actions != null) {
                        ExampleWorkspaceModifyOperation.this.actions.stream().forEach(p -> {
                            IStatus iStatus = p.getExtendedActionExecutor().executeAfter(project, monitor);
                        });
                    }
                    if ((file = project.getFile(ExampleWorkspaceModifyOperation.PROCESSOR_EXPERT_FILE)) != null && file.exists()) {
                        try {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                        }
                        catch (PartInitException e) {
                            ExamplesActivator.getInstance().logError(e.getMessage());
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            openPeFile.schedule();
        }
        UIJob selectProject = new UIJob(UPDATE_SELECTION_JOB_TITLE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!ExampleWorkspaceModifyOperation.this.projects.isEmpty()) {
                    IProject projectToSelect = ExampleWorkspaceModifyOperation.this.projects.get(0);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    BasicNewResourceWizard.selectAndReveal((IResource)projectToSelect, (IWorkbenchWindow)window);
                }
                return Status.OK_STATUS;
            }
        };
        selectProject.schedule();
    }
}

