/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.imports;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkArchiveValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportSdkDialog
extends TitleAreaDialog {
    private static final String DEFAULT_DESTINATION_LOCATION = System.getProperty("user.home");
    private static final String FILLER = "   ";
    private static final String DATA_LABEL = "label";
    private static final String DATA_BUTTON = "button";
    private static final String[][] RADIO_BUTONS_LABEL_AND_VALUES = new String[][]{{Messages.ImportSdkDialog_label_import_from_zip_file, "A"}, {Messages.ImportSdkDialog_label_import_from_directory, "B"}};
    private Text sourceField;
    private Text destinationField;
    private RadioButtonsArea radio;
    private String source;
    private String destination;
    private int mode = 0;
    private String sdkName;
    private String oldZipName;
    private final String standardMessage;
    private volatile boolean fromZip = true;
    private String selectedZipDestination = "";
    private String selectedSourceDiretory = "";
    private SdkArchiveValidator sdkArchiveValidator;

    public ImportSdkDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.standardMessage = Messages.ImportSdkDialog_header_text;
        this.sdkArchiveValidator = new SdkArchiveValidator();
        this.source = "";
        this.destination = "";
        this.mode = 0;
        this.sdkName = "";
        this.oldZipName = "";
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportSdkDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)composite);
        this.radio = new RadioButtonsArea(composite, Messages.ImportSdkDialog_label_select_import_source, 3, RADIO_BUTONS_LABEL_AND_VALUES);
        GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).span(3, 1).applyTo((Control)this.radio);
        this.radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSdkDialog.this.toggle(ImportSdkDialog.this.radio.getSeletedIndex() == 0);
                ImportSdkDialog.this.updateButtonsState();
            }
        });
        this.radio.setSelectedButton(0);
        Label locationLabel = new Label(composite, 16384);
        locationLabel.setText(Messages.ImportSdkDialog_label_from_archive_file);
        locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sourceField = new Text(composite, 2060);
        this.sourceField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.SdkDialog_browse_button_text);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = ImportSdkDialog.this.selectArchive();
                if (location != null) {
                    ImportSdkDialog.this.sourceField.setText(location);
                }
                ImportSdkDialog.this.updateButtonsState();
            }
        });
        this.sourceField.setData(DATA_BUTTON, (Object)browseButton);
        this.sourceField.setData(DATA_LABEL, (Object)locationLabel);
        this.setButtonLayoutData(browseButton);
        Label destinationLabel = new Label(composite, 16384);
        destinationLabel.setText(String.valueOf(Messages.ImportSdkDialog_label_destination_into_directory) + FILLER);
        destinationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.destinationField = new Text(composite, 2060);
        this.destinationField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.destinationField.setText(DEFAULT_DESTINATION_LOCATION);
        this.selectedZipDestination = DEFAULT_DESTINATION_LOCATION;
        Button browse = new Button(composite, 8);
        browse.setText(Messages.SdkDialog_browse_button_text);
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = ImportSdkDialog.this.selectFolder();
                if (location != null) {
                    ImportSdkDialog.this.destinationField.setText(location);
                    if (ImportSdkDialog.this.fromZip) {
                        ImportSdkDialog.this.selectedZipDestination = location;
                    } else {
                        ImportSdkDialog.this.selectedSourceDiretory = location;
                    }
                }
                ImportSdkDialog.this.updateButtonsState();
            }
        });
        this.destinationField.setData(DATA_BUTTON, (Object)browse);
        this.destinationField.setData(DATA_LABEL, (Object)destinationLabel);
        this.setButtonLayoutData(browse);
        this.setTitle(Messages.ImportSdkDialog_title);
        this.setMessage(this.standardMessage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_import_context");
        return composite;
    }

    private void toggle(boolean isImportFromZipFile) {
        this.fromZip = isImportFromZipFile;
        if (this.sourceField != null) {
            this.sourceField.setVisible(isImportFromZipFile);
            ((Control)this.sourceField.getData(DATA_BUTTON)).setVisible(isImportFromZipFile);
            ((Control)this.sourceField.getData(DATA_LABEL)).setVisible(isImportFromZipFile);
            if (isImportFromZipFile) {
                ((Label)this.destinationField.getData(DATA_LABEL)).setText(Messages.ImportSdkDialog_label_destination_into_directory);
                this.setMessage(this.standardMessage);
                this.destinationField.setText(this.selectedZipDestination);
                this.selectedZipDestination = this.destinationField.getText();
            } else {
                ((Label)this.destinationField.getData(DATA_LABEL)).setText(Messages.ImportSdkDialog_label_destination_from_directory);
                this.destinationField.setText(this.selectedSourceDiretory);
                this.selectedSourceDiretory = this.destinationField.getText();
                this.setMessage(Messages.ImportSdkDialog_message_import_from_existing_directory);
            }
            this.setErrorMessage(null);
        }
    }

    private String selectArchive() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(Messages.ImportSdkDialog_archive_selection_dialog_title);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        return dialog.open();
    }

    private String selectFolder() {
        if (this.fromZip) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10002000);
            dialog.setText(Messages.SdkDialog_folder_selection_dialog_title);
            dialog.setMessage(Messages.SdkDialog_folder_selection_dialog_message);
            return dialog.open();
        }
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(Messages.ImportSdkDialog_structure_selection_dialog_title);
        dialog.setFilterNames(new String[]{"sources.xml"});
        dialog.setFilterExtensions(new String[]{"sources.xml"});
        String res = dialog.open();
        return res == null ? null : new File(res).getParent();
    }

    private void updateButtonsState() {
        if (this.radio.getSeletedIndex() == 0) {
            this.updateButtonsStateForImportFromArchive(this.getButton(0));
        } else {
            this.updateButtonsStateForImportFromFolder(this.getButton(0));
        }
    }

    private void updateButtonsStateForImportFromArchive(Button okButton) {
        boolean isOkButtonEnabled;
        String sourceText = this.sourceField.getText();
        String destText = this.destinationField.getText();
        IStatus validationStatus = Status.OK_STATUS;
        if (!sourceText.isEmpty() && !(validationStatus = this.sdkArchiveValidator.validate(sourceText)).isOK()) {
            this.setErrorMessage(validationStatus.getMessage());
        }
        boolean bl = isOkButtonEnabled = !sourceText.isEmpty() && !destText.isEmpty() && validationStatus.isOK();
        if (isOkButtonEnabled && !this.oldZipName.equals(sourceText)) {
            this.sdkName = ImportSdkDialog.getNameFromZip(sourceText);
            isOkButtonEnabled &= this.sdkName != null;
            this.oldZipName = sourceText;
        }
        okButton.setEnabled(isOkButtonEnabled);
        if (isOkButtonEnabled) {
            this.setErrorMessage(null);
        }
    }

    private void updateButtonsStateForImportFromFolder(Button okButton) {
        if (this.destinationField.getText().isEmpty()) {
            this.setMessage(Messages.SdkDialog_folder_selection_dialog_message);
            okButton.setEnabled(false);
            return;
        }
        boolean isOkButtonEnabled = false;
        File destinationFile = new File(this.destinationField.getText().trim());
        if (destinationFile.exists() && destinationFile.isDirectory()) {
            if ((destinationFile = new File(destinationFile, "sources.xml")).exists() && destinationFile.isFile() && destinationFile.canRead()) {
                if (destinationFile.length() == 0L) {
                    this.setErrorMessage(NLS.bind((String)Messages.ImportSdkDialog_error_descriptor_structure, (Object)destinationFile.getAbsolutePath()));
                } else {
                    isOkButtonEnabled = true;
                }
            } else {
                this.setMessage(NLS.bind((String)Messages.ImportSdkDialog_error_missing_descriptor, (Object)"sources.xml", (Object)destinationFile.getParent()));
            }
        } else {
            this.setMessage(NLS.bind((String)Messages.ImportSdkDialog_error_selection_is_not_directory, (Object)destinationFile.toString()));
        }
        okButton.setEnabled(isOkButtonEnabled);
        if (isOkButtonEnabled) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
    }

    public void create() {
        super.create();
        this.updateButtonsState();
    }

    protected void okPressed() {
        this.source = this.sourceField.getText();
        this.destination = this.destinationField.getText();
        this.mode = this.radio.getSeletedIndex();
        super.okPressed();
    }

    public String getArchiveSourceLocation() {
        return this.source;
    }

    public boolean isImportFromArchive() {
        return this.mode == 0;
    }

    public boolean isImportFromFolder() {
        return this.mode == 1;
    }

    public String getSourceFolderLocation() {
        return this.destination;
    }

    public String getArchiveExtractionDestinationFolder() {
        int cnt = 0;
        String result = String.valueOf(this.destination) + File.separatorChar + this.sdkName + File.separatorChar;
        while (new File(result).exists()) {
            result = String.valueOf(this.destination) + File.separatorChar + this.sdkName + cnt++ + File.separatorChar;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getNameFromZip(String archive) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ByteArrayInputStream bais;
                block18: {
                    Enumeration<? extends ZipEntry> e;
                    ZipFile zipFile;
                    block17: {
                        zipFile = new ZipFile(archive);
                        e = zipFile.entries();
                        finally {
                            if (e.hasMoreElements()) break block17;
                            return null;
                        }
                    }
                    ZipEntry zipEntry = e.nextElement();
                    if (!"sources.xml".equals(zipEntry.getName())) {
                    }
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try {
                        String string;
                        bais = new ByteArrayInputStream(SdkManagementUtils.getSdksManifestXml((InputStream)zipFile.getInputStream(zipEntry)).getBytes(StandardCharsets.UTF_8));
                        try {
                            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                            NodeList nodeList = parser.parse(bais).getDocumentElement().getElementsByTagName("sdk");
                            if (nodeList.getLength() <= 0) break block18;
                            string = ((Element)nodeList.item(0)).getAttribute("name");
                            if (bais == null) return string;
                        }
                        catch (Throwable throwable3) {
                            if (bais == null) throw throwable3;
                            bais.close();
                            throw throwable3;
                        }
                        bais.close();
                        return string;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Exception e) {
            SdkUiActivator.getInstance().logError(Messages.ImportSdkDialog_exception, e);
        }
        return null;
    }
}

