/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkTableViewerHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DetachUnavailableSdksDialog
extends TitleAreaDialog {
    private TableViewer tableViewer;
    private IProject project;
    private Collection<SdkDescriptor> sdksToBeDetached;

    public DetachUnavailableSdksDialog(Shell parentShell, Collection<SdkDescriptor> unavailableSdks, IProject project) {
        super(parentShell);
        this.project = project;
        this.sdksToBeDetached = Objects.requireNonNull(unavailableSdks).stream().sorted(SdkManagementUtils.getSdksComparator()).collect(Collectors.toList());
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.DetachUnavailableSdksDialog_title);
        this.setMessage(NLS.bind((String)Messages.DetachUnavailableSdksDialog_message, (Object)this.project.getName()));
        Composite body = new Composite(content, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().applyTo((Control)body);
        SdkTableViewerHolder list = SdkTableViewerHolder.newSdkList(body);
        this.tableViewer = list.getTableViewer();
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 150;
        data.heightHint = 150;
        body.setLayoutData((Object)data);
        this.tableViewer.setInput(this.sdksToBeDetached);
        this.setHelpAvailable(false);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DetachUnavailableSdksDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    public Collection<SdkDescriptor> getSdksToBeDetached() {
        return this.sdksToBeDetached;
    }
}

