/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModule;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModulesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResourcesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.info.SdkResourceInfoDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractSdkResourceControl {
    protected static final Image SELECTED_DISABLED_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
    protected static final Image SELECTED_ENABLED_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    protected static final Image WARNING_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image FILE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final int SELECT_ALL_MENUITEM_ID = 1;
    protected static final int SELECT_NONE_MENUITEM_ID = 2;
    private static final int COPY_ALL_MENUITEM_ID = 3;
    private static final int COPY_NONE_MENUITEM_ID = 4;
    private static final String TREE_KEY = "TREE_";
    private static final String PANTOM_SDK_ID = "sdk_id";
    protected boolean isEditable;
    protected TreeViewer viewer;
    protected Map<String, List<SdkResourcesHolder>> checkedStore;
    protected ResourceSdkGroup resourceType;
    private PathMatcher matcher;
    private boolean selectSiblings;
    private String suffix;
    private Map<String, ToolChainHolder> toolChainHolders;
    private Map<String, List<File>> resourcesMap = new LinkedHashMap<String, List<File>>();
    private Set<SdkResourceDataHolder> resourcesToCopy = new LinkedHashSet<SdkResourceDataHolder>();
    protected Set<SdkResourceDataHolder> selectedFiles = new LinkedHashSet<SdkResourceDataHolder>();
    protected Set<SdkResourceDataHolder> selectedFolders = new LinkedHashSet<SdkResourceDataHolder>();
    protected SdkResourceDataHolder rootPathDataHolder;
    private SdkResource selectedResource;

    protected AbstractSdkResourceControl(Composite parent, PathMatcher matcher, boolean isEditable, boolean selectSiblings, String suffix, Map<String, ToolChainHolder> toolChainHolders) {
        this.isEditable = isEditable;
        this.selectSiblings = selectSiblings;
        this.matcher = matcher;
        this.suffix = suffix;
        this.toolChainHolders = toolChainHolders;
        this.viewer = new TreeViewer(parent, 68096);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)this.getSourceTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.addListeners();
        if (isEditable) {
            this.viewer.getTree().setMenu(this.getMenu(this.viewer.getTree()));
        }
        this.addNameColumn();
        this.addExtraColumns();
    }

    private void addListeners() {
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                AbstractSdkResourceControl.this.saveTreeItemState(event.getElement(), true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                AbstractSdkResourceControl.this.saveTreeItemState(event.getElement(), false);
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            Object firstElement;
            this.selectedResource = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof SdkResourceDataHolder) {
                this.selectedResource = ((SdkResourceDataHolder)firstElement).getResource();
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                ResourceSdkDescriptor resource;
                if (event.keyCode == 105 && (event.stateMask & 0x40000) != 0 && AbstractSdkResourceControl.this.selectedResource != null && (resource = AbstractSdkResourceControl.this.selectedResource.getResourceSdkDescriptor(AbstractSdkResourceControl.this.rootPathDataHolder.getSdkId())) != null) {
                    new SdkResourceInfoDialog(Display.getCurrent().getActiveShell(), resource).open();
                }
            }
        });
    }

    private void addNameColumn() {
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(300);
        nameColumn.setLabelProvider((CellLabelProvider)new NameColumnLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)nameColumn.getViewer());
    }

    protected ITreeContentProvider getSourceTreeContentProvider() {
        return new SourcesTreeContentProvider();
    }

    protected EditingSupport getSelectColumnEditingSupport() {
        return new SelectColumnEditingSupport((ColumnViewer)this.viewer);
    }

    protected CellLabelProvider getSelectColumnLabelProvider() {
        return new SelectColumnLabelProvider();
    }

    protected void addExtraColumns() {
        if (this.isEditable) {
            TreeViewerColumn selectColumn = new TreeViewerColumn(this.viewer, 0);
            selectColumn.getColumn().setText(Messages.SdKEditDialogAbstractSdkResourceControl_label_select_column);
            selectColumn.getColumn().setWidth(50);
            selectColumn.setLabelProvider(this.getSelectColumnLabelProvider());
            selectColumn.setEditingSupport(this.getSelectColumnEditingSupport());
            TreeViewerColumn copyColumn = new TreeViewerColumn(this.viewer, 0);
            copyColumn.getColumn().setText(Messages.SdKEditDialogAbstractSdkResourceControl_label_copy_column);
            copyColumn.getColumn().setWidth(50);
            copyColumn.setLabelProvider((CellLabelProvider)new CopyColumnLabelProvider());
            copyColumn.setEditingSupport((EditingSupport)new CopyColumnEditingSupport((ColumnViewer)this.viewer));
        } else if (this.toolChainHolders == null || this.toolChainHolders.isEmpty()) {
            TreeViewerColumn c = new TreeViewerColumn(this.viewer, 0);
            c.getColumn().setText(Messages.SdKEditDialogAbstractSdkResourceControl_label_copy_column);
            c.getColumn().setToolTipText(Messages.SdKEditDialogAbstractSdkResourceControl_tooltip_columns);
            c.setLabelProvider((CellLabelProvider)new CopyColumnLabelProvider());
            c.getColumn().pack();
        } else {
            for (Map.Entry<String, ToolChainHolder> e : this.toolChainHolders.entrySet()) {
                TreeViewerColumn c = new TreeViewerColumn(this.viewer, 0);
                ToolChainHolder toolChainHolder = e.getValue();
                c.getColumn().setText(toolChainHolder.getTCAlias());
                c.getColumn().setToolTipText(Messages.SdKEditDialogAbstractSdkResourceControl_tooltip_columns);
                c.setLabelProvider((CellLabelProvider)new MultiColumnLabelProvider(toolChainHolder.getTCId()));
                c.getColumn().pack();
            }
        }
    }

    protected Menu getMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        this.addItem(menu, tree, Messages.AbstractSdkResourceControl_menu_item_select_all_label, 1);
        this.addItem(menu, tree, Messages.AbstractSdkResourceControl_menu_item_select_none_label, 2);
        new MenuItem(menu, 2);
        this.addItem(menu, tree, Messages.AbstractSdkResourceControl_menu_item_copy_all_label, 3);
        this.addItem(menu, tree, Messages.AbstractSdkResourceControl_menu_item_copy_none_label, 4);
        return menu;
    }

    protected void addItem(Menu menu, final Tree tree, String menuItemLabel, final int menuItemId) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(menuItemLabel);
        menuItem.setID(menuItemId);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSdkResourceControl.this.switchSelection(tree, menuItemId);
                AbstractSdkResourceControl.this.viewer.refresh();
            }
        });
    }

    protected void switchSelection(Tree tree, int id) {
        switch (id) {
            case 1: {
                this.selectAll(tree);
                break;
            }
            case 2: {
                this.selectedFiles.clear();
                this.selectedFolders.clear();
                this.resourcesToCopy.clear();
                break;
            }
            case 3: {
                this.copyAll(tree);
                break;
            }
            case 4: {
                this.resourcesToCopy.clear();
            }
        }
    }

    private void saveTreeItemState(Object key, boolean state) {
        String keyString = null;
        if (key instanceof SdkDataHolder) {
            keyString = this.rootPathDataHolder.getPath().toOSString();
        } else if (key instanceof ModuleResources) {
            keyString = ((ModuleResources)key).getModuleName();
        } else if (key instanceof SdkResource) {
            keyString = ((SdkResource)key).getPath().toOSString();
        }
        if (keyString != null) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
            prefs.put(TREE_KEY + this.suffix + '_' + keyString, Boolean.toString(state));
            try {
                prefs.flush();
            }
            catch (BackingStoreException bse) {
                SdkUiActivator.getInstance().logError("Unable to save tree item state due error.", bse);
            }
        }
    }

    private boolean getTreeItemState(Object key) {
        String keyString = null;
        if (key instanceof SdkDataHolder) {
            keyString = this.rootPathDataHolder.getPath().toOSString();
        } else if (key instanceof ModuleResources) {
            keyString = ((ModuleResources)key).getModuleName();
        } else if (key instanceof SdkResource) {
            keyString = ((SdkResource)key).getPath().toOSString();
        }
        if (keyString != null) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
            return prefs.getBoolean(TREE_KEY + this.suffix + '_' + keyString, true);
        }
        return false;
    }

    public void setInput(InputWrapper inputWrapper, boolean isCreateMode, boolean isExpand) {
        this.initSdkDataHolderRoot(inputWrapper);
        if (!isCreateMode) {
            this.initCheckedStore(inputWrapper);
            this.initInternalData();
        } else {
            this.resourcesMap = this.retrieveResources(this.rootPathDataHolder.getPath().toOSString(), this.matcher);
        }
        this.viewer.setInput((Object)inputWrapper);
        if (isExpand) {
            this.viewer.expandAll();
            this.restore(this.viewer.getTree().getItems());
        }
    }

    private void initCheckedStore(InputWrapper inputWrapper) {
        SdkDataHolder sdkDataHolder = inputWrapper.get();
        ModelSdk sdk = sdkDataHolder.getSdk();
        if (sdk != null) {
            Collection<String> completedSdkPaths = AbstractSdkResourceControl.getCompletedSdkPaths(sdkDataHolder);
            if (!completedSdkPaths.isEmpty()) {
                this.checkedStore = sdk.getResources(this.resourceType, "all_toolchains");
                this.resourcesMap = this.retrieveResources(completedSdkPaths, this.matcher);
            } else {
                this.checkedStore = Collections.emptyMap();
            }
        } else {
            this.checkedStore = Collections.emptyMap();
        }
    }

    private static Collection<String> getCompletedSdkPaths(SdkDataHolder sdkDataHolder) {
        ArrayList<String> completedSdkPaths = new ArrayList<String>();
        Set<SdkModule> refModules = sdkDataHolder.getModulesHolder();
        if (refModules.isEmpty()) {
            String completedSdkPath = SdkManagementUtils.performStringSubstitution((String)sdkDataHolder.getRootPath(), null);
            if (!sdkDataHolder.getSdk().getHeader().getBasePath().equals(sdkDataHolder.getRootPath())) {
                sdkDataHolder.getSdk().getHeader().setBasePath(sdkDataHolder.getRootPath());
            }
            if (completedSdkPath != null) {
                completedSdkPaths.add(completedSdkPath);
            }
        } else {
            refModules.stream().map(SdkModule::getSdk).filter(Objects::nonNull).map(refSdk -> refSdk.getHeader().getBasePath()).forEach(completedSdkPaths::add);
        }
        return completedSdkPaths;
    }

    private void initSdkDataHolderRoot(InputWrapper inputWrapper) {
        SdkDataHolder sdkDataHolder = inputWrapper.get();
        String sdkRootToolChainId = null;
        ModelSdk sdk = sdkDataHolder.getSdk();
        if (sdk != null) {
            sdkRootToolChainId = sdk.getRoot().getTCId();
        }
        this.rootPathDataHolder = new SdkResourceDataHolder(this.getResource(ExtendedPath.fromOSString(sdkDataHolder.getRootPath(), true)), sdkDataHolder.getSdkId(), sdkRootToolChainId);
    }

    private void initInternalData() {
        this.selectedFolders.clear();
        this.selectedFiles.clear();
        this.resourcesToCopy.clear();
        for (Map.Entry<String, List<SdkResourcesHolder>> e : this.checkedStore.entrySet()) {
            String sdkId = e.getKey();
            for (SdkResourcesHolder resourcesHolder : e.getValue()) {
                String toolChainId = resourcesHolder.getToolChainId();
                List<SdkResource> allResources = resourcesHolder.getAllResources();
                for (SdkResource resource : allResources) {
                    this.handleResource(resource, sdkId, toolChainId);
                }
            }
        }
    }

    private void handleResource(SdkResource resource, String sdkId, String toolChainId) {
        File f;
        SdkResourceDataHolder resourceDataHolder = new SdkResourceDataHolder(resource, sdkId, toolChainId);
        ExtendedPath path = resourceDataHolder.getPath();
        if (path.isCopy()) {
            this.resourcesToCopy.add(resourceDataHolder);
        }
        if ((f = path.toFile()).isDirectory()) {
            this.selectedFolders.add(resourceDataHolder);
        } else if (f.isFile()) {
            ExtendedPath parent = AbstractSdkResourceControl.getParent(path);
            this.selectedFolders.add(new SdkResourceDataHolder(this.getResource(parent), sdkId, toolChainId));
            if (this.selectSiblings) {
                this.selectSiblingResources(parent, sdkId, toolChainId);
            } else {
                this.addSelectedFile(resourceDataHolder);
            }
        }
    }

    private void selectSiblingResources(ExtendedPath parent, String sdkId, String toolChainId) {
        for (ExtendedPath matchedChildPath : this.getMatchedChildrenPath(parent.toOSString())) {
            SdkResourceDataHolder childResourceDataHolder = new SdkResourceDataHolder(this.getResource(matchedChildPath), sdkId, toolChainId);
            if (childResourceDataHolder.isDirectory()) {
                this.selectedFolders.add(childResourceDataHolder);
                continue;
            }
            this.addSelectedFile(childResourceDataHolder);
        }
    }

    private void restore(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            it.setExpanded(this.getTreeItemState(it.getData()));
            this.restore(it.getItems());
            ++n2;
        }
    }

    private static ExtendedPath getParent(ExtendedPath p) {
        return ExtendedPath.fromOSString(p.removeLastSegments(1).toOSString(), true);
    }

    public Map<String, Set<SdkResource>> getChecked() {
        if (!this.isEditable) {
            throw new IllegalAccessError("Bad access !");
        }
        LinkedHashSet selectedResources = new LinkedHashSet();
        this.selectedFolders.stream().map(SdkResourceDataHolder::getResource).forEach(selectedResources::add);
        this.selectedFiles.stream().map(SdkResourceDataHolder::getResource).forEach(selectedResources::add);
        Set copiedResources = this.resourcesToCopy.stream().map(SdkResourceDataHolder::getResource).collect(Collectors.toSet());
        selectedResources.forEach(resource -> resource.getPath().setCopy(copiedResources.stream().anyMatch(copiedResource -> resource.getPath().equals((Object)copiedResource.getPath()))));
        LinkedHashMap<String, Set<SdkResource>> checkedResources = new LinkedHashMap<String, Set<SdkResource>>();
        checkedResources.put(null, selectedResources);
        return checkedResources;
    }

    public void clearSelected() {
        this.selectedFiles.clear();
        this.selectedFolders.clear();
    }

    private void copyAll(Tree tree) {
        if (this.selectedFiles.isEmpty()) {
            return;
        }
        this.resourcesToCopy.clear();
        this.viewer.expandAll();
        this.copyItems(tree.getItems());
    }

    private void copyItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            SdkResourceDataHolder resourceDataHolder;
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof SdkResourceDataHolder && this.isFileSelected(resourceDataHolder = (SdkResourceDataHolder)data)) {
                this.resourcesToCopy.add(resourceDataHolder);
            }
            this.copyItems(treeItem.getItems());
            ++n2;
        }
    }

    private void selectAll(Tree tree) {
        this.selectedFiles.clear();
        this.viewer.expandAll();
        this.selectItems(tree.getItems());
    }

    private void selectItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            SdkResourceDataHolder resourceDataHolder = null;
            if (data instanceof SdkDataHolder) {
                resourceDataHolder = this.rootPathDataHolder;
            } else if (data instanceof SdkResourceDataHolder) {
                resourceDataHolder = (SdkResourceDataHolder)data;
            }
            if (resourceDataHolder != null) {
                if (resourceDataHolder.isDirectory()) {
                    this.selectedFolders.add(resourceDataHolder);
                } else {
                    this.addSelectedFile(resourceDataHolder);
                }
            }
            this.selectItems(treeItem.getItems());
            ++n2;
        }
    }

    private void addSelectedFile(SdkResourceDataHolder resource) {
        this.selectedFiles.add(resource);
    }

    private boolean isResourceCopied(SdkResourceDataHolder resourceDataHolder) {
        return this.resourcesToCopy.contains(resourceDataHolder);
    }

    protected boolean isFileSelected(SdkResourceDataHolder resourceDataHolder) {
        return this.selectedFiles.contains(resourceDataHolder);
    }

    protected boolean isFolderSelected(SdkResourceDataHolder resourceDataHolder) {
        return this.selectedFolders.contains(resourceDataHolder);
    }

    protected SdkResourceDataHolder getResourceDataHolder(ExtendedPath path, String sdkId, String toolChainId) {
        return new SdkResourceDataHolder(this.getResource(path), sdkId, toolChainId);
    }

    protected SdkResource getResource(ExtendedPath path) {
        return null;
    }

    protected boolean isDirectorySelectable(SdkResourceDataHolder directory) {
        return !this.getMatchedChildrenPath(directory.getPath().toOSString()).isEmpty();
    }

    protected List<SdkResourceDataHolder> getMatchedSelectableFolders(SdkResourceDataHolder parentPathResource) {
        return Collections.emptyList();
    }

    public static InputWrapper wrap(SdkDataHolder input) {
        return () -> input;
    }

    private Map<String, List<File>> retrieveResources(String completedSdkPath, PathMatcher pathMatcher) {
        return this.retrieveResources(Collections.singletonList(completedSdkPath), pathMatcher);
    }

    private Map<String, List<File>> retrieveResources(Collection<String> completedSdkPaths, final PathMatcher pathMatcher) {
        final LinkedHashMap<String, List<File>> resultMap = new LinkedHashMap<String, List<File>>();
        for (String completedSdkPath : completedSdkPaths) {
            final Path startPath = Paths.get(completedSdkPath, new String[0]).normalize();
            try {
                Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes ba) throws IOException {
                        if (this.isPathSelected(path) && (pathMatcher.matches(path.getFileName()) || pathMatcher.matches(path))) {
                            this.updateResourcesMap(path);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    private void updateResourcesMap(Path path) {
                        Path parentPath;
                        Path childPath = parentPath = path.getParent();
                        Path superParent = parentPath.getParent();
                        while (!superParent.equals(startPath.getParent())) {
                            resultMap.computeIfAbsent(superParent.toString(), s -> new ArrayList()).add(childPath.toFile());
                            childPath = superParent;
                            superParent = superParent.getParent();
                        }
                        String parentPathString = parentPath.toString();
                        resultMap.computeIfAbsent(parentPathString, s -> new ArrayList()).add(path.toFile());
                    }

                    private boolean isPathSelected(Path pathToCheck) {
                        return AbstractSdkResourceControl.this.isEditable || AbstractSdkResourceControl.this.checkedStore.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).flatMap(resourceHolder -> resourceHolder.getResourceByType(AbstractSdkResourceControl.this.resourceType).stream()).map(resource -> resource.getPath().toOSString()).anyMatch(resourcePath -> pathToCheck.toString().equals(resourcePath));
                    }
                });
            }
            catch (IOException ioe) {
                SdkUiActivator.getInstance().logError(NLS.bind((String)"Fail resources retrieval on path {0}", (Object)startPath), ioe);
            }
        }
        return resultMap;
    }

    private Collection<ExtendedPath> getMatchedChildrenPath(String parentPath) {
        Collection matchedFiles = this.resourcesMap.getOrDefault(parentPath, Collections.emptyList());
        return matchedFiles.stream().map(file -> ExtendedPath.fromOSString(file.getPath(), file.isDirectory())).collect(Collectors.toList());
    }

    protected ModuleResources getModuleResources(String refModuleName, ModelSdk refSdk) {
        String refSdkId = refSdk.getHeader().getId();
        SdkResourceDataHolder refSdkFolder = new SdkResourceDataHolder(this.getResource(ExtendedPath.fromOSString(refSdk.getHeader().getBasePath(), true)), refSdkId, null);
        ArrayList<SdkResourceDataHolder> refSdkResources = new ArrayList<SdkResourceDataHolder>();
        refSdk.getRoot().getResourceByType(this.resourceType).stream().map(r -> new SdkResourceDataHolder((SdkResource)r, refSdkId, null)).forEach(refSdkResources::add);
        return new ModuleResources(refModuleName, refSdkFolder, refSdkResources);
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    class CopyColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public CopyColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (!AbstractSdkResourceControl.this.isEditable) {
                return false;
            }
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                return !resourceDataHolder.isDirectory() && AbstractSdkResourceControl.this.isFileSelected(resourceDataHolder);
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof SdkResourceDataHolder && AbstractSdkResourceControl.this.isResourceCopied((SdkResourceDataHolder)element)) {
                return true;
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                boolean copy = (Boolean)value;
                if (copy) {
                    AbstractSdkResourceControl.this.resourcesToCopy.add(resourceDataHolder);
                } else {
                    AbstractSdkResourceControl.this.resourcesToCopy.remove(resourceDataHolder);
                }
            }
            this.getViewer().refresh();
        }
    }

    class CopyColumnLabelProvider
    extends CellLabelProvider {
        CopyColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof SdkResourceDataHolder) {
                cell.setImage(this.getImage((SdkResourceDataHolder)element));
            }
        }

        private Image getImage(SdkResourceDataHolder resourceDataHolder) {
            boolean isFileSelected;
            boolean bl = isFileSelected = !resourceDataHolder.isDirectory() && AbstractSdkResourceControl.this.isFileSelected(resourceDataHolder);
            if (AbstractSdkResourceControl.this.isResourceCopied(resourceDataHolder)) {
                return isFileSelected ? SELECTED_ENABLED_IMAGE : SELECTED_DISABLED_IMAGE;
            }
            return isFileSelected ? SELECTED_DISABLED_IMAGE : null;
        }
    }

    public static interface InputWrapper {
        public SdkDataHolder get();
    }

    protected class ModuleResources {
        private String moduleName;
        private SdkResourceDataHolder rootPath;
        private List<SdkResourceDataHolder> resources;

        protected ModuleResources(String moduleName, SdkResourceDataHolder rootPath, List<SdkResourceDataHolder> resources) {
            this.moduleName = moduleName;
            this.rootPath = rootPath;
            this.resources = resources;
        }

        protected String getModuleName() {
            return this.moduleName;
        }

        protected SdkResourceDataHolder getRootPathResource() {
            return this.rootPath;
        }

        protected List<SdkResourceDataHolder> getResources() {
            return this.resources != null ? this.resources : Collections.emptyList();
        }

        protected boolean containsResource(SdkResourceDataHolder resourceDataHolder) {
            return this.getResources().contains(resourceDataHolder);
        }

        protected boolean containsResourceWithPath(ExtendedPath path) {
            return this.getResources().stream().anyMatch(rdh -> rdh.getPath().equals((Object)path));
        }
    }

    class MultiColumnLabelProvider
    extends CellLabelProvider {
        private String toolChainId;

        public MultiColumnLabelProvider(String toolChainId) {
            this.toolChainId = toolChainId;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resource = (SdkResourceDataHolder)element;
                ToolChainHolder toolChainHolder = AbstractSdkResourceControl.this.toolChainHolders.get(this.toolChainId);
                boolean isResourceCopied = this.isResourceCopied(resource, toolChainHolder, resource.getSdkId());
                boolean isResourceSelected = this.isResourceSelected(resource, toolChainHolder, resource.getSdkId());
                boolean isCellEditable = !resource.isDirectory() && isResourceSelected;
                cell.setImage(this.getImage(isResourceCopied, isCellEditable));
            }
        }

        private boolean isResourceCopied(SdkResourceDataHolder resource, ToolChainHolder toolChainHolder, String sdkId) {
            return this.isResourceMarked(resource, toolChainHolder, sdkId, AbstractSdkResourceControl.this.resourcesToCopy);
        }

        private boolean isResourceSelected(SdkResourceDataHolder resource, ToolChainHolder toolChainHolder, String sdkId) {
            return this.isResourceMarked(resource, toolChainHolder, sdkId, AbstractSdkResourceControl.this.selectedFiles);
        }

        private boolean isResourceMarked(SdkResourceDataHolder resource, ToolChainHolder toolChainHolder, String sdkId, Set<SdkResourceDataHolder> resources) {
            return resources.stream().anyMatch(rdh -> rdh.isMatched(resource.getResource(), sdkId, toolChainHolder == null || rdh.getToolChainId() == null ? null : toolChainHolder.getTCId()));
        }

        private Image getImage(boolean isResourceCopied, boolean isCellEditable) {
            if (isResourceCopied) {
                return isCellEditable ? SELECTED_ENABLED_IMAGE : SELECTED_DISABLED_IMAGE;
            }
            return isCellEditable ? SELECTED_DISABLED_IMAGE : null;
        }
    }

    class NameColumnLabelProvider
    extends ColumnLabelProvider {
        NameColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!this.isResourcePathDuplicated(element)) {
                if (element instanceof SdkDataHolder || element instanceof ModuleResources) {
                    return FOLDER_IMAGE;
                }
                if (element instanceof SdkResourceDataHolder) {
                    return ((SdkResourceDataHolder)element).isDirectory() ? FOLDER_IMAGE : FILE_IMAGE;
                }
            } else {
                return WARNING_IMAGE;
            }
            return super.getImage(element);
        }

        public String getToolTipText(Object element) {
            return this.isResourcePathDuplicated(element) ? Messages.SdKEditDialogAbstractSdkResourceControl_tooltip_duplicated_resource : super.getToolTipText(element);
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public String getText(Object element) {
            if (element instanceof SdkDataHolder) {
                ExtendedPath rootPath = AbstractSdkResourceControl.this.rootPathDataHolder.getPath();
                String sdkFolderName = rootPath.lastSegment();
                return sdkFolderName != null ? sdkFolderName : rootPath.toOSString();
            }
            if (element instanceof ModuleResources) {
                return ((ModuleResources)element).getModuleName();
            }
            if (element instanceof SdkResourceDataHolder) {
                return ((SdkResourceDataHolder)element).getPath().lastSegment();
            }
            return super.getText(element);
        }

        private boolean isResourcePathDuplicated(Object element) {
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resource = (SdkResourceDataHolder)element;
                if (!AbstractSdkResourceControl.this.isFileSelected(resource)) {
                    return false;
                }
                ModelSdk sdk = ((InputWrapper)AbstractSdkResourceControl.this.getInput()).get().getSdk();
                if (sdk == null) {
                    return false;
                }
                SdkModulesHolder modulesHolder = sdk.getModules();
                int resourceCounter = 0;
                for (SdkModule refModule : modulesHolder.getRefModules()) {
                    ModelSdk refSdk = refModule.getSdk();
                    if (refSdk != null && AbstractSdkResourceControl.this.getModuleResources(refModule.getName(), refSdk).containsResourceWithPath(resource.getPath())) {
                        ++resourceCounter;
                    }
                    if (resourceCounter <= true) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class SdkDataHolder {
        private String rootPath;
        private ModelSdk sdk;

        public SdkDataHolder(ModelSdk sdk, String rootPath) {
            this.sdk = sdk;
            this.rootPath = Objects.requireNonNull(rootPath);
        }

        String getRootPath() {
            return this.rootPath;
        }

        ModelSdk getSdk() {
            return this.sdk;
        }

        String getSdkId() {
            return this.sdk != null ? this.sdk.getHeader().getId() : AbstractSdkResourceControl.PANTOM_SDK_ID;
        }

        Set<SdkModule> getModulesHolder() {
            if (this.sdk != null) {
                SdkModulesHolder modulesHolder = this.sdk.getModules();
                return modulesHolder != null ? modulesHolder.getRefModules() : Collections.emptySet();
            }
            return Collections.emptySet();
        }
    }

    class SdkResourceDataHolder {
        private SdkResource resource;
        private String sdkId;
        private String toolChainId;

        protected SdkResourceDataHolder(SdkResource resource, String sdkId, String toolChainId) {
            this.resource = resource;
            this.sdkId = sdkId;
            this.toolChainId = toolChainId;
        }

        protected SdkResource getResource() {
            return this.resource;
        }

        protected String getSdkId() {
            return this.sdkId;
        }

        protected String getToolChainId() {
            return this.toolChainId;
        }

        private boolean isMatched(SdkResource resourceToMatch, String sdkIdToMatch, String toolChainIdToMatch) {
            if (!this.resource.getPath().equals((Object)resourceToMatch.getPath())) {
                return false;
            }
            if (!this.sdkId.equals(sdkIdToMatch)) {
                return false;
            }
            return this.toolChainId == null ? toolChainIdToMatch == null : this.toolChainId.equals(toolChainIdToMatch);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.resource == null ? 0 : this.resource.getPath().toOSString().hashCode());
            result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
            result = 31 * result + (this.toolChainId == null ? 0 : this.toolChainId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SdkResourceDataHolder)) {
                return false;
            }
            SdkResourceDataHolder other = (SdkResourceDataHolder)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.resource == null ? other.resource != null : !this.resource.getPath().toOSString().equals(other.getResource().getPath().toOSString())) {
                return false;
            }
            if (this.sdkId == null ? other.getSdkId() != null : !this.sdkId.equals(other.getSdkId())) {
                return false;
            }
            return !(this.toolChainId == null ? other.getToolChainId() != null : !this.toolChainId.equals(other.getToolChainId()));
        }

        protected ExtendedPath getPath() {
            return this.resource.getPath();
        }

        protected boolean isDirectory() {
            return this.resource.isDirectory();
        }

        private AbstractSdkResourceControl getOuterType() {
            return AbstractSdkResourceControl.this;
        }

        public String toString() {
            return this.getPath().toString() + " [" + this.sdkId + " | " + this.toolChainId + "]";
        }
    }

    class SelectColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public SelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (element instanceof SdkDataHolder) {
                return AbstractSdkResourceControl.this.isDirectorySelectable(AbstractSdkResourceControl.this.rootPathDataHolder);
            }
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                return resourceDataHolder.isDirectory() ? AbstractSdkResourceControl.this.isDirectorySelectable(resourceDataHolder) : !AbstractSdkResourceControl.this.selectSiblings;
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof SdkDataHolder) {
                return AbstractSdkResourceControl.this.isFolderSelected(AbstractSdkResourceControl.this.rootPathDataHolder);
            }
            if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                return resourceDataHolder.isDirectory() ? AbstractSdkResourceControl.this.isFolderSelected(resourceDataHolder) : AbstractSdkResourceControl.this.isFileSelected(resourceDataHolder);
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            boolean isSelected = (Boolean)value;
            if (element instanceof SdkDataHolder) {
                this.handleDirectorySelection(AbstractSdkResourceControl.this.rootPathDataHolder, isSelected);
            } else if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                if (resourceDataHolder.isDirectory()) {
                    this.handleDirectorySelection(resourceDataHolder, isSelected);
                } else {
                    this.handleFileSelection(resourceDataHolder, isSelected);
                }
            }
            this.getViewer().refresh();
        }

        protected void handleSubDirectoriesSelection(SdkResourceDataHolder resourceDataHolder, boolean isSelected) {
        }

        private void handleDirectorySelection(SdkResourceDataHolder resourceDataHolder, boolean isSelected) {
            if (isSelected) {
                AbstractSdkResourceControl.this.selectedFolders.add(resourceDataHolder);
            } else {
                AbstractSdkResourceControl.this.selectedFolders.remove(resourceDataHolder);
            }
            this.handleSubDirectoriesSelection(resourceDataHolder, isSelected);
            for (ExtendedPath matchedChildPath : AbstractSdkResourceControl.this.getMatchedChildrenPath(resourceDataHolder.getPath().toOSString())) {
                SdkResourceDataHolder matchedResourceDataHolder = AbstractSdkResourceControl.this.getResourceDataHolder(matchedChildPath, resourceDataHolder.getSdkId(), resourceDataHolder.getToolChainId());
                if (matchedResourceDataHolder.isDirectory()) {
                    if (isSelected) {
                        AbstractSdkResourceControl.this.selectedFolders.add(matchedResourceDataHolder);
                        continue;
                    }
                    AbstractSdkResourceControl.this.selectedFolders.remove(matchedResourceDataHolder);
                    continue;
                }
                this.handleFileSelection(matchedResourceDataHolder, isSelected);
            }
        }

        private void handleFileSelection(SdkResourceDataHolder resourceDataHolder, boolean isSelected) {
            if (isSelected) {
                AbstractSdkResourceControl.this.addSelectedFile(resourceDataHolder);
            } else {
                this.removeSelectedFile(resourceDataHolder);
            }
        }

        private void removeSelectedFile(SdkResourceDataHolder resourceDataHolder) {
            AbstractSdkResourceControl.this.selectedFiles.remove(resourceDataHolder);
        }
    }

    class SelectColumnLabelProvider
    extends CellLabelProvider {
        SelectColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            boolean isCellEditable = false;
            boolean isCellSelected = false;
            if (element instanceof SdkDataHolder) {
                isCellEditable = !AbstractSdkResourceControl.this.rootPathDataHolder.getPath().isEmpty() && AbstractSdkResourceControl.this.isDirectorySelectable(AbstractSdkResourceControl.this.rootPathDataHolder);
                isCellSelected = this.isRootDirectoryCellSelected(AbstractSdkResourceControl.this.rootPathDataHolder);
            } else if (element instanceof SdkResourceDataHolder) {
                SdkResourceDataHolder resourceDataHolder = (SdkResourceDataHolder)element;
                ExtendedPath path = resourceDataHolder.getPath();
                boolean bl = isCellEditable = !path.isEmpty();
                if (path.toFile().isDirectory()) {
                    isCellSelected = AbstractSdkResourceControl.this.isFolderSelected(resourceDataHolder);
                    isCellEditable &= AbstractSdkResourceControl.this.isDirectorySelectable(resourceDataHolder);
                } else {
                    isCellSelected = AbstractSdkResourceControl.this.isFileSelected(resourceDataHolder);
                }
            }
            cell.setImage(this.getImage(isCellSelected, isCellEditable));
        }

        protected boolean isRootDirectoryCellSelected(SdkResourceDataHolder resourceDataHolder) {
            return AbstractSdkResourceControl.this.isFolderSelected(resourceDataHolder) && !AbstractSdkResourceControl.this.selectedFiles.isEmpty();
        }

        private Image getImage(boolean isCellSelected, boolean isCellEditable) {
            if (isCellSelected) {
                return isCellEditable ? SELECTED_ENABLED_IMAGE : SELECTED_DISABLED_IMAGE;
            }
            return isCellEditable ? SELECTED_DISABLED_IMAGE : null;
        }
    }

    protected class SourcesTreeContentProvider
    implements ITreeContentProvider {
        protected SourcesTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof SdkResource) {
                ExtendedPath path = ((SdkResource)element).getPath();
                Path p = Paths.get(path.toOSString(), new String[0]);
                Path parent = p.getParent();
                return parent == null ? null : AbstractSdkResourceControl.this.getResource(ExtendedPath.fromOSString(parent.toFile().getAbsolutePath(), true));
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            Shell shell = AbstractSdkResourceControl.this.viewer.getControl().getShell();
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
            Object[] result = new Object[]{};
            if (parentElement instanceof InputWrapper) {
                result = new SdkDataHolder[]{((InputWrapper)parentElement).get()};
            } else if (parentElement instanceof SdkDataHolder) {
                result = this.getModulesResources((SdkDataHolder)parentElement);
            } else if (parentElement instanceof ModuleResources) {
                result = this.getMatchedModuleResources((ModuleResources)parentElement).toArray(new SdkResourceDataHolder[0]);
            } else if (parentElement instanceof SdkResourceDataHolder) {
                result = this.getMatchedChildResources((SdkResourceDataHolder)parentElement).toArray(new SdkResourceDataHolder[0]);
            }
            shell.setCursor(null);
            return result;
        }

        private Set<SdkResourceDataHolder> getMatchedModuleResources(ModuleResources moduleResources) {
            LinkedHashSet<SdkResourceDataHolder> result = new LinkedHashSet<SdkResourceDataHolder>();
            this.getMatchedChildResources(moduleResources.getRootPathResource()).stream().filter(resource -> resource.isDirectory() || moduleResources.containsResource((SdkResourceDataHolder)resource)).forEach(result::add);
            return result;
        }

        protected Object[] getModulesResources(SdkDataHolder sdkDataHolder) {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            Set<SdkModule> refModules = sdkDataHolder.getModulesHolder();
            if (refModules.isEmpty()) {
                result.addAll(this.getMatchedChildResources(AbstractSdkResourceControl.this.rootPathDataHolder));
            } else {
                for (SdkModule refModule : refModules) {
                    ModelSdk refSdk = refModule.getSdk();
                    if (refSdk == null) continue;
                    result.add(AbstractSdkResourceControl.this.getModuleResources(refModule.getName(), refSdk));
                }
            }
            return result.toArray();
        }

        protected Set<SdkResourceDataHolder> getMatchedChildResources(SdkResourceDataHolder parentDirectory) {
            LinkedHashSet<SdkResourceDataHolder> result = new LinkedHashSet<SdkResourceDataHolder>();
            if (AbstractSdkResourceControl.this.isEditable) {
                result.addAll(AbstractSdkResourceControl.this.getMatchedSelectableFolders(parentDirectory));
            }
            String sdkId = parentDirectory.getSdkId();
            String toolChainId = parentDirectory.getToolChainId();
            Collection matchedFiles = AbstractSdkResourceControl.this.resourcesMap.getOrDefault(parentDirectory.getPath().toOSString(), Collections.emptyList());
            matchedFiles.stream().map(file -> ExtendedPath.fromOSString(file.getPath(), file.isDirectory())).sorted(this.getResourceComparator()).map(path -> new SdkResourceDataHolder(AbstractSdkResourceControl.this.getResource((ExtendedPath)((Object)path)), sdkId, toolChainId)).forEach(result::add);
            return result;
        }

        private Comparator<? super ExtendedPath> getResourceComparator() {
            return (o1, o2) -> {
                File o1File = o1.toFile();
                File o2File = o2.toFile();
                if (o1File.isDirectory() ^ o2File.isDirectory()) {
                    return o1File.isDirectory() ? -1 : 1;
                }
                return o1File.getAbsolutePath().compareTo(o2File.getAbsolutePath());
            };
        }
    }
}

