/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.validation;

import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controller.validation.GtmProblemsManager;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.beans.PropertyChangeListener;
import java.util.Objects;

public class GtmValidationHandler {
    private PropertyChangeListener valueChangeListener = evt -> {
        Objects.requireNonNull(evt);
        if ("value".equalsIgnoreCase(evt.getPropertyName())) {
            assert (evt.getSource() instanceof GtmIntegerSetting) : Messages.ValidationAssertFailed;
            GtmIntegerSetting integerSetting = (GtmIntegerSetting)evt.getSource();
            if (!integerSetting.isDisabled()) {
                this.validateValue(integerSetting);
            }
        }
    };
    private PropertyChangeListener disableStateChangeListener = evt -> {
        Objects.requireNonNull(evt);
        if ("disable".equalsIgnoreCase(evt.getPropertyName())) {
            assert (evt.getSource() instanceof GtmIntegerSetting) : Messages.ValidationAssertFailed;
            GtmIntegerSetting integerSetting = (GtmIntegerSetting)evt.getSource();
            if (integerSetting.isDisabled()) {
                GtmController.getInstance().getProblemsManager().clearProblems((IProblemSource)integerSetting);
            } else {
                this.validateValue(integerSetting);
            }
        }
    };

    public void validateValue(GtmIntegerSetting integerSetting) {
        GtmProblem limitValueProblem;
        GtmProblem emptyValueProblem;
        GtmProblemsManager problemsManager = GtmController.getInstance().getProblemsManager();
        problemsManager.clearProblems((IProblemSource)integerSetting);
        integerSetting.setValueValid(true);
        GtmProblem invalidValueProblem = problemsManager.getInvalidFieldValueProblem(integerSetting);
        if (invalidValueProblem != null) {
            problemsManager.addProblem((GenericProblem)invalidValueProblem);
            integerSetting.setValueValid(false);
        }
        if ((emptyValueProblem = problemsManager.getEmptyValueProblem(integerSetting)) != null) {
            problemsManager.addProblem((GenericProblem)emptyValueProblem);
            integerSetting.setValueValid(false);
        }
        if ((limitValueProblem = problemsManager.getLimitValueProblem(integerSetting)) != null) {
            problemsManager.addProblem((GenericProblem)limitValueProblem);
            integerSetting.setValueValid(false);
        }
    }

    public void validateAllIntegerSettings() {
        GtmStructSetting parentStruct = GtmController.getInstance().getGtmXmlConfig().getLayoutComponents().getParentLayoutContent();
        this.validateStructIntegerSettings(parentStruct);
    }

    private void validateStructIntegerSettings(GtmStructSetting structSetting) {
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            if (integerSetting.isDisabled()) continue;
            this.validateValue(integerSetting);
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.validateStructIntegerSettings(childStructSetting);
        }
    }

    public PropertyChangeListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    public PropertyChangeListener getDisableStateListener() {
        return this.disableStateChangeListener;
    }
}

