/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.states;

import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.states.GtmCurrentPaneInterruptConstraintsState;
import com.nxp.swtools.gtm.controller.states.GtmIdleConstraintsState;
import com.nxp.swtools.gtm.controller.states.GtmTreePaneInterruptConstraintsState;
import com.nxp.swtools.gtm.controller.states.IGtmConstraintsState;

public class GtmCheckingConstraintsState
implements IGtmConstraintsState {
    private GtmController gtmController;

    public GtmCheckingConstraintsState(GtmController gtmController) {
        this.gtmController = gtmController;
    }

    @Override
    public void changeInCurrentPane() {
        Thread constraintsThread = this.gtmController.getConstraintsThread();
        if (constraintsThread.isAlive()) {
            constraintsThread.interrupt();
        }
        this.gtmController.lockConstraintsLock();
        try {
            this.gtmController.changeConstraintsState(new GtmCurrentPaneInterruptConstraintsState(this.gtmController));
        }
        finally {
            this.gtmController.unlockConstraintsLock();
        }
    }

    @Override
    public void changeInTreePane() {
        Thread constraintsThread = this.gtmController.getConstraintsThread();
        if (constraintsThread.isAlive()) {
            constraintsThread.interrupt();
        }
        this.gtmController.lockConstraintsLock();
        try {
            this.gtmController.changeConstraintsState(new GtmTreePaneInterruptConstraintsState(this.gtmController));
        }
        finally {
            this.gtmController.unlockConstraintsLock();
        }
    }

    @Override
    public void updateConstraintsDeque() {
        this.gtmController.lockConstraintsLock();
        try {
            this.gtmController.changeConstraintsState(new GtmIdleConstraintsState(this.gtmController));
        }
        finally {
            this.gtmController.unlockConstraintsLock();
        }
        if (!this.gtmController.getProblemsManager().hasGtmToolErrors()) {
            this.gtmController.requestRegenerateCode();
        }
    }
}

