/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.scripting;

import com.nxp.swtools.common.uct.codegen.scripting.AUctScriptProfile;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmRegister;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@NonNullByDefault
public class GtmScriptProfile
extends AUctScriptProfile {
    private static final Logger LOGGER = LogManager.getLogger(GtmScriptProfile.class);
    private final IGtmMcu mcu;

    public GtmScriptProfile(IGtmMcu mcu) {
        this.mcu = mcu;
    }

    public String getToolName() {
        return "GTM";
    }

    public String getToolVersion() {
        SwToolsProduct gmtTool = SwToolsProductConfiguration.getRegisteredProduct((String)"GTM");
        return gmtTool == null ? "" : gmtTool.getVersion();
    }

    public IMcuInfo getMcuInfo() {
        return this.mcu;
    }

    public @Nullable IRegistersDatabaseAPI getRegistersDB() {
        return null;
    }

    public Map<String, GtmRegister> getGtmRegisters() {
        GtmUtils.calculateRegistersValue((IGtmMcu)this.mcu);
        return GtmController.getInstance().getGtmMcu().getGtmRegisters();
    }

    public @Nullable ABaseUIComponentSetting getComponentSettingById(String id) {
        return GtmUtils.getUIComponentSettingById((IGtmMcu)this.mcu, (String)id);
    }

    public @Nullable String getContentsOfTemplateFile(String filename) {
        String gtmCodeGenScriptPath = DataDirectoryUtils.getDataDir((IMcuIdentification)this.mcu.getMcuIdentification(), (String)"gtm_scripts");
        ScriptFileProvider fileProvider = new ScriptFileProvider(new String[]{gtmCodeGenScriptPath});
        File file = fileProvider.findScriptFile(filename);
        try {
            if (file != null) {
                return new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot read the template file" + e.getMessage());
        }
        return null;
    }

    public @Nullable String getSelectedCore() {
        return GtmController.getInstance().getSelectedCore();
    }

    public List<ABaseUIComponentSetting> getAllGuiComponentSettings() {
        return this.mcu.getAllGuiComponentSettings();
    }

    public List<GtmBoolSetting> getStructSettingBoolSettings(ABaseUIComponentSetting component) {
        if (component instanceof GtmStructSetting) {
            return ((GtmStructSetting)component).getBoolSettings();
        }
        return new ArrayList<GtmBoolSetting>();
    }

    public List<GtmStructSetting> castToGtmStructSettingList(List<ABaseUIComponentSetting> componentList) {
        if (!componentList.isEmpty()) {
            return componentList.stream().filter(GtmStructSetting.class::isInstance).map(GtmStructSetting.class::cast).collect(Collectors.toList());
        }
        return new ArrayList<GtmStructSetting>();
    }
}

