/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.xml.settings;

import com.nxp.swtools.common.uct.xml.settings.ConstraintsTable;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.gtm.model.xml.settings.GtmEntities;
import com.nxp.swtools.gtm.model.xml.settings.GtmLayoutComponents;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config_gtm", strict=false)
@Namespace(prefix="gtm", reference="http://swtools.freescale.net/XSD/gtm/1.0")
public class GtmXmlConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(GtmXmlConfiguration.class);
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="label", required=false)
    private String label;
    @Element(name="layout_components", required=true)
    private GtmLayoutComponents layoutComponents;
    @Element(name="constraints", required=false)
    private ConstraintsTable constraints;
    @Element(name="gtm_entities", required=false)
    private GtmEntities gtmEntities;

    public GtmXmlConfiguration(String id, String label, GtmLayoutComponents layoutComponents, ConstraintsTable constraints, GtmEntities gtmEntities) {
        this.schemaLocation = "http://swtools.freescale.net/XSD/gtm/1.0 http://swtools.freescale.net/XSD/gtm/1.0/gtm.xsd";
        this.id = id;
        this.label = label;
        this.layoutComponents = layoutComponents;
        this.constraints = constraints;
        this.gtmEntities = gtmEntities;
    }

    public GtmXmlConfiguration() {
        this.schemaLocation = "";
        this.id = "";
        this.label = "";
        this.layoutComponents = new GtmLayoutComponents();
        this.constraints = new ConstraintsTable();
        this.gtmEntities = new GtmEntities();
    }

    public GtmLayoutComponents getLayoutComponents() {
        return this.layoutComponents;
    }

    public ConstraintsTable getConstraints() {
        return this.constraints;
    }

    public GtmEntities getGtmEntities() {
        return this.gtmEntities;
    }

    public static @Nullable GtmXmlConfiguration loadGtmXmlConfig(InputStream xmlFile) {
        try {
            Persister serializer = new Persister();
            GtmXmlConfiguration gtmConfig = (GtmXmlConfiguration)serializer.read(GtmXmlConfiguration.class, xmlFile);
            return gtmConfig;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error loading the GTM definition xml. Exception: " + ex);
            return null;
        }
    }
}

