/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TextSetting;
import com.nxp.swtools.common.uct.utils.CustomMap;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.time.TimeUnit;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class GtmExpressions {
    public static final Pattern GET_DEPENDENCY_EXPR_REGEX = Pattern.compile("(getValue)\\((.+?)\\)", 32);
    public static final Pattern GET_INPUT_RESOLUTION_EXPR_REGEX = Pattern.compile("(getInputResolution)\\((.*)\\)", 8);
    public static final Pattern NUMBER_REGEX = Pattern.compile(".*\\d.*");
    public static final Pattern GET_VALUE_EXPR_REGEX = Pattern.compile("((getValue)\\((.*)\\))(>>|<<|&|\\|)?(.*[0-9])?", 8);
    public static final String MATH_OPERATIONS_REGEX = "[-+*/\\[\\]]";
    private static final Logger LOGGER = LogManager.getLogger(GtmExpressions.class);

    public static long getLongValueFromExpression(IGtmMcu selectedMcu, String expression) {
        long value;
        block17: {
            ABaseUIComponentSetting componentSetting;
            block19: {
                Matcher valueMatcher;
                block18: {
                    String componentId;
                    value = 0L;
                    valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
                    if (!valueMatcher.find() || valueMatcher.groupCount() != 5 || (componentId = valueMatcher.group(3)) == null || (componentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId)) == null) break block17;
                    if (!componentSetting.isDisabled()) break block18;
                    DisableState disableState = componentSetting.getDisableStateCondition();
                    if (disableState != null) {
                        value = disableState.getValueToWrite();
                    }
                    break block17;
                }
                String operator = valueMatcher.group(4);
                String rightOperand = valueMatcher.group(5);
                if (operator == null || rightOperand == null) break block19;
                switch (operator) {
                    case ">>": {
                        value = componentSetting.getValueToWrite() >> (int)Long.decode(rightOperand).longValue();
                        break;
                    }
                    case "<<": {
                        value = componentSetting.getValueToWrite() << (int)Long.decode(rightOperand).longValue();
                        break;
                    }
                    case "&": {
                        value = componentSetting.getValueToWrite() & Long.decode(rightOperand);
                        break;
                    }
                    case "|": {
                        value = componentSetting.getValueToWrite() | Long.decode(rightOperand);
                        break;
                    }
                    default: {
                        value = componentSetting.getValueToWrite();
                        break;
                    }
                }
                break block17;
            }
            value = componentSetting.getValueToWrite();
        }
        return value;
    }

    public static long getConstraintValueFromExpression(IGtmMcu selectedMcu, String valueExpr) {
        long value = 0L;
        Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(valueExpr);
        if (valueMatcher.find() && valueMatcher.groupCount() > 0) {
            return GtmExpressions.getLongValueFromExpression(selectedMcu, valueExpr);
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        if (engine != null) {
            try {
                String valueResult = String.valueOf(engine.eval(valueExpr));
                if (NumberFormatValidator.isValidDecimal((String)valueResult)) {
                    value = Long.parseLong(valueResult);
                }
            }
            catch (NumberFormatException | ScriptException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return value;
    }

    public static double getDoubleValueFromExpression(IGtmMcu selectedMcu, String expression) {
        String componentId;
        double value = 0.0;
        Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
        if (valueMatcher.find() && valueMatcher.groupCount() >= 3 && (componentId = valueMatcher.group(3)) != null) {
            ABaseUIComponentSetting componentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId);
            if (componentSetting instanceof TextSetting) {
                if (NumberFormatValidator.isValidHexadecimal((String)componentSetting.getCurrentValue())) {
                    value = Long.decode(componentSetting.getCurrentValue()).doubleValue();
                } else if (!componentSetting.getCurrentValue().isEmpty()) {
                    value = Double.parseDouble(componentSetting.getCurrentValue());
                }
            } else if (componentSetting != null) {
                value = Long.decode(String.valueOf(componentSetting.getValueToWrite())).doubleValue();
            }
        }
        return value;
    }

    public static String getStringValueFromExpression(IGtmMcu selectedMcu, ABaseUIComponentSetting componentSetting) {
        String valueInStringFormat = "0";
        String expression = componentSetting.getValueExpression();
        String[] expressionComponents = expression.split(MATH_OPERATIONS_REGEX);
        CustomMap expressionComponentsValues = new CustomMap();
        DecimalFormat numberFormat = new DecimalFormat("#.00");
        double currentValue = 0.0;
        int i = 0;
        while (i < expressionComponents.length) {
            block20: {
                String expressionComponent;
                block21: {
                    block22: {
                        expressionComponent = expressionComponents[i];
                        if (expressionComponent.isEmpty() || NumberFormatValidator.isValidNumerical((String)expressionComponent)) break block20;
                        Matcher valueMatcher = GET_INPUT_RESOLUTION_EXPR_REGEX.matcher(expressionComponent);
                        if (!valueMatcher.find() || valueMatcher.groupCount() != 2) break block21;
                        String parameterId = valueMatcher.group(2);
                        if (parameterId == null) break block22;
                        switch (parameterId) {
                            case "gtm_input_frequency": {
                                currentValue = GtmUtils.getGtmInputClockFreq();
                                break;
                            }
                            case "gtm_input_period": {
                                currentValue = UctUtils.getFreqToTimeConversion((double)GtmUtils.getGtmInputClockFreq(), (TimeUnit)TimeUnit.NANO_SECOND);
                                break;
                            }
                            default: {
                                currentValue = 0.0;
                            }
                        }
                    }
                    expressionComponentsValues.put((Object)expressionComponent, (Object)currentValue);
                    break block20;
                }
                currentValue = componentSetting.isDisabled() || !componentSetting.isVisible() ? 0.0 : GtmExpressions.getDoubleValueFromExpression(selectedMcu, expressionComponent);
                expressionComponentsValues.put((Object)expressionComponent, (Object)currentValue);
            }
            ++i;
        }
        if (expressionComponents.length > 1) {
            String numericalExpression = expression;
            for (Map.Entry expressionComponentVal : expressionComponentsValues.entrySet()) {
                numericalExpression = numericalExpression.replace((CharSequence)expressionComponentVal.getKey(), Double.toString((Double)expressionComponentVal.getValue()));
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            if (engine != null) {
                try {
                    currentValue = Double.parseDouble(engine.eval(numericalExpression).toString());
                    if (currentValue == Double.POSITIVE_INFINITY || currentValue == Double.NEGATIVE_INFINITY) {
                        currentValue = 0.0;
                    }
                }
                catch (ArithmeticException | NumberFormatException | ScriptException e) {
                    currentValue = 0.0;
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        componentSetting.setCurrentValue(UtilsText.safeString((String)numberFormat.format(currentValue)));
        if (componentSetting.getId().contains("frequency")) {
            valueInStringFormat = UctUtils.getFreqAutoScaleConversion((double)Double.parseDouble(componentSetting.getCurrentValue()));
        } else if (componentSetting.getId().contains("period")) {
            valueInStringFormat = UctUtils.getPeriodAutoScaleConversion((double)Double.parseDouble(componentSetting.getCurrentValue()));
        }
        return valueInStringFormat;
    }

    public static boolean hasGtmInputResolutionInExpression(IGtmMcu selectedMcu, ABaseUIComponentSetting componentSetting) {
        String expression = componentSetting.getValueExpression();
        String[] expressionComponents = expression.split(MATH_OPERATIONS_REGEX);
        int i = 0;
        while (i < expressionComponents.length) {
            String parameterId;
            Matcher valueMatcher;
            String expressionComponent = expressionComponents[i];
            if (!expressionComponent.isEmpty() && !NumberFormatValidator.isValidNumerical((String)expressionComponent) && (valueMatcher = GET_INPUT_RESOLUTION_EXPR_REGEX.matcher(expressionComponent)).find() && valueMatcher.groupCount() == 2 && ((parameterId = valueMatcher.group(2)).equals("gtm_input_frequency") || parameterId.equals("gtm_input_period"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ArrayList<String> getDependenciesFromExpression(String expression) {
        ArrayList<String> dependencyTags = new ArrayList<String>();
        Matcher matcher = GET_DEPENDENCY_EXPR_REGEX.matcher(expression);
        while (matcher.find()) {
            String matchedDependency = matcher.group(2);
            if (matchedDependency == null) continue;
            dependencyTags.add(matchedDependency);
        }
        return dependencyTags;
    }
}

