/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SingleCompositionEditor
extends Viewer {
    private FormToolkit toolkit;
    private Composite container;
    private Object input;
    private ILabelProvider labelProvider;
    private Text inputDisplay;
    private AdapterFactory adapterFactory;
    private List<SingleCompositionListener> listeners;
    private Button edit;
    private Button clear;

    public SingleCompositionEditor(Composite parent, int styles) {
        this.buildEditor(parent);
    }

    public SingleCompositionEditor(FormToolkit toolkit, Composite parent, int styles) {
        this.toolkit = toolkit;
        this.buildEditor(parent);
    }

    private void buildEditor(Composite parent) {
        this.container = this.toolkit != null ? this.toolkit.createComposite(parent) : new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        GridData comboData = new GridData(768);
        comboData.horizontalSpan = 3;
        this.inputDisplay = this.toolkit != null ? this.toolkit.createText(this.container, "") : new Text(this.container, 2048);
        this.inputDisplay.setEditable(false);
        this.inputDisplay.setLayoutData((Object)new GridData(768));
        if (this.toolkit != null) {
            this.edit = this.toolkit.createButton(this.container, "...", 8);
        } else {
            this.edit = new Button(this.container, 8);
            this.edit.setText("...");
        }
        EditingUtils.setEEFtype((Control)this.edit, "eef::SingleCompositionEditor::editbutton");
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (SingleCompositionListener listener : SingleCompositionEditor.this.listeners) {
                    listener.edit();
                }
            }
        });
        this.clear = this.toolkit != null ? this.toolkit.createButton(this.container, "", 8) : new Button(this.container, 8);
        this.clear.setImage(EEFRuntimePlugin.getImage("icons/16x16/Delete_16x16.gif"));
        EditingUtils.setEEFtype((Control)this.clear, "eef::SingleCompositionEditor::clearbutton");
        this.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (SingleCompositionListener listener : SingleCompositionEditor.this.listeners) {
                    listener.clear();
                }
            }
        });
        this.listeners = new ArrayList<SingleCompositionListener>();
    }

    public void setLayoutData(Object data) {
        this.container.setLayoutData(data);
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public Control getControl() {
        return this.container;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        Object value = this.input instanceof EEFEditorSettings ? ((EEFEditorSettings)this.input).getValue() : this.input;
        this.inputDisplay.setText(this.getLabelProvider().getText(value));
    }

    public void setInput(Object input) {
        this.input = input;
        this.refresh();
    }

    public void addEditorListener(SingleCompositionListener listener) {
        this.listeners.add(listener);
    }

    public void removeEditorListener(SingleCompositionListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private ILabelProvider getLabelProvider() {
        if (this.labelProvider != null) {
            return this.labelProvider;
        }
        if (this.adapterFactory != null) {
            this.labelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
            return this.labelProvider;
        }
        return null;
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.inputDisplay, id);
        EditingUtils.setID((Control)this.edit, id);
        EditingUtils.setID((Control)this.clear, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.inputDisplay);
    }

    public void setEnabled(boolean enabled) {
        this.edit.setEnabled(enabled);
        this.inputDisplay.setEnabled(enabled);
        this.clear.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.inputDisplay.isEnabled();
    }

    public void setToolTipText(String tooltip) {
        this.edit.setToolTipText(tooltip);
        this.clear.setToolTipText(tooltip);
        this.inputDisplay.setToolTipText(tooltip);
    }

    public static interface SingleCompositionListener {
        public void edit();

        public void clear();
    }
}

