/******************************************************************************* 
 * Copyright (c) 2016 Freescale Semiconductor, Inc.
 * Copyright 2023 NXP 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 ******************************************************************************/
package com.nxp.sa.ui.traceviewer.search.epl;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class FindCellListProgressMonitor extends AbstractFindProgressMonitor implements IRunnableWithProgress {

    List<PositionCoordinate> cellCoordinates;
    
    public FindCellListProgressMonitor(ILayer layer, IConfigRegistry configRegistry, List<PositionCoordinate> cellCoordinates, Pattern pattern, String stringValue, 
                                       Comparator<String> comparator, boolean caseSensitive, boolean wholeWord,
                                       boolean regex) {
        
        super.init(configRegistry, layer, pattern, stringValue, comparator, caseSensitive,
                   wholeWord, regex);
        this.cellCoordinates = cellCoordinates;
    }
    
    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException,
                                              InterruptedException {
        
        int totalWork = cellCoordinates.size();
        double progress = 0;
        
        setTotalWork(totalWork);
        monitor.beginTask("Searching for \"" + getTaskName() + "\"", totalWork); //$NON-NLS-1$ //$NON-NLS-2$
        
        IProgressMonitor subMonitor = new SubProgressMonitor(monitor, DEFAULT_TOTAL_WORK);
        subMonitor.beginTask("Completed 0 %", DEFAULT_TOTAL_WORK); //$NON-NLS-1$
        
        for (int cellIndex = 0; cellIndex < cellCoordinates.size(); cellIndex++) {
            final PositionCoordinate cellCoordinate = cellCoordinates
                    .get(cellIndex);
            if (TraceViewerCellDisplayValueSearchUtil.compare(layer, configRegistry, pattern, stringValue,
                    comparator, caseSensitive, wholeWord, regex,
                    cellCoordinate.columnPosition, cellCoordinate.rowPosition)) {
                setPositionCoordinate(cellCoordinate);
            }
            
            if (monitor.isCanceled()) {
                setCanceled(true);
                subMonitor.done();
                monitor.done();
                return;
            }
            
            monitor.worked(1);
            progress += 1;
            subMonitor.subTask("Completed " + getProgressPercent(progress) + "%"); //$NON-NLS-1$ //$NON-NLS-2$
        }
        
        setFinished(true);
        monitor.done();
        subMonitor.done();
        return;
    }
    

}
