/*******************************************************************************
 * Copyright (c) 2016 Freescale Semiconductor, Inc.
 * Copyright 2016-2023 NXP
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 ******************************************************************************/
package com.nxp.sa.ui.traceviewer.search.epl;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.regex.Pattern;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

import com.freescale.sa.util.CommonConstants;

public class AbstractFindProgressMonitor {
    
    protected IConfigRegistry configRegistry;
    protected ILayer layer;
    protected Pattern pattern;
    protected String stringValue;
    protected Comparator<String> comparator;
    protected boolean caseSensitive;
    protected boolean wholeWord;
    protected boolean regex;
    private PositionCoordinate pc;
    private boolean canceled;
    private boolean finished;
    
    private final NumberFormat formatter = new DecimalFormat("#0.00"); //$NON-NLS-1$
    protected final static int DEFAULT_TOTAL_WORK = 100;
    
    private int totalWork = DEFAULT_TOTAL_WORK;
    
    public void init(IConfigRegistry configRegistry, ILayer layer, Pattern pattern,
                     String stringValue, Comparator<String> comparator, boolean caseSensitive,
                     boolean wholeWord, boolean regex) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.pattern = pattern;
        this.stringValue = stringValue;
        this.comparator = comparator;
        this.caseSensitive = caseSensitive;
        this.wholeWord = wholeWord;
        this.regex = regex;
        pc = null;
        canceled = false;
        finished = false;
    }
   
    protected void setPositionCoordinate(PositionCoordinate pc) {
        this.pc = pc;
    }
    
    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
    
    protected void setFinished(boolean finished) {
        this.finished = finished; 
    }
    
    public void setTotalWork(int totalWork) {
        this.totalWork = totalWork;
    }
    
    public String getTaskName() {
        return stringValue;
    }
    
    public String getProgressPercent(double progress) {
        if (totalWork != DEFAULT_TOTAL_WORK) {
            return formatter.format((progress/totalWork) * 100);
        }
        
        return CommonConstants.EMPTY_STRING;
    }
    
    public PositionCoordinate getPositionCoordinate() {
        return pc;
    }
    
    public boolean isCanceled() {
        return canceled;
    }
    
    public boolean isFinished() {
        return finished;
    }
}
