/*******************************************************************************
 * Copyright (c) 2006 Freescale Semiconductor.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Freescale Semiconductor - initial API and implementation
 *******************************************************************************/

package com.freescale.system.browser.internal.ui.tabbed;


import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.IPageBookViewPage;

import com.freescale.system.browser.model.OSAwarenessData;


/**
 * Interface any tabbed page must implement. 
 */
public interface ITabbedPage extends IPageBookViewPage, ISelectionListener {

	/**
	 * Get the instance of the contributor that owns this page (contributes 
	 * this page to the System Browser).
	 *
	 * @return - the owner of the page, the contributor that implements the
	 *         extension points and provides the page to the System Browser View
	 */
	public ITabbedPageContributor getContributor();
	
	/**
	 * Called when the active context for the System Browser changes. That's
	 * the active debug context (the selection in the Debug view)
	 * 
	 * @param newSession the active debug context
	 */
	public void setPageInput(OSAwarenessData newSession);
}
